/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Pms1 {
    private static final double wellOverhangDiff = 6.0;
    private static final double gY = 4.0;
    private static final double dY = 11.0;
    private static final double pmosBot = 9.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        sz = stdCell.roundSize(sz);
        String nm = "pms1" + (stdCell.getDoubleStrapGate() ? "_strap" : "");
        sz = stdCell.checkMinStrength(sz, 0.5, nm);
        double outsideSpace = stdCell.getDoubleStrapGate() ? 8.5 : 6.0;
        double spaceAvail = stdCell.getCellTop() - outsideSpace - 9.0;
        double totWid = sz * 6.0;
        FoldsAndWidth fw = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Pms1.error(fw == null, "can't make Pms1 this small: " + sz);
        Cell pms1 = stdCell.findPart(nm, sz);
        if (pms1 != null) {
            return pms1;
        }
        pms1 = stdCell.newPart(nm, sz);
        double gX = 3.5;
        LayoutLib.newExport(pms1, "g", PortCharacteristic.IN, tech.m1(), 4.0, gX, 4.0);
        double mosX = gX + 2.0 + 3.0 + 2.0;
        double pmosY = 9.0 + fw.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fw.nbFolds, 1, fw.gateWid, pms1, tech);
        double dX = StdCellParams.getRightDiffX(pmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(pms1, "d", PortCharacteristic.OUT, tech.m1(), 4.0, dX, 11.0);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, pms1);
        TrackRouterH g = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, pms1);
        g.connect(pms1.findExport("g"));
        for (int i = 0; i < pmos.nbGates(); ++i) {
            g.connect(pmos.getGate(i, 'B'));
        }
        if (stdCell.getDoubleStrapGate()) {
            double vddTop = stdCell.getVddY() + stdCell.getVddWidth() / 2.0;
            double gHiFromVdd = vddTop + 3.0 + 2.0;
            double pmosTop = pmosY + fw.physWid / 2.0;
            double gHiFromMos = pmosTop + 2.0 + 2.5;
            double gHiY = Math.max(gHiFromVdd, gHiFromMos);
            TrackRouterH gHi = new TrackRouterH(tech.m1(), 3.0, gHiY, tech, pms1);
            gHi.connect(pms1.findExport("g"));
            for (int i = 0; i < pmos.nbGates(); ++i) {
                gHi.connect(pmos.getGate(i, 'T'));
            }
        }
        TrackRouterH d = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, pms1);
        d.connect(pms1.findExport("d"));
        for (int i = 1; i < pmos.nbSrcDrns(); i += 2) {
            d.connect(pmos.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = dX + 2.0 + 1.5;
        stdCell.addPmosWell(wellMinX, wellMaxX, pms1);
        stdCell.addPstackEssentialBounds(wellMinX, wellMaxX, pms1);
        stdCell.doNCC(pms1, nm + "{sch}");
        return pms1;
    }
}

