/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.LibId;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdMapper
implements Serializable {
    private final HashMap<LibId, LibId> libIdMap = new HashMap();
    private final HashMap<CellId, CellId> cellIdMap = new HashMap();
    private final HashMap<ExportId, ExportId> exportIdMap = new HashMap();

    public static IdMapper renameLibrary(Snapshot snapshot, LibId oldLibId, LibId newLibId) {
        IdMapper idMapper = new IdMapper();
        idMapper.libIdMap.put(oldLibId, newLibId);
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null) continue;
            CellId oldCellId = cellBackup.cellRevision.d.cellId;
            if (oldCellId.libId != oldLibId) continue;
            CellId newCellId = newLibId.newCellId(oldCellId.cellName);
            idMapper.moveCell(cellBackup, newCellId);
        }
        return idMapper;
    }

    public static IdMapper renameCell(Snapshot snapshot, CellId oldCellId, CellId newCellId) {
        IdMapper idMapper = new IdMapper();
        CellBackup cellBackup = snapshot.getCell(oldCellId);
        idMapper.moveCell(cellBackup, newCellId);
        return idMapper;
    }

    public static IdMapper consolidateExportIds(Snapshot snapshot) {
        IdMapper idMapper = new IdMapper();
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null) continue;
            CellRevision cellRevision = cellBackup.cellRevision;
            CellId cellId = cellRevision.d.cellId;
            for (ImmutableExport e : cellRevision.exports) {
                if (e.name.toString().equals(e.exportId.externalId)) continue;
                idMapper.exportIdMap.put(e.exportId, cellId.newPortId(e.name.toString()));
            }
        }
        return idMapper;
    }

    public void moveCell(CellBackup cellBackup, CellId newCellId) {
        CellId oldCellId = cellBackup.cellRevision.d.cellId;
        if (oldCellId.cellName.getView() != newCellId.cellName.getView() && (oldCellId.isIcon() || oldCellId.isSchematic() || newCellId.isIcon() || newCellId.isSchematic())) {
            throw new IllegalArgumentException("Can't rename " + oldCellId + " to " + newCellId);
        }
        this.cellIdMap.put(oldCellId, newCellId);
    }

    public LibId get(LibId key) {
        LibId value = this.libIdMap.get(key);
        return value != null ? value : key;
    }

    public CellId get(CellId key) {
        CellId value = this.cellIdMap.get(key);
        return value != null ? value : key;
    }

    public ExportId get(ExportId key) {
        ExportId newExportId = this.exportIdMap.get(key);
        if (newExportId != null) {
            return newExportId;
        }
        CellId newParentId = this.cellIdMap.get(key.parentId);
        return newParentId != null ? newParentId.newPortId(key.externalId) : key;
    }

    public Collection<CellId> getNewCellIds() {
        return this.cellIdMap.values();
    }
}

