/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BussedIO;
import java.util.ArrayList;
import java.util.List;

public class SimpleBus
implements BussedIO {
    private List indexNames = new ArrayList();
    private String prefix = "busNameError";

    public SimpleBus(String busName) {
        int openb = busName.lastIndexOf(91);
        if (openb == -1) {
            System.out.println("SimpleBus Error: Not a bussed signal: " + busName);
            return;
        }
        int closeb = busName.lastIndexOf(93);
        if (closeb == -1 || closeb < openb) {
            System.out.println("SimpleBus Error: Bad []'s in: " + busName);
            return;
        }
        this.prefix = busName.substring(0, openb);
        String indices = busName.substring(openb + 1, closeb);
        String[] parts = indices.split(",");
        for (int i = 0; i < parts.length; ++i) {
            this.parseArray(parts[i]);
        }
    }

    void parseArray(String arr) {
        if (arr.indexOf(58) > 0) {
            int end;
            int start;
            String[] indices = arr.split(":");
            if (indices.length != 2) {
                System.out.println("SimpleBus Error: Invalid bus spec: " + arr);
                return;
            }
            try {
                start = Integer.parseInt(indices[0]);
                end = Integer.parseInt(indices[1]);
            }
            catch (NumberFormatException e) {
                System.out.println("SimpleBus Error: Indices in range must be numeric: " + arr);
                return;
            }
            if (start > end) {
                for (int i = start; i >= end; --i) {
                    this.indexNames.add(String.valueOf(i));
                }
            } else {
                for (int i = start; i <= end; ++i) {
                    this.indexNames.add(String.valueOf(i));
                }
            }
        } else {
            this.indexNames.add(arr);
        }
    }

    public int getWidth() {
        return this.indexNames.size();
    }

    public String getName() {
        return this.prefix;
    }

    public String getSignal(int index2) {
        if (index2 < 0 || index2 >= this.indexNames.size()) {
            System.out.println("SimpleBus getSignal error: index out of range: " + index2);
            return "";
        }
        return this.prefix + '[' + this.indexNames.get(index2) + ']';
    }

    public String getSignal(String bitname) {
        for (int i = 0; i < this.indexNames.size(); ++i) {
            if (!this.indexNames.get(i).equals(bitname)) continue;
            return this.getSignal(i);
        }
        System.out.println("SimpleBus getSignal error: bitname '" + bitname + "' not found in bus " + this.prefix);
        return "";
    }

    public static void main(String[] args) {
        SimpleBus bus = new SimpleBus("top.foo.bus[1]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus[1:2]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus[1,3:4]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus[a,b,1:4]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus[5:3,b]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus");
        SimpleBus.testBus(bus);
    }

    private static void testBus(SimpleBus bus) {
        System.out.println("------------------------------------------------------");
        System.out.println("Bus " + bus.getName() + " indices: (width=" + bus.getWidth() + ")");
        for (int i = 0; i < bus.getWidth(); ++i) {
            System.out.println("  " + bus.getSignal(i));
        }
    }
}

