/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PrimitivePort
implements PortProto,
Comparable<PrimitivePort>,
Serializable {
    private final PrimitivePortId portId;
    private final Name name;
    private final PrimitiveNode parent;
    private final int portIndex;
    private final ArcProto[] portArcs;
    private final EdgeH left;
    private final EdgeV bottom;
    private final EdgeH right;
    private final EdgeV top;
    private final PortCharacteristic characteristic;
    private final int angle;
    private final int angleRange;
    private final int portTopology;
    private final boolean isolated;
    private final boolean negatable;
    private static Set<PortProto> wellPorts = null;

    protected PrimitivePort(PrimitiveNode parent, ArcProto[] portArcs, String protoName, boolean isSingle, int portAngle, int portRange, int portTopology, PortCharacteristic characteristic, boolean isolated, boolean negatable, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
        Technology tech = parent.getTechnology();
        this.name = Name.findName(protoName);
        this.portId = parent.getId().newPortId(isSingle ? "" : this.name.toString());
        this.parent = parent;
        this.portIndex = parent.getNumPorts();
        parent.addPrimitivePort(this);
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("PrimitivePort name " + protoName + " is not safe to write into JELIB");
        }
        this.angle = portAngle;
        this.angleRange = portRange;
        this.portTopology = portTopology;
        for (ArcProto ap : portArcs) {
            Technology apTech = ap.getTechnology();
            if (apTech == tech) continue;
            throw new IllegalArgumentException("portArcs in " + this.name);
        }
        if (!(tech instanceof Generic)) {
            Generic generic = tech.generic;
            ArcProto[] realPortArcs = new ArcProto[portArcs.length + 3];
            for (int i = 0; i < portArcs.length; ++i) {
                realPortArcs[i] = portArcs[i];
            }
            realPortArcs[portArcs.length] = generic.universal_arc;
            realPortArcs[portArcs.length + 1] = generic.invisible_arc;
            realPortArcs[portArcs.length + 2] = generic.unrouted_arc;
            portArcs = realPortArcs;
        }
        this.portArcs = portArcs;
        this.characteristic = characteristic;
        assert (left.getMultiplier() < right.getMultiplier() || left.getMultiplier() == right.getMultiplier() && left.getAdder().compareTo(right.getAdder()) <= 0);
        assert (bottom.getMultiplier() < top.getMultiplier() || bottom.getMultiplier() == top.getMultiplier() && bottom.getAdder().compareTo(top.getAdder()) <= 0);
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.top = top;
        this.isolated = isolated;
        this.negatable = negatable;
    }

    protected Object writeReplace() {
        return new PrimitivePortKey(this);
    }

    public static PrimitivePort newInstance(PrimitiveNode parent, ArcProto[] portArcs, String protoName, int portAngle, int portRange, int portTopology, PortCharacteristic characteristic, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
        return PrimitivePort.newInstance(parent, portArcs, protoName, false, portAngle, portRange, portTopology, characteristic, false, false, left, bottom, right, top);
    }

    public static PrimitivePort single(PrimitiveNode parent, ArcProto[] portArcs, String protoName, int portAngle, int portRange, int portTopology, PortCharacteristic characteristic, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
        return PrimitivePort.newInstance(parent, portArcs, protoName, true, portAngle, portRange, portTopology, characteristic, false, false, left, bottom, right, top);
    }

    public static PrimitivePort newInstance(PrimitiveNode parent, ArcProto[] portArcs, String protoName, boolean isSingle, int portAngle, int portRange, int portTopology, PortCharacteristic characteristic, boolean isolated, boolean negatable, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
        return new PrimitivePort(parent, portArcs, protoName, isSingle, portAngle, portRange, portTopology, characteristic, isolated, negatable, left, bottom, right, top);
    }

    @Override
    public PrimitivePortId getId() {
        return this.portId;
    }

    @Override
    public Name getNameKey() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public PrimitiveNode getParent() {
        return this.parent;
    }

    @Override
    public int getPortIndex() {
        return this.portIndex;
    }

    public ArcProto[] getConnections(TechPool allTechs) {
        if (this.parent.getTechnology().isUniversalConnectivityPort(this)) {
            return allTechs.getUnivList();
        }
        return this.portArcs;
    }

    public ArcProto[] getConnections() {
        if (this.parent.getTechnology().isUniversalConnectivityPort(this)) {
            return TechPool.getThreadTechPool().getUnivList();
        }
        return this.portArcs;
    }

    public ArcProto getConnection() {
        return this.portArcs[0];
    }

    @Override
    public PrimitivePort getBasePort() {
        return this;
    }

    public EdgeH getLeft() {
        return this.left;
    }

    public EdgeH getRight() {
        return this.right;
    }

    public EdgeV getTop() {
        return this.top;
    }

    public EdgeV getBottom() {
        return this.bottom;
    }

    @Override
    public PortCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    @Override
    public boolean isPower() {
        return this.characteristic == PortCharacteristic.PWR;
    }

    @Override
    public boolean isGround() {
        return this.characteristic == PortCharacteristic.GND;
    }

    public boolean isWellPort() {
        if (wellPorts == null) {
            wellPorts = new HashSet<PortProto>();
            Iterator<Technology> it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology tech = it.next();
                Iterator<PrimitiveNode> nIt = tech.getNodes();
                while (nIt.hasNext()) {
                    PrimitiveNode pnp = nIt.next();
                    if (!pnp.getFunction().isFET()) continue;
                    Iterator<PrimitivePort> pIt = pnp.getPrimitivePorts();
                    while (pIt.hasNext()) {
                        PrimitivePort pp = pIt.next();
                        ArcProto[] connections = pp.getConnections();
                        boolean wellPort = false;
                        for (int i = 0; i < connections.length; ++i) {
                            ArcProto con = connections[i];
                            if (con.getTechnology() == Generic.tech() || con.getFunction() != ArcProto.Function.WELL) continue;
                            wellPort = true;
                            break;
                        }
                        if (!wellPort) continue;
                        wellPorts.add(pp);
                    }
                }
            }
        }
        return wellPorts.contains(this);
    }

    public boolean isNamedGround() {
        String name = TextUtils.canonicString(this.getName());
        if (name.indexOf("vss") >= 0) {
            return true;
        }
        if (name.indexOf("gnd") >= 0) {
            return true;
        }
        return name.indexOf("ground") >= 0;
    }

    public int getAngle() {
        return this.angle;
    }

    public int getAngleRange() {
        return this.angleRange;
    }

    public int getTopology() {
        return this.portTopology;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public boolean isNegatable() {
        return this.negatable;
    }

    @Override
    public boolean connectsTo(ArcProto arc) {
        for (int i = 0; i < this.portArcs.length; ++i) {
            if (this.portArcs[i] != arc) continue;
            return true;
        }
        return this.parent.getTechnology().isUniversalConnectivityPort(this);
    }

    protected void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
        b.genShapeOfPort(n, this.parent, this);
    }

    protected void genShape(AbstractShapeBuilder b, ImmutableNodeInst n, Point2D selectPt) {
        if (selectPt == null) {
            throw new NullPointerException();
        }
        this.genShape(b, n);
    }

    public Color getPortColor(GraphicsPreferences gp) {
        Technology tech = this.getParent().getTechnology();
        int numColors = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < this.portArcs.length; ++i) {
            ArcProto ap = this.portArcs[i];
            if (ap.getTechnology() != tech) continue;
            Layer layer = ap.getLayer(0);
            EGraphics graphics = gp.getGraphics(layer);
            Color layerCol = graphics.getColor();
            r += layerCol.getRed();
            g += layerCol.getGreen();
            b += layerCol.getBlue();
            ++numColors;
        }
        if (numColors == 0) {
            return null;
        }
        return new Color(r / numColors, g / numColors, b / numColors);
    }

    @Override
    public int compareTo(PrimitivePort that) {
        int cmp;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        return this.portIndex - that.portIndex;
    }

    public String toString() {
        return "PrimitivePort " + this.getName();
    }

    void dump(PrintWriter out) {
        double xSize = this.getParent().getFullRectangle().getWidth();
        double ySize = this.getParent().getFullRectangle().getHeight();
        out.println("\tport " + this.getName() + " angle=" + this.getAngle() + " range=" + this.getAngleRange() + " topology=" + this.getTopology() + " " + (Object)((Object)this.getCharacteristic()));
        out.println("\t\tlm=" + this.left.getMultiplier() + " la=" + DBMath.round(this.left.getAdder().getLambda() - this.left.getMultiplier() * xSize) + " rm=" + this.right.getMultiplier() + " ra=" + DBMath.round(this.right.getAdder().getLambda() - this.right.getMultiplier() * xSize) + " bm=" + this.bottom.getMultiplier() + " ba=" + DBMath.round(this.bottom.getAdder().getLambda() - this.bottom.getMultiplier() * ySize) + " tm=" + this.top.getMultiplier() + " ta=" + DBMath.round(this.top.getAdder().getLambda() - this.top.getMultiplier() * ySize));
        out.println("\t\tisolated=" + this.isolated + " negatable=" + this.negatable);
        for (ArcProto ap : this.portArcs) {
            out.println("\t\tportArc " + ap.getName());
        }
    }

    Xml.PrimitivePort makeXml() {
        Xml.PrimitivePort ppd = new Xml.PrimitivePort();
        ppd.name = this.getName();
        ppd.portAngle = this.getAngle();
        ppd.portRange = this.getAngleRange();
        ppd.portTopology = this.getTopology();
        ppd.lx.k = this.getLeft().getMultiplier() * 2.0;
        ppd.lx.addLambda(DBMath.round(this.getLeft().getAdder().getLambda()));
        ppd.hx.k = this.getRight().getMultiplier() * 2.0;
        ppd.hx.addLambda(DBMath.round(this.getRight().getAdder().getLambda()));
        ppd.ly.k = this.getBottom().getMultiplier() * 2.0;
        ppd.ly.addLambda(DBMath.round(this.getBottom().getAdder().getLambda()));
        ppd.hy.k = this.getTop().getMultiplier() * 2.0;
        ppd.hy.addLambda(DBMath.round(this.getTop().getAdder().getLambda()));
        Technology tech = this.parent.getTechnology();
        for (ArcProto ap : this.getConnections()) {
            if (ap.getTechnology() != tech) continue;
            ppd.portArcs.add(ap.getName());
        }
        return ppd;
    }

    static class Serpentine
    extends PrimitivePort {
        Serpentine(PrimitiveNode parent, ArcProto[] portArcs, String protoName, boolean isSingle, int portAngle, int portRange, int portTopology, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
            super(parent, portArcs, protoName, isSingle, portAngle, portRange, portTopology, PortCharacteristic.UNKNOWN, false, false, left, bottom, right, top);
        }

        @Override
        protected void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
            NodeProto pn = this.getParent();
            AbstractShapeBuilder.SerpentineTrans std = b.newSerpentineTrans(n, (PrimitiveNode)pn, ((PrimitiveNode)pn).getNodeLayers());
            if (std.hasValidData()) {
                std.fillTransPort(this);
                return;
            }
            super.genShape(b, n);
        }
    }

    static class Polygonal
    extends PrimitivePort {
        Polygonal(PrimitiveNode parent, ArcProto[] portArcs, String protoName, boolean isSingle, int portAngle, int portRange, int portTopology, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
            super(parent, portArcs, protoName, isSingle, portAngle, portRange, portTopology, PortCharacteristic.UNKNOWN, false, false, left, bottom, right, top);
        }

        @Override
        protected void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
            EPoint[] outline = n.getTrace();
            if (outline != null) {
                int i;
                int endPortPoly = outline.length;
                for (i = 1; i < outline.length; ++i) {
                    if (outline[i] != null) continue;
                    endPortPoly = i;
                    break;
                }
                for (i = 0; i < endPortPoly; ++i) {
                    b.pushPoint(outline[i]);
                }
                Poly.Type style = ((PrimitiveNode)this.getParent()).getPrimitiveFunction(n.techBits) == PrimitiveNode.Function.NODE ? Poly.Type.FILLED : Poly.Type.OPENED;
                b.pushPoly(style, null, null, null);
                return;
            }
            super.genShape(b, n);
        }
    }

    private static class PrimitivePortKey
    extends EObjectInputStream.Key<PrimitivePort> {
        public PrimitivePortKey() {
        }

        private PrimitivePortKey(PrimitivePort pp) {
            super(pp);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, PrimitivePort pp) throws IOException {
            out.writeObject(pp.getParent());
            out.writeInt(pp.getId().chronIndex);
        }

        @Override
        public PrimitivePort readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int chronIndex;
            PrimitiveNode pn = (PrimitiveNode)in.readObject();
            PrimitivePort pp = pn.getPrimitivePortByChronIndex(chronIndex = in.readInt());
            if (pp == null) {
                throw new InvalidObjectException("primitive port not linked");
            }
            return pp;
        }
    }
}

