/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.datastructures;

import java.util.Vector;

public class Array2D<T> {
    private int wx;
    private int wy;
    private int sz;
    private Vector<T> field;
    private T defaultValue;

    public Array2D(int wx, int wy, T defaultValue, boolean fillWithDefault) {
        this.wx = wx;
        this.wy = wy;
        this.sz = this.wx * this.wy;
        this.defaultValue = defaultValue;
        this.field = new Vector(this.sz);
        this.field.setSize(this.sz);
        if (fillWithDefault) {
            this.fillWith(defaultValue);
        }
    }

    public boolean inRange(int x2, int y) {
        return x2 >= 0 && y >= 0 && x2 < this.wx && y < this.wy;
    }

    private int getOff(int x2, int y) {
        if (!this.inRange(x2, y)) {
            return -1;
        }
        int off = x2 + y * this.wx;
        assert (off >= 0 && off < this.sz);
        return off;
    }

    public T getAt(int x2, int y) {
        int off = this.getOff(x2, y);
        if (off == -1) {
            return this.defaultValue;
        }
        return this.field.elementAt(off);
    }

    public void setAt(int x2, int y, T newValue) {
        int off = this.getOff(x2, y);
        assert (off != -1);
        this.field.setElementAt(newValue, off);
    }

    public void fillWith(T fillElement) {
        for (int i = 0; i < this.sz; ++i) {
            this.field.setElementAt(fillElement, i);
        }
    }

    public Array2D<T> clone() {
        Array2D<T> n = new Array2D<T>(this.wx, this.wy, this.defaultValue, false);
        for (int i = 0; i < this.sz; ++i) {
            n.field.setElementAt(this.field.elementAt(i), i);
        }
        return n;
    }

    public int getWidthX() {
        return this.wx;
    }

    public int getWidthY() {
        return this.wy;
    }
}

