/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.geometry;

import com.sun.electric.api.minarea.geometry.Point;

public class Edge {
    private final Point head;
    private final Point tail;

    public Edge(Point tail, Point head) {
        this.tail = tail;
        this.head = head;
    }

    public Point getHead() {
        return this.head;
    }

    public Point getTail() {
        return this.tail;
    }

    public int length() {
        Point.Vector vec = this.getDirection();
        return (int)Math.sqrt(vec.getX() * vec.getX() + vec.getY() * vec.getY());
    }

    public Point.Vector getDirection() {
        Point tmp = this.head.add(this.tail.scale(-1));
        return new Point.Vector(tmp.getX(), tmp.getY());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.head == null ? 0 : this.head.hashCode());
        result = 31 * result + (this.tail == null ? 0 : this.tail.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.head == null ? other.head != null : !this.head.equals(other.head) && !this.head.equals(other.tail)) {
            return false;
        }
        return !(this.tail == null ? other.tail != null : !this.tail.equals(other.tail) && !this.tail.equals(other.head));
    }
}

