/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.EDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class AnnularRing
extends EDialog {
    private static double lastInner = 5.0;
    private static double lastOuter = 10.0;
    private static int lastSegments = 32;
    private static int lastDegrees = 360;
    private JList layerJList;
    private DefaultListModel layerModel;
    private Cell cell;
    private JButton cancel;
    private JTextField innerRadius;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane layerPane;
    private JTextField numDegrees;
    private JTextField numSegments;
    private JButton ok;
    private JTextField outerRadius;

    public static void showAnnularRingDialog() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        int total = 0;
        Iterator<PrimitiveNode> it = Technology.getCurrent().getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np.getFunction() != PrimitiveNode.Function.NODE) continue;
            ++total;
        }
        if (total == 0) {
            System.out.println("The " + Technology.getCurrent().getTechName() + " technology has no pure-layer nodes");
            return;
        }
        AnnularRing dialog = new AnnularRing((Frame)TopLevel.getCurrentJFrame(), cell);
        dialog.setVisible(true);
    }

    private AnnularRing(Frame parent, Cell cell) {
        super(parent, true);
        this.cell = cell;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        EDialog.makeTextFieldSelectAllOnTab(this.innerRadius);
        EDialog.makeTextFieldSelectAllOnTab(this.outerRadius);
        EDialog.makeTextFieldSelectAllOnTab(this.numSegments);
        EDialog.makeTextFieldSelectAllOnTab(this.numDegrees);
        Technology tech = Technology.getCurrent();
        this.layerModel = new DefaultListModel();
        this.layerJList = new JList(this.layerModel);
        this.layerJList.setSelectionMode(0);
        this.layerPane.setViewportView(this.layerJList);
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np.getFunction() != PrimitiveNode.Function.NODE) continue;
            this.layerModel.addElement(new AnnularRingNode(np));
        }
        this.layerModel.addElement(new AnnularRingNode(Generic.tech().drcNode));
        this.layerModel.addElement(new AnnularRingNode(Generic.tech().routeNode));
        this.layerModel.addElement(new AnnularRingNode(Generic.tech().afgNode));
        this.layerJList.setSelectedIndex(0);
        this.innerRadius.setText(TextUtils.formatDistance(lastInner, tech));
        this.outerRadius.setText(TextUtils.formatDistance(lastOuter, tech));
        this.numSegments.setText(Integer.toString(lastSegments));
        this.numDegrees.setText(Integer.toString(lastDegrees));
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void cacheValues() {
        Technology tech = Technology.getCurrent();
        lastInner = TextUtils.atofDistance(this.innerRadius.getText(), tech);
        lastOuter = TextUtils.atofDistance(this.outerRadius.getText(), tech);
        lastSegments = TextUtils.atoi(this.numSegments.getText());
        lastDegrees = TextUtils.atoi(this.numDegrees.getText());
    }

    private void makeRing() {
        this.cacheValues();
        if (lastSegments < 4) {
            lastSegments = 4;
        }
        if (lastDegrees <= 0) {
            lastDegrees = 360;
        }
        if (lastDegrees > 360) {
            lastDegrees = 360;
        }
        int degrees = lastDegrees * 10;
        PrimitiveNode np = ((AnnularRingNode)this.layerJList.getSelectedValue()).node;
        if (np == null) {
            return;
        }
        new MakeAnnulus(this.cell, np, lastSegments, degrees, lastInner, lastOuter).startJob();
    }

    private void initComponents() {
        this.layerPane = new JScrollPane();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.innerRadius = new JTextField();
        this.outerRadius = new JTextField();
        this.numSegments = new JTextField();
        this.numDegrees = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Annulus Construction");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AnnularRing.this.closeDialog(evt);
            }
        });
        this.layerPane.setMinimumSize(new Dimension(200, 200));
        this.layerPane.setPreferredSize(new Dimension(200, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.layerPane, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnularRing.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnularRing.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Layer to use for ring:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Inner Radius:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Outer Radius:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Number of segments:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Number of degrees:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.innerRadius.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.innerRadius, gridBagConstraints);
        this.outerRadius.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.outerRadius, gridBagConstraints);
        this.numSegments.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.numSegments, gridBagConstraints);
        this.numDegrees.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.getContentPane().add((Component)this.numDegrees, gridBagConstraints);
        this.pack();
    }

    private void okActionPerformed(ActionEvent evt) {
        this.makeRing();
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.cacheValues();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class AnnularRingNode {
        public PrimitiveNode node;

        AnnularRingNode(PrimitiveNode t) {
            this.node = t;
        }

        public String toString() {
            return this.node.getName();
        }
    }

    public static class MakeAnnulus
    extends Job {
        private Cell cell;
        private PrimitiveNode np;
        private int segments;
        private int degrees;
        private double inner;
        private double outer;
        private NodeInst ni;
        private ECoord snap;

        public MakeAnnulus(Cell cell, PrimitiveNode np, int segments, int degrees, double inner, double outer) {
            super("Make Annular Ring", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.np = np;
            this.segments = segments;
            this.degrees = degrees;
            this.inner = inner;
            this.outer = outer;
            this.ni = null;
            DRC.DRCPreferences dp = new DRC.DRCPreferences(false);
            this.snap = dp.getResolution(cell.getTechnology());
        }

        @Override
        public boolean doIt() throws JobException {
            double lY;
            double lX;
            Point2D.Double pt;
            double y;
            double x;
            int p;
            int i;
            EditingPreferences ep = this.getEditingPreferences();
            EDimension dimSnap = new EDimension(this.snap, this.snap);
            int numSegments = this.segments + 1;
            if (this.inner == 0.0 && this.degrees < 3600) {
                numSegments += 2;
            }
            if (this.inner > 0.0) {
                numSegments *= 2;
            }
            EPoint[] points = new EPoint[numSegments];
            int l = 0;
            if (this.inner > 0.0) {
                for (i = 0; i <= this.segments; ++i) {
                    p = this.degrees * i / this.segments;
                    x = this.inner * DBMath.cos(p);
                    y = this.inner * DBMath.sin(p);
                    pt = new Point2D.Double(x, y);
                    DBMath.gridAlign(pt, dimSnap);
                    points[l++] = EPoint.fromLambda(((Point2D)pt).getX(), ((Point2D)pt).getY());
                }
            }
            if (this.inner == 0.0 && this.degrees < 3600) {
                points[l++] = EPoint.fromLambda(0.0, 0.0);
            }
            for (i = this.segments; i >= 0; --i) {
                p = this.degrees * i / this.segments;
                x = this.outer * DBMath.cos(p);
                y = this.outer * DBMath.sin(p);
                pt = new Point2D.Double(x, y);
                DBMath.gridAlign(pt, dimSnap);
                points[l++] = EPoint.fromLambda(((Point2D)pt).getX(), ((Point2D)pt).getY());
            }
            if (this.inner == 0.0 && this.degrees < 3600) {
                points[l++] = EPoint.fromLambda(0.0, 0.0);
            }
            double hX = lX = points[0].getX();
            double hY = lY = points[0].getY();
            for (int i2 = 1; i2 < points.length; ++i2) {
                if (points[i2].getX() < lX) {
                    lX = points[i2].getX();
                }
                if (points[i2].getX() > hX) {
                    hX = points[i2].getX();
                }
                if (points[i2].getY() < lY) {
                    lY = points[i2].getY();
                }
                if (!(points[i2].getY() > hY)) continue;
                hY = points[i2].getY();
            }
            double cX = (lX + hX) / 2.0;
            double cY = (lY + hY) / 2.0;
            for (int i3 = 0; i3 < points.length; ++i3) {
                Point2D.Double pt2 = new Point2D.Double(points[i3].getX() - cX, points[i3].getY() - cY);
                DBMath.gridAlign(pt2, dimSnap);
                points[i3] = EPoint.fromLambda(((Point2D)pt2).getX(), ((Point2D)pt2).getY());
            }
            double sX = hX - lX;
            double sY = hY - lY;
            Point2D.Double center = new Point2D.Double(0.0, 0.0);
            this.ni = NodeInst.makeInstance(this.np, ep, center, sX, sY, this.cell);
            this.ni.setTrace(points);
            return true;
        }

        public NodeInst getNodeInst() {
            return this.ni;
        }
    }
}

