/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Command;
import gnu.jemacs.buffer.IgnoreAction;
import gnu.jemacs.lang.ELisp;
import gnu.kawa.util.RangeTable;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.Sequence;
import gnu.mapping.Named;
import gnu.mapping.Symbol;
import gnu.math.IntNum;
import gnu.text.Char;
import java.util.Enumeration;

public class EKeymap
extends RangeTable
implements Named {
    public static final EKeymap[] empty = new EKeymap[0];
    EKeymap[] parents = empty;
    public static int PRESSED = 256;
    public static int RELEASED = 512;
    Object defaultBinding;
    String name;
    public static final int metaKey = 27;
    public static EKeymap globalKeymap = new EKeymap();
    public static EKeymap metaKeymap = new EKeymap("ESC-map");
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 8;
    static final int ALT_MASK = 4;

    public EKeymap(String string) {
        this.name = string;
    }

    public EKeymap() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public final Object getDefaultBinding() {
        return this.defaultBinding;
    }

    public void setDefaultBinding(Object object2) {
        this.defaultBinding = object2;
    }

    public static int getModifiers(int n) {
        return n >> 16 & 0xFF;
    }

    public EKeymap[] getParents() {
        return this.parents;
    }

    public void setParents(EKeymap[] eKeymapArray) {
        this.parents = eKeymapArray;
    }

    public void setParent(EKeymap eKeymap) {
        this.parents = eKeymap == null ? empty : new EKeymap[]{eKeymap};
    }

    public EKeymap getParent() {
        int n = this.parents.length;
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return this.parents[0];
        }
        throw new Error("multiple parents - set getParents, not getParent");
    }

    public void setAction(int n, Object object2) {
        this.set(n, object2);
    }

    public Object get(int n, int n2, boolean bl) {
        return this.get(n | n2 << 16, bl);
    }

    protected Object get(int n, boolean bl) {
        Object object2 = super.lookup(n, null);
        if (object2 != null) {
            return object2;
        }
        if (bl && this.defaultBinding != null) {
            return this.defaultBinding;
        }
        int n2 = this.parents.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = this.parents[n3].get(n, bl);
            if (object2 != null) {
                return object2;
            }
            ++n3;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("#<keymap ");
        if (this.name != null) {
            stringBuffer.append(this.name);
            stringBuffer.append(' ');
        }
        stringBuffer.append("0x");
        stringBuffer.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public EKeymap definePrefix(int n) {
        Object object2;
        Object object3 = object2 = this.get(n, false);
        if (object2 == null) {
            EKeymap eKeymap = new EKeymap(null);
            this.set(n, eKeymap);
            return eKeymap;
        }
        if ((object2 = Command.resolveSymbol(object2)) instanceof EKeymap) {
            return (EKeymap)object2;
        }
        throw new Error("prefix command cannot override exiting action: " + object3 + " : " + object3.getClass() + " -> " + object2 + " key " + n + "=" + EKeymap.toString(n) + " in " + this);
    }

    public void defineKey(Object object2, Object object3) {
        EKeymap eKeymap = this;
        if (object2 instanceof Sequence && !(object2 instanceof LList)) {
            Sequence sequence = (Sequence)object2;
            boolean bl = object2 instanceof FString;
            int n = sequence.size();
            int n2 = 0;
            while (n2 < n) {
                Object object4 = sequence.get(n2);
                boolean bl2 = false;
                ++n2;
                int n3 = EKeymap.asKeyStroke(object4);
                if (n3 == 0) {
                    throw new Error("unknown keyspec: " + object4);
                }
                if (bl && n3 > 127 && n3 <= 255) {
                    bl2 = true;
                    n3 -= 128;
                }
                if ((EKeymap.getModifiers(n3) & 8) != 0) {
                    n3 = EKeymap.stripMeta(n3);
                    bl2 = true;
                }
                if (bl2) {
                    eKeymap = eKeymap.definePrefix(27);
                }
                if (n2 < n) {
                    eKeymap = eKeymap.definePrefix(n3);
                    continue;
                }
                eKeymap.defineKey(n3, object3);
            }
        } else {
            int n = EKeymap.asKeyStroke(object2);
            if (n == 0) {
                throw new Error("unknown keyspec: " + object2);
            }
            this.defineKey(n, object3);
        }
    }

    public void defineKey(int n, Object object2) {
        boolean bl = false;
        if ((EKeymap.getModifiers(n) & 8) != 0) {
            n = EKeymap.stripMeta(n);
            bl = true;
        }
        EKeymap eKeymap = this;
        if (bl) {
            eKeymap = eKeymap.definePrefix(27);
        }
        eKeymap.setAction(n, object2);
    }

    public static int asKeyStroke(char c, int n) {
        if (n == 1 && Character.isLetter(c)) {
            c = Character.toUpperCase(c);
            n = 0;
        }
        if (c < ' ') {
            n |= 2 | PRESSED;
            c = (char)(c == '\u0000' ? 32 : (char)(64 + (c & 0x1F)));
        }
        return c | n << 16;
    }

    public static int getKeyForName(String string) {
        int n = (string = string.toLowerCase()).length();
        if (n == 0) {
            return 0;
        }
        char c = string.charAt(0);
        if (n == 1) {
            return c;
        }
        switch (c) {
            case 'b': {
                if (string != "backspace") break;
                return 8;
            }
            case 'd': {
                if (string == "delete") {
                    return 127;
                }
                if (string != "down") break;
                return 40;
            }
            case 'e': {
                if (string != "enter") break;
                return 10;
            }
            case 'f': {
                if (n == 2) {
                    char c2 = string.charAt(1);
                    if (c2 <= '0' || c2 > '9') break;
                    return 112 + c2 - 49;
                }
                if (n != 3 || string.charAt(0) != 'f') break;
                int n2 = string.charAt(1);
                char c3 = string.charAt(2);
                if (n2 <= 48 || n2 > 57 || c3 <= '0' || c3 > '9' || (n2 = (n2 - 48) * 10 + (c3 - 48)) > 24) break;
                if (n2 <= 12) {
                    return 121 + c3 - 48;
                }
                return 61440 + n2 - 13;
            }
            case 'h': {
                if (string != "help") break;
                return 156;
            }
            case 'k': {
                if (string == "kp-left") {
                    return 226;
                }
                if (string == "kp-right") {
                    return 227;
                }
                if (string == "kp-up") {
                    return 224;
                }
                if (string == "kp-down") {
                    return 225;
                }
                if (string != "kp-delete") break;
                return 127;
            }
            case 'l': {
                if (string != "left") break;
                return 37;
            }
            case 'n': {
                if (string != "next") break;
                return 34;
            }
            case 'p': {
                if (string != "prior") break;
                return 33;
            }
            case 'r': {
                if (string == "enter") {
                    return 10;
                }
                if (string == "return") {
                    return 10;
                }
                if (string != "right") break;
                return 39;
            }
            case 't': {
                if (string != "tab") break;
                return 9;
            }
            case 'u': {
                if (string != "up") break;
                return 38;
            }
        }
        return 0;
    }

    public static int asKeyStroke(Object object2) {
        Object object3;
        int n = 0;
        while (object2 instanceof Pair) {
            object3 = (Pair)object2;
            if (((Pair)object3).cdr == LList.Empty) {
                object2 = ((Pair)object3).car;
                continue;
            }
            Object object4 = ((Pair)object3).car;
            if (object4 instanceof Symbol) {
                object4 = ((Symbol)object4).getName();
            }
            if (object4 == "control") {
                n |= 2;
            }
            if (object4 == "meta") {
                n |= 8;
            }
            if (object4 == "shift") {
                n |= 1;
            }
            if (object4 == "alt") {
                n |= 4;
            }
            object2 = ((Pair)object3).cdr;
        }
        if (object2 instanceof Char) {
            return EKeymap.asKeyStroke(((Char)object2).charValue(), n);
        }
        if (object2 instanceof IntNum) {
            return EKeymap.asKeyStroke((char)((IntNum)object2).intValue(), n);
        }
        if (object2 instanceof String || object2 instanceof Symbol) {
            Object object5 = object3 = object2 instanceof String ? (String)object2 : ((Symbol)object2).getName();
            if (((String)object3).length() == 1) {
                char c = ((String)object3).charAt(0);
                if (n == 0) {
                    return EKeymap.asKeyStroke(c, 0);
                }
                c = Character.toUpperCase(c);
                return EKeymap.asKeyStroke(c, n);
            }
            int n2 = EKeymap.getKeyForName((String)object3);
            if (n2 == 0) {
                throw new Error("unknown key-name: " + (String)object3);
            }
            return n2 | (n | PRESSED) << 16;
        }
        return 0;
    }

    public static int stripMeta(int n) {
        boolean bl;
        int n2 = EKeymap.getModifiers(n);
        if ((n2 & 8) == 0) {
            return n;
        }
        int n3 = n & 0xFFFF;
        boolean bl2 = bl = (n & RELEASED << 16) != 0;
        if (((n2 &= 0xFFFFFFF7) & 0xFFFFFFFE) != 0 || bl || n3 > 127 || n3 < 32) {
            return n3 | (n2 | RELEASED) << 16;
        }
        if (n3 >= 65 && n3 <= 90 && n2 != 1) {
            n3 = n3 + 97 - 65;
        }
        return n3;
    }

    public static boolean ignorable(int n) {
        if ((n & RELEASED << 16) != 0) {
            return true;
        }
        int n2 = EKeymap.getModifiers(n);
        int n3 = n & 0xFFFF;
        if ((n & PRESSED << 16) == 0) {
            char c = (char)n;
            return c < ' ' || c >= '\u007f';
        }
        if (n3 == 17 || n3 == 16 || n3 == 18 || n3 == 157) {
            return true;
        }
        return (n2 & 0xFFFFFFFE) == 0 && n3 >= 32 && n3 < 127;
    }

    public static String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if ((n >> 16 & (PRESSED | RELEASED)) == 0) {
            stringBuffer.append("char:'");
            ELisp.readableChar((char)n, stringBuffer, true);
            stringBuffer.append("'");
        } else {
            stringBuffer.append("code:");
            stringBuffer.append(n & 0xFFFF);
        }
        int n2 = n >> 16 & 0xFF;
        if (n2 != 0) {
            stringBuffer.append(" mods:");
            stringBuffer.append(n2);
        }
        if ((n & RELEASED << 16) != 0) {
            stringBuffer.append(" release");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Object lookupKey(Sequence sequence, boolean bl) {
        int n = sequence.size();
        int[] nArray = new int[n];
        Enumeration enumeration = sequence.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n2] = EKeymap.asKeyStroke(enumeration.nextElement());
            ++n2;
        }
        return this.lookupKey(nArray, n, 0, bl);
    }

    public Object lookupKey(int[] nArray, int n, int n2, boolean bl) {
        EKeymap eKeymap = this;
        int n3 = n + (n2 != 0 ? 1 : 0);
        boolean bl2 = false;
        if (n3 == 0) {
            throw new Error("no keys");
        }
        int n4 = 0;
        while (true) {
            Object object2;
            Object object3;
            int n5;
            int n6 = n5 = n4 == n ? n2 : nArray[n4];
            if (bl2) {
                n5 |= (8 | PRESSED) << 16;
            }
            if ((object3 = eKeymap.get(n5, false)) == null && (EKeymap.getModifiers(n5) & 8) != 0 && (object2 = eKeymap.get(27, false)) instanceof EKeymap) {
                object3 = ((EKeymap)object2).get(EKeymap.stripMeta(n5), false);
            }
            ++n4;
            if (object3 == null) {
                if (EKeymap.ignorable(n2)) {
                    return IgnoreAction.getInstance();
                }
                return eKeymap.getDefaultBinding();
            }
            if (n4 == n3) {
                return object3;
            }
            if (object3 instanceof String || object3 instanceof Symbol) {
                object3 = Command.resolveSymbol(object3);
            }
            if (!(object3 instanceof EKeymap)) break;
            eKeymap = (EKeymap)object3;
        }
        return null;
    }

    static {
        globalKeymap.setAction(27, metaKeymap);
    }
}

