// Copyright (c) 2003  Per M.A. Bothner.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package gnu.kawa.xml;
import gnu.bytecode.*;
import gnu.mapping.*;
import gnu.expr.*;

/** Sort argument nodes in document order.
 * Implements the standard XQuery function distinct-nodes.
 * Uses the SortedNodes class to do the actual work. */

public class SortNodes extends Procedure1 implements Inlineable
{
  public static final SortNodes sortNodes = new SortNodes();

  public Object apply1 (Object values)
  {
    SortedNodes nodes = new SortedNodes();
    Values.writeValues(values, nodes);
    if (nodes.count > 1)
      return nodes;
    else if (nodes.count == 0)
      return Values.empty;
    else
      return nodes.get(0);
  }

  public void compile (ApplyExp exp, Compilation comp, Target target)
  {
    Expression[] args = exp.getArgs();
    if (args.length != 1)
      ApplyExp.compile(exp, comp, target);
    else
      ConsumerTarget.compileUsingConsumer(args[0], comp, target,
					  makeSortedNodesMethod,
					  canonicalizeMethod);
  }

  public Type getReturnType (Expression[] args)
  {
    return Compilation.typeObject;
  }

  public static final ClassType typeSortedNodes
    = ClassType.make("gnu.kawa.xml.SortedNodes");
  public static final Method makeSortedNodesMethod
    = typeSortedNodes.getDeclaredMethod("<init>", 0);
  public static final Method canonicalizeMethod
    = Compilation.typeValues.getDeclaredMethod("canonicalize", 0);
}
