/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Expression;
import gnu.expr.ScopeExp;
import gnu.kawa.io.BinaryInPort;
import gnu.kawa.io.InPort;
import gnu.kawa.io.Path;
import gnu.kawa.lispexpr.LispReader;
import gnu.lists.EmptyList;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.Sequence;
import gnu.text.Lexer;
import java.io.InputStream;
import java.nio.charset.Charset;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class Include
extends Syntax {
    boolean ignoreCase;
    boolean relative;
    public static final Object[] currentFirst = new Object[]{Path.PATH_CURRENT, Path.PATH_RELATIVE};
    public static final Object[] relativeFirst = new Object[]{Path.PATH_RELATIVE, Path.PATH_CURRENT};
    public static final Include include = new Include("include", false, false);
    public static final Include includeRelative = new Include("include-relative", true, false);
    public static final Include includeCi = new Include("include-ci", true, true);

    public Include(String name, boolean relative, boolean ignoreCase) {
        super(name);
        this.relative = relative;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public void scanForm(Pair st, ScopeExp defs2, Translator tr) {
        Object[] searchPath = this.relative ? relativeFirst : currentFirst;
        Include.process(st.getCdr(), tr, defs2, this.ignoreCase, searchPath);
    }

    @Override
    public Expression rewrite(Object obj, Translator tr) {
        Object[] searchPath = this.relative ? relativeFirst : currentFirst;
        return tr.rewrite_body(Include.process(obj, tr, null, this.ignoreCase, searchPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LList process(Object rest, Translator tr, ScopeExp defs2, boolean ignoreCase, Object[] searchPath) {
        LList result = LList.Empty;
        Pair lastPair = null;
        while (rest instanceof Pair) {
            BinaryInPort inp;
            String fname;
            Object[] found;
            Pair pair = (Pair)rest;
            Object paircar = pair.getCar();
            Object savePos1 = tr.pushPositionOf(pair);
            if (!(paircar instanceof CharSequence)) {
                tr.error('e', "include parameters must be strings");
            }
            if ((found = Path.search(searchPath, fname = paircar.toString(), tr.getFileName())) == null) {
                tr.error('e', "cannot open file \"" + fname + "\"");
                return result;
            }
            InputStream istrm = (InputStream)found[0];
            Path path = (Path)found[1];
            try {
                inp = BinaryInPort.openHeuristicFile(istrm, path);
            }
            catch (Exception ex) {
                tr.error('e', "error reading file \"" + path + "\": " + ex.getMessage());
                return result;
            }
            tr.popPositionOf(savePos1);
            LispReader reader = new LispReader(inp, tr.getMessages());
            if (ignoreCase) {
                reader.setReadCase('D');
            }
            Lexer saveLexer = tr.lexer;
            tr.lexer = reader;
            try {
                Charset saveCset;
                InPort savePort;
                if (inp.getCharset() == null && saveLexer != null && (savePort = saveLexer.getPort()) instanceof BinaryInPort && (saveCset = ((BinaryInPort)savePort).getCharset()) != null) {
                    inp.setDefaultCharset(saveCset);
                }
                while (true) {
                    Object sexp;
                    block18: {
                        try {
                            sexp = reader.readCommand();
                            if (sexp != Sequence.eofValue) break block18;
                            break;
                        }
                        catch (Exception ex) {
                            tr.error('e', "error reading file \"" + path + "\": " + ex.getMessage());
                            EmptyList emptyList = result;
                            tr.lexer = saveLexer;
                            return emptyList;
                        }
                    }
                    if (defs2 != null) {
                        tr.scanForm(sexp, defs2);
                        continue;
                    }
                    Pair npair = new Pair(sexp, LList.Empty);
                    if (lastPair == null) {
                        result = npair;
                    } else {
                        lastPair.setCdrBackdoor(npair);
                    }
                    lastPair = npair;
                }
            }
            finally {
                tr.lexer = saveLexer;
            }
            rest = pair.getCdr();
        }
        if (rest != LList.Empty) {
            tr.error('e', "improper list");
        }
        return result;
    }
}

