<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

	class MySqlCommand
	{
		// Properties
		public $Connection;
		public $CommandText;
		public $CommandType;

		// Constructor
		public function __construct()
		{
			$numargs = func_num_args();
			$args = func_get_args();

			switch($numargs)
			{
				case 1:

					$this->Connection = $args[0];
					$this->CommandText = '';
					$this->CommandType = CommandType::Text;

					break;

				default:

					$this->CommandText = '';
					$this->CommandType = CommandType::Text;

					break;
			}
		}

		// Methods
		public function ExecuteNonQuery()
		{
			return $this->Connection->multi_query($this->CommandText);
		}

		public function ExecuteScalar()
		{
			if($this->Connection->multi_query($this->CommandText))
			{
				$result = $this->Connection->store_result();
				$row = $result->fetch_row();

				return $row[0];
			}

			return null;
		}
	}

?>
