/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class NetCell {
    static final int VALID = 1;
    static final int LOCALVALID = 2;
    final Cell cell;
    int flags;
    int modCount = 0;
    int[] equivPorts;
    int[] ni_pi;
    int arcsOffset;
    private int[] headConn;
    private int[] tailConn;
    int[] drawns;
    int numDrawns;
    Map netNames = new HashMap();
    private int netNameCount;
    int exportedNetNameCount;
    Netlist userNetlist;
    private static PortProto busPinPort = Schematics.tech.busPinNode.getPort(0);
    private static ArcProto busArc = Schematics.tech.bus_arc;

    NetCell() {
        this.cell = null;
    }

    NetCell(Cell cell) {
        this.cell = cell;
        Network.setCell(cell, this);
    }

    final void setNetworksDirty() {
        if ((this.flags & 2) != 0) {
            this.setInvalid(true);
        }
    }

    Netlist getUserNetlist() {
        if ((this.flags & 1) == 0) {
            this.redoNetworks();
        }
        return this.userNetlist;
    }

    Iterator getNodables() {
        return this.cell.getNodes();
    }

    Global.Set getGlobals() {
        return Global.Set.empty;
    }

    void setInvalid(boolean strong) {
        if (strong) {
            this.flags &= 0xFFFFFFFD;
        }
        if ((this.flags & 1) == 0) {
            return;
        }
        this.flags &= 0xFFFFFFFE;
        this.invalidateUsagesOf(false);
    }

    void invalidateUsagesOf(boolean strong) {
        Iterator it = this.cell.getUsagesOf();
        while (it.hasNext()) {
            NetCell netCell;
            NodeUsage nu = (NodeUsage)it.next();
            if (nu.isIconOfParent() || (netCell = Network.getNetCell(nu.getParent())) == null) continue;
            netCell.setInvalid(strong);
        }
    }

    int getNetMapOffset(Global global) {
        return -1;
    }

    int getNetMapOffset(Nodable no, PortProto portProto, int busIndex) {
        NodeInst ni = (NodeInst)no;
        return this.drawns[this.ni_pi[ni.getNodeIndex()] + portProto.getPortIndex()];
    }

    int getNetMapOffset(Export export, int busIndex) {
        return this.drawns[export.getPortIndex()];
    }

    int getNetMapOffset(ArcInst ai, int busIndex) {
        return this.drawns[this.arcsOffset + ai.getArcIndex()];
    }

    Name getBusName(ArcInst ai) {
        return null;
    }

    public int getBusWidth(ArcInst ai) {
        int drawn = this.drawns[this.arcsOffset + ai.getArcIndex()];
        if (drawn < 0) {
            return 0;
        }
        return 1;
    }

    private void checkLayoutCell() {
        int numNodes = this.cell.getNumNodes();
        for (int i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            if (!ni.getNameKey().isBus()) continue;
            String msg = "Network: Layout cell " + this.cell.describe() + " has arrayed node " + ni.describe();
            System.out.println(msg);
            ErrorLogger.ErrorLog log = Network.errorLogger.logError(msg, this.cell, 1);
            log.addGeom(ni, true, this.cell, null);
        }
        Iterator it = this.cell.getUsagesIn();
        while (it.hasNext()) {
            NodeInst ni;
            Iterator nit;
            ErrorLogger.ErrorLog log;
            String msg;
            NodeUsage nu = (NodeUsage)it.next();
            NodeProto np = nu.getProto();
            boolean err = false;
            if (np instanceof Cell && Network.getNetCell((Cell)np) instanceof NetSchem) {
                msg = "Network: Layout cell " + this.cell.describe() + " has " + nu.getNumInsts() + " " + np.describe() + " nodes";
                System.out.println(msg);
                log = Network.errorLogger.logError(msg, this.cell, 1);
                nit = nu.getInsts();
                while (nit.hasNext()) {
                    ni = (NodeInst)nit.next();
                    log.addGeom(ni, true, this.cell, null);
                }
                err = true;
            }
            if (np == Generic.tech.universalPinNode) {
                msg = "Network: Layout cell " + this.cell.describe() + " has " + nu.getNumInsts() + " " + np.describe() + " nodes";
                System.out.println(msg);
                log = Network.errorLogger.logError(msg, this.cell, 1);
                nit = nu.getInsts();
                while (nit.hasNext()) {
                    ni = (NodeInst)nit.next();
                    log.addGeom(ni, true, this.cell, null);
                }
                err = true;
            }
            if (!(np instanceof PrimitiveNode) || np.getTechnology() != Schematics.tech) continue;
            msg = "Network: Layout cell " + this.cell.describe() + " has " + nu.getNumInsts() + " " + np.describe() + " nodes";
            System.out.println(msg);
            log = Network.errorLogger.logError(msg, this.cell, 1);
            nit = nu.getInsts();
            while (nit.hasNext()) {
                ni = (NodeInst)nit.next();
                log.addGeom(ni, true, this.cell, null);
            }
            err = true;
        }
    }

    private void initConnections() {
        int i;
        int numPorts = this.cell.getNumPorts();
        int numNodes = this.cell.getNumNodes();
        int numArcs = this.cell.getNumArcs();
        if (this.ni_pi == null || this.ni_pi.length != numNodes) {
            this.ni_pi = new int[numNodes];
        }
        int offset = numPorts;
        for (i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            this.ni_pi[i] = offset;
            offset += ni.getProto().getNumPorts();
        }
        this.arcsOffset = offset;
        if (this.headConn == null || this.headConn.length != (offset += numArcs)) {
            this.headConn = new int[offset];
            this.tailConn = new int[offset];
            this.drawns = new int[offset];
        }
        for (i = numPorts; i < this.arcsOffset; ++i) {
            this.headConn[i] = i;
            this.tailConn[i] = i;
        }
        for (i = 0; i < numPorts; ++i) {
            int portOffset = i;
            Export export = (Export)this.cell.getPort(i);
            int orig = this.getPortInstOffset(export.getOriginalPort());
            this.headConn[portOffset] = this.headConn[orig];
            this.headConn[orig] = portOffset;
            this.tailConn[portOffset] = -1;
        }
        for (i = 0; i < this.cell.getNumArcs(); ++i) {
            ArcInst ai = this.cell.getArc(i);
            int arcOffset = this.arcsOffset + i;
            int head = this.getPortInstOffset(ai.getHead().getPortInst());
            this.headConn[arcOffset] = this.headConn[head];
            this.headConn[head] = arcOffset;
            int tail = this.getPortInstOffset(ai.getTail().getPortInst());
            this.tailConn[arcOffset] = this.tailConn[tail];
            this.tailConn[tail] = arcOffset;
        }
    }

    private void showConnections() {
        int numNodes = this.cell.getNumNodes();
        for (int i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            int numPortInsts = ni.getProto().getNumPorts();
            for (int j = 0; j < numPortInsts; ++j) {
                int piOffset;
                PortInst pi = ni.getPortInst(j);
                System.out.println("Connections of " + pi);
                int k = piOffset = this.getPortInstOffset(pi);
                while (this.headConn[k] != piOffset) {
                    if ((k = this.headConn[k]) >= this.arcsOffset) {
                        System.out.println("\thead_arc\t" + this.cell.getArc(k - this.arcsOffset).describe());
                        continue;
                    }
                    System.out.println("\tport\t" + this.cell.getPort(k));
                }
                k = piOffset;
                while (this.tailConn[k] != piOffset) {
                    k = this.tailConn[k];
                    System.out.println("\ttail_arc\t" + this.cell.getArc(k - this.arcsOffset).describe());
                }
            }
        }
    }

    private void addToDrawn1(PortInst pi) {
        ArcProto ap;
        ArcInst ai;
        int piOffset = this.getPortInstOffset(pi);
        if (this.drawns[piOffset] >= 0) {
            return;
        }
        PortProto pp = pi.getPortProto();
        if (pp.isIsolated()) {
            return;
        }
        this.drawns[piOffset] = this.numDrawns;
        if (Network.debug) {
            System.out.println(this.numDrawns + ": " + pi);
        }
        int k = piOffset;
        while (this.headConn[k] != piOffset) {
            PortInst tpi;
            if (this.drawns[k = this.headConn[k]] >= 0) continue;
            if (k < this.arcsOffset) {
                this.drawns[k] = this.numDrawns;
                if (!Network.debug) continue;
                System.out.println(this.numDrawns + ": " + this.cell.getPort(k));
                continue;
            }
            ai = this.cell.getArc(k - this.arcsOffset);
            ap = ai.getProto();
            if (ap.getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k] = this.numDrawns;
            if (Network.debug) {
                System.out.println(this.numDrawns + ": " + ai.describe());
            }
            if ((tpi = ai.getTail().getPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.addToDrawn(tpi);
        }
        k = piOffset;
        while (this.tailConn[k] != piOffset) {
            PortInst hpi;
            if (this.drawns[k = this.tailConn[k]] >= 0 || (ap = (ai = this.cell.getArc(k - this.arcsOffset)).getProto()).getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k] = this.numDrawns;
            if (Network.debug) {
                System.out.println(this.numDrawns + ": " + ai.describe());
            }
            if ((hpi = ai.getHead().getPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.addToDrawn(hpi);
        }
    }

    private void addToDrawn(PortInst pi) {
        PortProto pp = pi.getPortProto();
        NodeProto np = pp.getParent();
        int numPorts = np.getNumPorts();
        if (numPorts == 1 || np instanceof Cell) {
            this.addToDrawn1(pi);
            return;
        }
        NodeInst ni = pi.getNodeInst();
        if (np == Schematics.tech.resistorNode && Network.shortResistors) {
            this.addToDrawn1(ni.getPortInst(0));
            this.addToDrawn1(ni.getPortInst(1));
            return;
        }
        int topology = pp.getTopology();
        for (int i = 0; i < numPorts; ++i) {
            if (np.getPort(i).getTopology() != topology) continue;
            this.addToDrawn1(ni.getPortInst(i));
        }
    }

    void makeDrawns() {
        int i;
        this.initConnections();
        Arrays.fill(this.drawns, -1);
        this.numDrawns = 0;
        int numPorts = this.cell.getNumPorts();
        int numNodes = this.cell.getNumNodes();
        int numArcs = this.cell.getNumArcs();
        for (i = 0; i < numPorts; ++i) {
            if (this.drawns[i] >= 0) continue;
            this.drawns[i] = this.numDrawns++;
            Export export = (Export)this.cell.getPort(i);
            this.addToDrawn(export.getOriginalPort());
        }
        for (i = 0; i < numArcs; ++i) {
            PortInst tpi;
            PortInst hpi;
            ArcInst ai;
            ArcProto ap;
            if (this.drawns[this.arcsOffset + i] >= 0 || (ap = (ai = this.cell.getArc(i)).getProto()).getFunction() == ArcProto.Function.NONELEC) continue;
            this.drawns[this.arcsOffset + i] = this.numDrawns;
            if (Network.debug) {
                System.out.println(this.numDrawns + ": " + ai.describe());
            }
            if ((hpi = ai.getHead().getPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(hpi);
            }
            if ((tpi = ai.getTail().getPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(tpi);
            }
            ++this.numDrawns;
        }
        for (i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            NodeProto np = ni.getProto();
            int numPortInsts = np.getNumPorts();
            for (int j = 0; j < numPortInsts; ++j) {
                ErrorLogger.ErrorLog log;
                String msg;
                PortInst pi = ni.getPortInst(j);
                int piOffset = this.getPortInstOffset(pi);
                if (ni.isIconOfParent() || np.getFunction() == NodeProto.Function.ART && np != Generic.tech.simProbeNode || np == Artwork.tech.pinNode || np == Generic.tech.invisiblePinNode) {
                    if (this.drawns[piOffset] < 0 || this.cell.isIcon()) continue;
                    msg = "Network: " + this.cell + " has connections on " + pi;
                    System.out.println(msg);
                    log = Network.errorLogger.logError(msg, this.cell, 1);
                    log.addPoly(pi.getPoly(), true, this.cell);
                    continue;
                }
                if (this.drawns[piOffset] >= 0 || pi.getPortProto().isIsolated()) continue;
                if (np.getFunction() == NodeProto.Function.PIN) {
                    msg = "Network: " + this.cell + " has unconnected pin " + pi.describe();
                    System.out.println(msg);
                    log = Network.errorLogger.logError(msg, this.cell, 1);
                    log.addGeom(ni, true, this.cell, null);
                }
                this.addToDrawn(pi);
                ++this.numDrawns;
            }
        }
    }

    void showDrawns() {
        PrintWriter out;
        String filePath = "tttt";
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(filePath, true)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + filePath);
            return;
        }
        out.println("Drawns " + this.cell);
        int numPorts = this.cell.getNumPorts();
        for (int drawn = 0; drawn < this.numDrawns; ++drawn) {
            for (int i = 0; i < this.drawns.length; ++i) {
                int k;
                if (this.drawns[i] != drawn) continue;
                if (i < numPorts) {
                    out.println(drawn + ": " + this.cell.getPort(i));
                    continue;
                }
                if (i >= this.arcsOffset) {
                    out.println(drawn + ": " + this.cell.getArc(i - this.arcsOffset));
                    continue;
                }
                for (k = 1; k < this.cell.getNumNodes() && this.ni_pi[k] <= i; ++k) {
                }
                NodeInst ni = this.cell.getNode(--k);
                PortInst pi = ni.getPortInst(i - this.ni_pi[k]);
                out.println(drawn + ": " + pi);
            }
        }
        out.close();
    }

    void initNetnames() {
        NetName nn;
        Iterator it = this.netNames.values().iterator();
        while (it.hasNext()) {
            nn = (NetName)it.next();
            nn.name = null;
            nn.index = -1;
        }
        this.netNameCount = 0;
        it = this.cell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            this.addNetNames(e.getNameKey());
        }
        this.exportedNetNameCount = this.netNameCount;
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC) continue;
            if (ai.getNameKey().isBus() && ai.getProto() != busArc) {
                String msg = "Network: " + this.cell + " has bus name <" + ai.getNameKey() + "> on arc that is not a bus";
                System.out.println(msg);
                ErrorLogger.ErrorLog log = Network.errorLogger.logError(msg, this.cell, 0);
                log.addGeom(ai, true, this.cell, null);
            }
            if (!ai.isUsernamed()) continue;
            this.addNetNames(ai.getNameKey());
        }
        it = this.netNames.values().iterator();
        while (it.hasNext()) {
            nn = (NetName)it.next();
            if (nn.name == null) {
                it.remove();
                continue;
            }
            if (!Network.debug) continue;
            System.out.println("NetName " + nn.name + " " + nn.index);
        }
        if (this.netNameCount != this.netNames.size()) {
            System.out.println("Error netNameCount in NetCell.initNetnames");
        }
    }

    void addNetNames(Name name) {
        if (name.isBus()) {
            System.out.println("Network: Layout cell " + this.cell.describe() + " has bus port/arc " + name);
        }
        this.addNetName(name);
    }

    void addNetName(Name name) {
        NetName nn = (NetName)this.netNames.get(name);
        if (nn == null) {
            nn = new NetName();
            this.netNames.put(name.lowerCase(), nn);
        }
        if (nn.index < 0) {
            nn.name = name;
            nn.index = this.netNameCount++;
        }
    }

    private void internalConnections() {
        Iterator it = this.cell.getNodes();
        while (it.hasNext()) {
            NetCell netCell;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || (netCell = Network.getNetCell((Cell)np)) instanceof NetSchem) continue;
            int[] eq = netCell.equivPorts;
            int nodeOffset = this.ni_pi[ni.getNodeIndex()];
            for (int i = 0; i < eq.length; ++i) {
                if (eq[i] == i) continue;
                this.userNetlist.connectMap(this.drawns[nodeOffset + i], this.drawns[nodeOffset + eq[i]]);
            }
        }
    }

    final int getPortInstOffset(PortInst pi) {
        return this.ni_pi[pi.getNodeInst().getNodeIndex()] + pi.getPortProto().getPortIndex();
    }

    int getPortOffset(int portIndex, int busIndex) {
        return busIndex == 0 ? portIndex : -1;
    }

    NetSchem getSchem() {
        return null;
    }

    private void buildNetworkList() {
        int drawn;
        ArcInst ai;
        int i;
        this.userNetlist.initNetworks();
        JNetwork[] netNameToNet = new JNetwork[this.netNames.size()];
        int numPorts = this.cell.getNumPorts();
        for (int i2 = 0; i2 < numPorts; ++i2) {
            Export e = (Export)this.cell.getPort(i2);
            this.setNetName(netNameToNet, this.drawns[i2], e.getNameKey(), true);
        }
        int numArcs = this.cell.getNumArcs();
        for (i = 0; i < numArcs; ++i) {
            ai = this.cell.getArc(i);
            if (!ai.isUsernamed() || (drawn = this.drawns[this.arcsOffset + i]) < 0) continue;
            this.setNetName(netNameToNet, drawn, ai.getNameKey(), false);
        }
        for (i = 0; i < numArcs; ++i) {
            JNetwork network;
            ai = this.cell.getArc(i);
            drawn = this.drawns[this.arcsOffset + i];
            if (drawn < 0 || (network = this.userNetlist.getNetworkByMap(drawn)).hasNames()) continue;
            network.addName(ai.getName(), false);
        }
    }

    private void setNetName(JNetwork[] netNamesToNet, int drawn, Name name, boolean exported) {
        JNetwork network = this.userNetlist.getNetworkByMap(drawn);
        NetName nn = (NetName)this.netNames.get(name);
        if (netNamesToNet[nn.index] != null) {
            if (netNamesToNet[nn.index] == network) {
                return;
            }
            String msg = "Network: Layout cell " + this.cell.describe() + " has nets with same name " + name;
            System.out.println(msg);
            ErrorLogger.ErrorLog log = Network.errorLogger.logError(msg, this.cell, 0);
            int numPorts = this.cell.getNumPorts();
            for (int i = 0; i < numPorts; ++i) {
                Export e = (Export)this.cell.getPort(i);
                if (!e.getName().equals(name.toString())) continue;
                log.addExport(e, true, this.cell, null);
            }
            int numArcs = this.cell.getNumArcs();
            for (int i = 0; i < numArcs; ++i) {
                ArcInst ai = this.cell.getArc(i);
                if (!ai.isUsernamed() || !ai.getName().equals(name.toString())) continue;
                log.addGeom(ai, true, this.cell, null);
            }
        } else {
            netNamesToNet[nn.index] = network;
        }
        network.addName(name.toString(), exported);
    }

    private boolean updateInterface() {
        boolean changed = false;
        int numPorts = this.cell.getNumPorts();
        if (this.equivPorts == null || this.equivPorts.length != numPorts) {
            changed = true;
            this.equivPorts = new int[numPorts];
        }
        int[] netToPort = new int[numPorts];
        Arrays.fill(netToPort, -1);
        for (int i = 0; i < numPorts; ++i) {
            int net = this.userNetlist.netMap[this.drawns[i]];
            if (netToPort[net] < 0) {
                netToPort[net] = i;
            }
            if (this.equivPorts[i] == netToPort[net]) continue;
            changed = true;
            this.equivPorts[i] = netToPort[net];
        }
        return changed;
    }

    private void showEquivPorts() {
        System.out.println("Equivalent ports of " + this.cell);
        String s = "\t";
        Export[] ports = new Export[this.cell.getNumPorts()];
        int i = 0;
        Iterator it = this.cell.getPorts();
        while (it.hasNext()) {
            ports[i] = (Export)it.next();
            ++i;
        }
        for (i = 0; i < this.equivPorts.length; ++i) {
            Export pi = ports[i];
            if (this.equivPorts[i] != i) continue;
            boolean found = false;
            for (int j = i + 1; j < this.equivPorts.length; ++j) {
                if (this.equivPorts[i] != this.equivPorts[j]) continue;
                Export pj = ports[j];
                if (!found) {
                    s = s + " ( " + pi.getName();
                }
                found = true;
                s = s + " " + pj.getName();
            }
            s = found ? s + ")" : s + " " + pi.getName();
        }
        System.out.println(s);
    }

    void redoNetworks() {
        if ((this.flags & 1) != 0) {
            return;
        }
        Network.errorLogger.clearErrors(this.cell);
        Iterator it = this.cell.getUsagesIn();
        while (it.hasNext()) {
            NodeProto np;
            NodeUsage nu = (NodeUsage)it.next();
            if (nu.isIconOfParent() || !((np = nu.getProto()) instanceof Cell)) continue;
            NetCell netCell = Network.getNetCell((Cell)np);
            if ((netCell.flags & 1) != 0) continue;
            netCell.redoNetworks();
        }
        NetSchem schem = this.getSchem();
        if (schem != null && schem != this) {
            schem.redoNetworks();
        }
        if ((this.flags & 2) != 0) {
            this.flags |= 1;
            return;
        }
        this.makeDrawns();
        this.initNetnames();
        if (this.userNetlist == null) {
            this.userNetlist = new Netlist(this);
        }
        if (this.redoNetworks1()) {
            this.invalidateUsagesOf(true);
        }
        this.flags |= 3;
    }

    boolean redoNetworks1() {
        this.checkLayoutCell();
        this.userNetlist.initNetMap(this.numDrawns);
        this.internalConnections();
        this.buildNetworkList();
        return this.updateInterface();
    }

    static class NetName {
        Name name;
        int index = -1;

        NetName() {
        }
    }
}

