/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.tool.generator.layout.CapCell;
import com.sun.electric.tool.generator.layout.CapFloorplan;
import com.sun.electric.tool.generator.layout.FillCell;
import com.sun.electric.tool.generator.layout.Floorplan;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.MetalFloorplan;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TiledCell;

public class FillGenerator {
    private static final double m1via = 4.0;
    private static final double m1sp = 3.0;
    private static final double m1SP = 6.0;
    private static final double m6via = 5.0;
    private static final double m6sp = 4.0;
    private static final double m6SP = 8.0;
    private double width = Double.NaN;
    private double height = Double.NaN;
    private String libName;
    private Library lib;
    private boolean libInitialized;
    private boolean evenLayersHorizontal;
    private double[] vddReserved = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] gndReserved = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private StdCellParams stdCell;
    private StdCellParams stdCellP;
    private CapCell capCell;
    private CapCell capCellP;
    private Floorplan[] plans;
    public static final Units LAMBDA = Units.LAMBDA;
    public static final Units TRACKS = Units.TRACKS;
    public static final PowerType POWER = PowerType.POWER;
    public static final PowerType VDD = PowerType.VDD;
    public static final ExportConfig PERIMETER = ExportConfig.PERIMETER;
    public static final ExportConfig PERIMETER_AND_INTERNAL = ExportConfig.PERIMETER_AND_INTERNAL;

    private double reservedToLambda(int layer, double reserved, Units units) {
        if (units == LAMBDA) {
            return reserved;
        }
        double nbTracks = reserved;
        if (nbTracks == 0.0) {
            return 0.0;
        }
        if (layer != 6) {
            return 9.0 + nbTracks * 7.0;
        }
        return 12.0 + nbTracks * 9.0;
    }

    private Floorplan[] makeFloorplans() {
        LayoutLib.error(this.width == Double.NaN, "width hasn't been specified. use setWidth()");
        LayoutLib.error(this.height == Double.NaN, "height hasn't been specified. use setHeight()");
        double w = this.width;
        double h = this.height;
        double[] vddRes = this.vddReserved;
        double[] gndRes = this.gndReserved;
        boolean evenHor = this.evenLayersHorizontal;
        return new Floorplan[]{null, new CapFloorplan(w, h, !evenHor), new MetalFloorplan(w, h, vddRes[2], gndRes[2], 6.0, evenHor), new MetalFloorplan(w, h, vddRes[3], gndRes[3], 6.0, !evenHor), new MetalFloorplan(w, h, vddRes[4], gndRes[4], 6.0, evenHor), new MetalFloorplan(w, h, vddRes[5], gndRes[5], 6.0, !evenHor), new MetalFloorplan(w, h, vddRes[6], gndRes[6], 8.0, evenHor)};
    }

    private void printCoverage(Floorplan[] plans) {
        for (int i = 2; i < plans.length; ++i) {
            System.out.println("metal-" + i + " coverage: " + ((MetalFloorplan)plans[i]).coverage);
        }
    }

    private void initFillParameters() {
        if (this.libInitialized) {
            return;
        }
        LayoutLib.error(this.libName == null, "no library specified. Use setFillLibrary()");
        this.plans = this.makeFloorplans();
        this.printCoverage(this.plans);
        this.lib = LayoutLib.openLibForWrite(this.libName, this.libName + ".elib");
        this.stdCell = new StdCellParams(null);
        this.stdCellP = new StdCellParams(null);
        this.stdCellP.setVddExportName("power");
        this.stdCellP.setVddExportRole(PortProto.Characteristic.IN);
        this.capCell = new CapCell(this.lib, (CapFloorplan)this.plans[1], this.stdCell);
        this.capCellP = new CapCell(this.lib, (CapFloorplan)this.plans[1], this.stdCellP);
        this.libInitialized = true;
    }

    private void changeWarning() {
        LayoutLib.error(this.libInitialized, "fill cells with different widths, heights, orientations, or space reservations must be placed in a different library.\nchange the library first before changing any of these fill cell characteristics.");
    }

    private void makeTiledCells(Cell cell, Floorplan[] plans, Library lib, int[] tiledSizes, StdCellParams stdCell) {
        if (tiledSizes == null) {
            return;
        }
        for (int i = 0; i < tiledSizes.length; ++i) {
            int num = tiledSizes[i];
            TiledCell.makeTiledCell(num, num, cell, plans, lib, stdCell);
        }
    }

    private void makeAndTileCell(Library lib, Floorplan[] plans, int lowLay, int hiLay, CapCell capCell, boolean wireLowest, int[] tiledSizes, StdCellParams stdCell) {
        Cell c = FillCell.makeFillCell(lib, plans, lowLay, hiLay, capCell, wireLowest, stdCell);
        this.makeTiledCells(c, plans, lib, tiledSizes, stdCell);
    }

    public void setFillLibrary(String libName) {
        this.libName = libName;
        this.libInitialized = false;
    }

    public Library getFillLibrary() {
        return this.lib;
    }

    public void setFillCellWidth(double w) {
        this.changeWarning();
        this.width = w;
    }

    public void setFillCellHeight(double h) {
        this.changeWarning();
        this.height = h;
    }

    public void makeEvenLayersHorizontal(boolean b) {
        this.changeWarning();
        this.evenLayersHorizontal = b;
    }

    public void reserveSpaceOnLayer(int layer, double vddReserved, Units vddUnits, double gndReserved, Units gndUnits) {
        LayoutLib.error(layer < 2 || layer > 6, "Bad layer. Layers must be between 2 and 6 inclusive: " + layer);
        this.vddReserved[layer] = this.reservedToLambda(layer, vddReserved, vddUnits);
        this.gndReserved[layer] = this.reservedToLambda(layer, gndReserved, gndUnits);
    }

    public void makeFillCell(int loLayer, int hiLayer, ExportConfig exportConfig, PowerType powerType, int[] tiledSizes) {
        boolean wireLowest;
        this.initFillParameters();
        LayoutLib.error(loLayer < 1, "loLayer must be >=1");
        LayoutLib.error(hiLayer > 6, "hiLayer must be <=6");
        LayoutLib.error(loLayer > hiLayer, "loLayer must be <= hiLayer");
        boolean bl = wireLowest = exportConfig == PERIMETER_AND_INTERNAL;
        if (powerType == VDD) {
            this.makeAndTileCell(this.lib, this.plans, loLayer, hiLayer, this.capCell, wireLowest, tiledSizes, this.stdCell);
        } else {
            this.makeAndTileCell(this.lib, this.plans, loLayer, hiLayer, this.capCellP, wireLowest, tiledSizes, this.stdCellP);
        }
    }

    public void makeGallery() {
        Gallery.makeGallery(this.lib);
    }

    public static class ExportConfig {
        public static final ExportConfig PERIMETER = new ExportConfig();
        public static final ExportConfig PERIMETER_AND_INTERNAL = new ExportConfig();

        private ExportConfig() {
        }
    }

    public static class PowerType {
        public static final PowerType POWER = new PowerType();
        public static final PowerType VDD = new PowerType();

        private PowerType() {
        }
    }

    public static class Units {
        public static final Units LAMBDA = new Units();
        public static final Units TRACKS = new Units();

        private Units() {
        }
    }
}

