/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.dialogs.ColorPatternPanel;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LayersTab
extends PreferencePanel {
    static HashMap layerMap;
    private ColorPatternPanel colorPatternPanel;
    private JComboBox layerName;
    private JLabel layerTechName;
    private JPanel layers;

    public LayersTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.layers;
    }

    public String getName() {
        return "Layers";
    }

    public void init() {
        layerMap = new HashMap();
        this.layerTechName.setText("For " + this.curTech.getTechName() + " layer:");
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            this.layerName.addItem(layer.getName());
            ColorPatternPanel.Info li = new ColorPatternPanel.Info(layer.getGraphics());
            layerMap.put(layer, li);
        }
        this.layerName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayersTab.this.layerSelected();
            }
        });
        this.colorPatternPanel = new ColorPatternPanel(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.colorPatternPanel, gbc);
        this.layerSelected();
    }

    private void layerSelected() {
        String name = (String)this.layerName.getSelectedItem();
        Layer layer = this.curTech.findLayer(name);
        ColorPatternPanel.Info li = (ColorPatternPanel.Info)layerMap.get(layer);
        if (li == null) {
            return;
        }
        this.colorPatternPanel.setColorPattern(li);
    }

    public void term() {
        boolean changed = false;
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            ColorPatternPanel.Info li = (ColorPatternPanel.Info)layerMap.get(layer);
            if (!li.updateGraphics()) continue;
            changed = true;
        }
        if (changed) {
            TopLevel.getPaletteFrame().loadForTechnology();
            EditWindow.repaintAllContents();
        }
    }

    private void initComponents() {
        this.layers = new JPanel();
        this.layerName = new JComboBox();
        this.layerTechName = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LayersTab.this.closeDialog(evt);
            }
        });
        this.layers.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerName, gridBagConstraints);
        this.layerTechName.setText("For xxxxx layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerTechName, gridBagConstraints);
        this.getContentPane().add((Component)this.layers, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

