/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import [Ljava.lang.Integer;;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Tool;
import java.lang.reflect.Method;
import java.util.Date;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class IOTool
extends Tool {
    public static IOTool tool = new IOTool();
    public static final Variable.Key IO_TRUE_LIBRARY = ElectricObject.newKey("IO_true_library");
    private static boolean skillChecked = false;
    private static Class skillClass = null;
    private static Method skillOutputMethod;
    private static Pref cacheBackupRedundancy;
    private static Pref cacheUseCopyrightMessage;
    private static Pref cacheCopyrightMessage;
    private static Pref cachePlotArea;
    private static Pref cachePlotDate;
    private static Pref cachePrinterName;
    private static Pref cacheCIFOutMimicsDisplay;
    private static Pref cacheCIFOutMergesBoxes;
    private static Pref cacheCIFOutInstantiatesTopLevel;
    private static Pref cacheCIFOutCheckResolution;
    private static Pref cacheCIFOutResolution;
    private static Pref cacheCIFInSquaresWires;
    private static Pref cacheDEFLogicalPlacement;
    private static Pref cacheDEFPhysicalPlacement;
    private static Pref cacheGDSOutMergesBoxes;
    private static Pref cacheGDSOutWritesExportPins;
    private static Pref cacheGDSOutUpperCase;
    private static Pref cacheGDSOutDefaultTextLayer;
    private static Pref cacheGDSInIncludesText;
    private static Pref cacheGDSInExpandsCells;
    private static Pref cacheGDSInInstantiatesArrays;
    private static Pref cacheGDSInIgnoresUnknownLayers;
    private static Pref cachePrintEncapsulated;
    private static Pref cachePrintResolution;
    private static Pref cachePrintForPlotter;
    private static Pref cachePrintWidth;
    private static Pref cachePrintHeight;
    private static Pref cachePrintMargin;
    private static Pref cachePrintRotation;
    private static Pref cachePrintColorMethod;
    public static final Variable.Key POSTSCRIPT_EPS_SCALE;
    public static final Variable.Key POSTSCRIPT_FILENAME;
    public static final Variable.Key POSTSCRIPT_FILEDATE;
    private static Pref cacheEDIFUseSchematicView;
    private static Pref cacheEDIFInputScale;
    private static Pref cacheDXFInputFlattensHierarchy;
    private static Pref cacheDXFInputReadsAllLayers;
    private static Pref cacheDXFScale;
    private static Pref cacheSueUses4PortTransistors;
    private static Pref cacheSkillExcludesSubcells;
    private static Pref cacheSkillFlattensHierarchy;

    protected IOTool() {
        super("io");
    }

    public static boolean hasSkill() {
        if (!skillChecked) {
            skillChecked = true;
            try {
                skillClass = Class.forName("com.sun.electric.plugins.skill.Skill");
            }
            catch (ClassNotFoundException e) {
                skillClass = null;
                return false;
            }
            try {
                skillOutputMethod = skillClass.getMethod("writeSkillFile", Cell.class, String.class);
            }
            catch (NoSuchMethodException e) {
                skillClass = null;
                return false;
            }
        }
        return skillClass != null;
    }

    public static void writeSkill(Cell cell, String fileName) {
        if (!IOTool.hasSkill()) {
            return;
        }
        try {
            skillOutputMethod.invoke((Object)skillClass, cell, fileName);
        }
        catch (Exception e) {
            System.out.println("Unable to run the Skill output module");
        }
    }

    public static int getBackupRedundancy() {
        return cacheBackupRedundancy.getInt();
    }

    public static void setBackupRedundancy(int r) {
        cacheBackupRedundancy.setInt(r);
    }

    public static boolean isUseCopyrightMessage() {
        return cacheUseCopyrightMessage.getBoolean();
    }

    public static void setUseCopyrightMessage(boolean u) {
        cacheUseCopyrightMessage.setBoolean(u);
    }

    public static String getCopyrightMessage() {
        return cacheCopyrightMessage.getString();
    }

    public static void setCopyrightMessage(String m) {
        cacheCopyrightMessage.setString(m);
    }

    public static int getPlotArea() {
        return cachePlotArea.getInt();
    }

    public static void setPlotArea(int pa) {
        cachePlotArea.setInt(pa);
    }

    public static boolean isPlotDate() {
        return cachePlotDate.getBoolean();
    }

    public static void setPlotDate(boolean pd) {
        cachePlotDate.setBoolean(pd);
    }

    private static Pref getCachePrinterName() {
        if (cachePrinterName == null) {
            PrintService defPrintService = PrintServiceLookup.lookupDefaultPrintService();
            cachePrinterName = defPrintService == null ? Pref.makeStringPref("PrinterName", IOTool.tool.prefs, "") : Pref.makeStringPref("PrinterName", IOTool.tool.prefs, defPrintService.getName());
        }
        return cachePrinterName;
    }

    public static String getPrinterName() {
        return IOTool.getCachePrinterName().getString();
    }

    public static void setPrinterName(String pName) {
        IOTool.getCachePrinterName().setString(pName);
    }

    public static boolean isCIFOutMimicsDisplay() {
        return cacheCIFOutMimicsDisplay.getBoolean();
    }

    public static void setCIFOutMimicsDisplay(boolean on) {
        cacheCIFOutMimicsDisplay.setBoolean(on);
    }

    public static boolean isCIFOutMergesBoxes() {
        return cacheCIFOutMergesBoxes.getBoolean();
    }

    public static void setCIFOutMergesBoxes(boolean on) {
        cacheCIFOutMergesBoxes.setBoolean(on);
    }

    public static boolean isCIFOutInstantiatesTopLevel() {
        return cacheCIFOutInstantiatesTopLevel.getBoolean();
    }

    public static void setCIFOutInstantiatesTopLevel(boolean on) {
        cacheCIFOutInstantiatesTopLevel.setBoolean(on);
    }

    public static boolean isCIFOutCheckResolution() {
        return cacheCIFOutCheckResolution.getBoolean();
    }

    public static void setCIFOutCheckResolution(boolean c) {
        cacheCIFOutCheckResolution.setBoolean(c);
    }

    public static double getCIFOutResolution() {
        return cacheCIFOutResolution.getDouble();
    }

    public static void setCIFOutResolution(double r) {
        cacheCIFOutResolution.setDouble(r);
    }

    public static boolean isCIFInSquaresWires() {
        return cacheCIFInSquaresWires.getBoolean();
    }

    public static void setCIFInSquaresWires(boolean s) {
        cacheCIFInSquaresWires.setBoolean(s);
    }

    public static boolean isDEFLogicalPlacement() {
        return cacheDEFLogicalPlacement.getBoolean();
    }

    public static void setDEFLogicalPlacement(boolean on) {
        cacheDEFLogicalPlacement.setBoolean(on);
    }

    public static boolean isDEFPhysicalPlacement() {
        return cacheDEFPhysicalPlacement.getBoolean();
    }

    public static void setDEFPhysicalPlacement(boolean on) {
        cacheDEFPhysicalPlacement.setBoolean(on);
    }

    public static boolean isGDSOutMergesBoxes() {
        return cacheGDSOutMergesBoxes.getBoolean();
    }

    public static void setGDSOutMergesBoxes(boolean on) {
        cacheGDSOutMergesBoxes.setBoolean(on);
    }

    public static boolean isGDSOutWritesExportPins() {
        return cacheGDSOutWritesExportPins.getBoolean();
    }

    public static void setGDSOutWritesExportPins(boolean on) {
        cacheGDSOutWritesExportPins.setBoolean(on);
    }

    public static boolean isGDSOutUpperCase() {
        return cacheGDSOutUpperCase.getBoolean();
    }

    public static void setGDSOutUpperCase(boolean on) {
        cacheGDSOutUpperCase.setBoolean(on);
    }

    public static int getGDSOutDefaultTextLayer() {
        return cacheGDSOutDefaultTextLayer.getInt();
    }

    public static void setGDSOutDefaultTextLayer(int num) {
        cacheGDSOutDefaultTextLayer.setInt(num);
    }

    public static boolean isGDSInIncludesText() {
        return cacheGDSInIncludesText.getBoolean();
    }

    public static void setGDSInIncludesText(boolean on) {
        cacheGDSInIncludesText.setBoolean(on);
    }

    public static boolean isGDSInExpandsCells() {
        return cacheGDSInExpandsCells.getBoolean();
    }

    public static void setGDSInExpandsCells(boolean on) {
        cacheGDSInExpandsCells.setBoolean(on);
    }

    public static boolean isGDSInInstantiatesArrays() {
        return cacheGDSInInstantiatesArrays.getBoolean();
    }

    public static void setGDSInInstantiatesArrays(boolean on) {
        cacheGDSInInstantiatesArrays.setBoolean(on);
    }

    public static boolean isGDSInIgnoresUnknownLayers() {
        return cacheGDSInIgnoresUnknownLayers.getBoolean();
    }

    public static void setGDSInIgnoresUnknownLayers(boolean on) {
        cacheGDSInIgnoresUnknownLayers.setBoolean(on);
    }

    public static boolean isPrintEncapsulated() {
        return cachePrintEncapsulated.getBoolean();
    }

    public static void setPrintEncapsulated(boolean on) {
        cachePrintEncapsulated.setBoolean(on);
    }

    public static int getPrintResolution() {
        return cachePrintResolution.getInt();
    }

    public static void setPrintResolution(int r) {
        cachePrintResolution.setInt(r);
    }

    public static boolean isPrintForPlotter() {
        return cachePrintForPlotter.getBoolean();
    }

    public static void setPrintForPlotter(boolean on) {
        cachePrintForPlotter.setBoolean(on);
    }

    public static double getPrintWidth() {
        return cachePrintWidth.getDouble();
    }

    public static void setPrintWidth(double wid) {
        cachePrintWidth.setDouble(wid);
    }

    public static double getPrintHeight() {
        return cachePrintHeight.getDouble();
    }

    public static void setPrintHeight(double hei) {
        cachePrintHeight.setDouble(hei);
    }

    public static double getPrintMargin() {
        return cachePrintMargin.getDouble();
    }

    public static void setPrintMargin(double mar) {
        cachePrintMargin.setDouble(mar);
    }

    public static int getPrintRotation() {
        return cachePrintRotation.getInt();
    }

    public static void setPrintRotation(int rot) {
        cachePrintRotation.setInt(rot);
    }

    public static int getPrintColorMethod() {
        return cachePrintColorMethod.getInt();
    }

    public static void setPrintColorMethod(int cm) {
        cachePrintColorMethod.setInt(cm);
    }

    public static double getPrintEPSScale(Cell cell) {
        Variable var = cell.getVar(POSTSCRIPT_EPS_SCALE);
        if (var != null) {
            Object obj = var.getObject();
            String desc = obj.toString();
            double epsScale = TextUtils.atof(desc);
            return epsScale;
        }
        return 1.0;
    }

    public static void setPrintEPSScale(Cell cell, double scale) {
        tool.setVarInJob(cell, POSTSCRIPT_EPS_SCALE, new Double(scale));
    }

    public static String getPrintEPSSynchronizeFile(Cell cell) {
        Variable var = cell.getVar(POSTSCRIPT_FILENAME);
        if (var != null) {
            Object obj = var.getObject();
            String desc = obj.toString();
            return desc;
        }
        return "";
    }

    public static void setPrintEPSSynchronizeFile(Cell cell, String syncFile) {
        tool.setVarInJob(cell, POSTSCRIPT_FILENAME, syncFile);
    }

    public static Date getPrintEPSSavedDate(Cell cell) {
        Variable varDate = cell.getVar(POSTSCRIPT_FILEDATE, Integer;.class);
        if (varDate == null) {
            return null;
        }
        Integer[] lastSavedDateAsInts = (Integer[])varDate.getObject();
        long lastSavedDateInSeconds = (long)lastSavedDateAsInts[0].intValue() << 32 | (long)(lastSavedDateAsInts[1] & 0xFFFFFFFF);
        Date lastSavedDate = new Date(lastSavedDateInSeconds);
        return lastSavedDate;
    }

    public static void setPrintEPSSavedDate(Cell cell, Date date) {
        long iVal = date.getTime();
        Integer[] dateArray = new Integer[]{new Integer((int)(iVal >> 32)), new Integer((int)(iVal & 0xFFFFFFFFFFFFFFFFL))};
        tool.setVarInJob(cell, POSTSCRIPT_FILEDATE, dateArray);
    }

    public static boolean isEDIFUseSchematicView() {
        return cacheEDIFUseSchematicView.getBoolean();
    }

    public static void setEDIFUseSchematicView(boolean f) {
        cacheEDIFUseSchematicView.setBoolean(f);
    }

    public static double getEDIFInputScale() {
        return cacheEDIFInputScale.getDouble();
    }

    public static void setEDIFInputScale(double f) {
        cacheEDIFInputScale.setDouble(f);
    }

    public static boolean isDXFInputFlattensHierarchy() {
        return cacheDXFInputFlattensHierarchy.getBoolean();
    }

    public static void setDXFInputFlattensHierarchy(boolean f) {
        cacheDXFInputFlattensHierarchy.setBoolean(f);
    }

    public static boolean isDXFInputReadsAllLayers() {
        return cacheDXFInputReadsAllLayers.getBoolean();
    }

    public static void setDXFInputReadsAllLayers(boolean a) {
        cacheDXFInputReadsAllLayers.setBoolean(a);
    }

    public static int getDXFScale() {
        return cacheDXFScale.getInt();
    }

    public static void setDXFScale(int s) {
        cacheDXFScale.setInt(s);
    }

    public static boolean isSueUses4PortTransistors() {
        return cacheSueUses4PortTransistors.getBoolean();
    }

    public static void setSueUses4PortTransistors(boolean on) {
        cacheSueUses4PortTransistors.setBoolean(on);
    }

    public static boolean isSkillExcludesSubcells() {
        return cacheSkillExcludesSubcells.getBoolean();
    }

    public static void setSkillExcludesSubcells(boolean on) {
        cacheSkillExcludesSubcells.setBoolean(on);
    }

    public static boolean isSkillFlattensHierarchy() {
        return cacheSkillFlattensHierarchy.getBoolean();
    }

    public static void setSkillFlattensHierarchy(boolean on) {
        cacheSkillFlattensHierarchy.setBoolean(on);
    }

    static {
        cacheBackupRedundancy = Pref.makeIntPref("OutputBackupRedundancy", IOTool.tool.prefs, 0);
        cacheUseCopyrightMessage = Pref.makeBooleanPref("UseCopyrightMessage", IOTool.tool.prefs, false);
        cacheUseCopyrightMessage.attachToObject(tool, "General/Copyright tab", "Use copyright message");
        cacheCopyrightMessage = Pref.makeStringPref("CopyrightMessage", IOTool.tool.prefs, "");
        cacheCopyrightMessage.attachToObject(tool, "General/Copyright tab", "Copyright message");
        cachePlotArea = Pref.makeIntPref("PlotArea", IOTool.tool.prefs, 0);
        cachePlotDate = Pref.makeBooleanPref("PlotDate", IOTool.tool.prefs, false);
        cachePrinterName = null;
        cacheCIFOutMimicsDisplay = Pref.makeBooleanPref("CIFMimicsDisplay", IOTool.tool.prefs, false);
        cacheCIFOutMimicsDisplay.attachToObject(tool, "IO/CIF tab", "CIF output mimics display");
        cacheCIFOutMergesBoxes = Pref.makeBooleanPref("CIFMergesBoxes", IOTool.tool.prefs, false);
        cacheCIFOutMergesBoxes.attachToObject(tool, "IO/CIF tab", "CIF output merges boxes");
        cacheCIFOutInstantiatesTopLevel = Pref.makeBooleanPref("CIFInstantiatesTopLevel", IOTool.tool.prefs, true);
        cacheCIFOutInstantiatesTopLevel.attachToObject(tool, "IO/CIF tab", "CIF output instantiates top level");
        cacheCIFOutCheckResolution = Pref.makeBooleanPref("CIFCheckResolution", IOTool.tool.prefs, false);
        cacheCIFOutResolution = Pref.makeDoublePref("CIFResolution", IOTool.tool.prefs, 0.0);
        cacheCIFInSquaresWires = Pref.makeBooleanPref("CIFInSquaresWires", IOTool.tool.prefs, true);
        cacheDEFLogicalPlacement = Pref.makeBooleanPref("DEFLogicalPlacement", IOTool.tool.prefs, true);
        cacheDEFPhysicalPlacement = Pref.makeBooleanPref("DEFPhysicalPlacement", IOTool.tool.prefs, true);
        cacheGDSOutMergesBoxes = Pref.makeBooleanPref("GDSMergesBoxes", IOTool.tool.prefs, false);
        cacheGDSOutMergesBoxes.attachToObject(tool, "IO/GDS tab", "GDS output merges boxes");
        cacheGDSOutWritesExportPins = Pref.makeBooleanPref("GDSWritesExportPins", IOTool.tool.prefs, false);
        cacheGDSOutWritesExportPins.attachToObject(tool, "IO/GDS tab", "GDS output writes export pins");
        cacheGDSOutUpperCase = Pref.makeBooleanPref("GDSOutputUpperCase", IOTool.tool.prefs, false);
        cacheGDSOutUpperCase.attachToObject(tool, "IO/GDS tab", "GDS output all upper-case");
        cacheGDSOutDefaultTextLayer = Pref.makeIntPref("GDSDefaultTextLayer", IOTool.tool.prefs, 230);
        cacheGDSOutDefaultTextLayer.attachToObject(tool, "IO/GDS tab", "GDS output default text layer");
        cacheGDSInIncludesText = Pref.makeBooleanPref("GDSInIncludesText", IOTool.tool.prefs, false);
        cacheGDSInExpandsCells = Pref.makeBooleanPref("GDSInExpandsCells", IOTool.tool.prefs, false);
        cacheGDSInInstantiatesArrays = Pref.makeBooleanPref("GDSInInstantiatesArrays", IOTool.tool.prefs, true);
        cacheGDSInIgnoresUnknownLayers = Pref.makeBooleanPref("GDSInIgnoresUnknownLayers", IOTool.tool.prefs, false);
        cachePrintEncapsulated = Pref.makeBooleanPref("PostScriptEncapsulated", IOTool.tool.prefs, false);
        cachePrintResolution = Pref.makeIntPref("PrintResolution", IOTool.tool.prefs, 300);
        cachePrintForPlotter = Pref.makeBooleanPref("PostScriptForPlotter", IOTool.tool.prefs, false);
        cachePrintWidth = Pref.makeDoublePref("PostScriptWidth", IOTool.tool.prefs, 8.5);
        cachePrintHeight = Pref.makeDoublePref("PostScriptHeight", IOTool.tool.prefs, 11.0);
        cachePrintMargin = Pref.makeDoublePref("PostScriptMargin", IOTool.tool.prefs, 0.75);
        cachePrintRotation = Pref.makeIntPref("PostScriptRotation", IOTool.tool.prefs, 0);
        cachePrintColorMethod = Pref.makeIntPref("PostScriptColorMethod", IOTool.tool.prefs, 0);
        POSTSCRIPT_EPS_SCALE = ElectricObject.newKey("IO_postscript_EPS_scale");
        POSTSCRIPT_FILENAME = ElectricObject.newKey("IO_postscript_filename");
        POSTSCRIPT_FILEDATE = ElectricObject.newKey("IO_postscript_filedate");
        cacheEDIFUseSchematicView = Pref.makeBooleanPref("EDIFUseSchematicView", IOTool.tool.prefs, false);
        cacheEDIFInputScale = Pref.makeDoublePref("EDIFInputScale", IOTool.tool.prefs, 1.0);
        cacheDXFInputFlattensHierarchy = Pref.makeBooleanPref("DXFInputFlattensHierarchy", IOTool.tool.prefs, true);
        cacheDXFInputReadsAllLayers = Pref.makeBooleanPref("DXFInputReadsAllLayers", IOTool.tool.prefs, false);
        cacheDXFScale = Pref.makeIntPref("DXFScale", IOTool.tool.prefs, 2);
        cacheSueUses4PortTransistors = Pref.makeBooleanPref("SueUses4PortTransistors", IOTool.tool.prefs, false);
        cacheSkillExcludesSubcells = Pref.makeBooleanPref("SkillExcludesSubcells", IOTool.tool.prefs, false);
        cacheSkillFlattensHierarchy = Pref.makeBooleanPref("SkillFlattensHierarchy", IOTool.tool.prefs, false);
    }
}

