/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.Main;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.FindText;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class EditWindow
extends JPanel
implements WindowContent,
MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
ActionListener,
HighlightListener,
DatabaseChangeListener {
    private double scale;
    private double offx = 0.0;
    private double offy = 0.0;
    private Rectangle2D databaseBounds;
    private Dimension sz;
    private Cell cell;
    private int pageNumber;
    private boolean inPlaceDisplay;
    private AffineTransform intoCell;
    private AffineTransform outofCell;
    private Cell topLevelCell;
    private List inPlaceDescent;
    private VarContext cellVarContext;
    private WindowFrame wf;
    private PixelDrawing offscreen = null;
    private JPanel overall;
    private JScrollBar bottomScrollBar;
    private JScrollBar rightScrollBar;
    private boolean showGrid = false;
    private double gridXSpacing;
    private double gridYSpacing;
    private boolean doingAreaDrag = false;
    private Point startDrag = new Point();
    private Point endDrag = new Point();
    private boolean showPopupCloud = false;
    private List popupCloudText;
    private Point2D popupCloudPoint;
    private Highlighter highlighter;
    private Highlighter mouseOverHighlighter;
    private static List redrawThese = new ArrayList();
    private static List windowChangeRequests = new ArrayList();
    private static EditWindow runningNow = null;
    private static final int SCROLLBARRESOLUTION = 200;
    private static final BasicStroke selectionLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 3.0f);
    private static final BasicStroke inPlaceMarker = new BasicStroke(3.0f);
    private static EditWindowDropTarget editWindowDropTarget = new EditWindowDropTarget();
    private int lastXPosition;
    private int lastYPosition;
    private List crossProbeObjects = new ArrayList();
    private List foundInCell;
    private StringsInCell currentStringInCell;
    private int currentFindPosition;
    private static final double scrollPagePercent = 0.2;
    private boolean ignoreScrollChange = false;
    private static final int scrollRangeMult = 100;
    private List cellHistory;
    private int cellHistoryLocation;
    public static final String propGoBackEnabled = "GoBackEnabled";
    public static final String propGoForwardEnabled = "GoForwardEnabled";
    private static final int cellHistoryLimit = 20;

    private EditWindow(Cell cell, WindowFrame wf) {
        this.cell = cell;
        this.pageNumber = 0;
        this.wf = wf;
        this.gridXSpacing = User.getDefGridXSpacing();
        this.gridYSpacing = User.getDefGridYSpacing();
        this.inPlaceDisplay = false;
        this.sz = new Dimension(500, 500);
        this.setSize(this.sz.width, this.sz.height);
        this.setPreferredSize(this.sz);
        this.databaseBounds = new Rectangle2D.Double();
        this.cellHistory = new ArrayList();
        this.cellHistoryLocation = -1;
        this.scale = 1.0;
        this.overall = new JPanel();
        this.overall.setLayout(new GridBagLayout());
        int thumbSize = 10;
        this.bottomScrollBar = new JScrollBar(0, 100, thumbSize, 0, 200 + thumbSize);
        this.bottomScrollBar.setBlockIncrement(40);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.overall.add((Component)this.bottomScrollBar, gbc);
        this.bottomScrollBar.addAdjustmentListener(new ScrollAdjustmentListener(this));
        this.bottomScrollBar.setValue(this.bottomScrollBar.getMaximum() / 2);
        this.rightScrollBar = new JScrollBar(1, 100, thumbSize, 0, 200 + thumbSize);
        this.rightScrollBar.setBlockIncrement(40);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 3;
        this.overall.add((Component)this.rightScrollBar, gbc);
        this.rightScrollBar.addAdjustmentListener(new ScrollAdjustmentListener(this));
        this.rightScrollBar.setValue(this.rightScrollBar.getMaximum() / 2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.overall.add((Component)this, gbc);
        this.setOpaque(false);
        this.setLayout(null);
        DropTarget dropTargetRight = new DropTarget(this, 0x40000000, editWindowDropTarget, true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.highlighter = new Highlighter(0, wf);
        this.highlighter.addHighlightListener(this);
        this.highlighter.addHighlightListener(WaveformWindow.getStaticHighlightListener());
        this.mouseOverHighlighter = new Highlighter(1, wf);
        this.mouseOverHighlighter.addHighlightListener(this);
        Undo.addDatabaseChangeListener(this);
        if (wf != null) {
            this.setCell(cell, VarContext.globalContext);
        }
    }

    public static EditWindow CreateElectricDoc(Cell cell, WindowFrame wf) {
        EditWindow ui = new EditWindow(cell, wf);
        return ui;
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        Cell cell = (Cell)Cell.findNodeProto(source.getText());
        if (cell == null) {
            return;
        }
        Cell currentCell = this.getCell();
        this.setCell(cell, VarContext.globalContext);
        this.highlighter.clear();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (!(ni.getProto() instanceof Cell)) continue;
            Cell nodeCell = (Cell)ni.getProto();
            if (nodeCell == currentCell) {
                this.highlighter.addElectricObject(ni, cell);
                break;
            }
            if (!nodeCell.isIconOf(currentCell)) continue;
            this.highlighter.addElectricObject(ni, cell);
            break;
        }
        this.highlighter.finished();
    }

    public void mousePressed(MouseEvent evt) {
        this.requestFocus();
        MessagesWindow.userCommandIssued();
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        EditWindow wnd = (EditWindow)evt.getSource();
        WindowFrame.curMouseListener.mousePressed(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseReleased(evt);
    }

    public void mouseClicked(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseClicked(evt);
    }

    public void mouseEntered(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseListener.mouseEntered(evt);
    }

    public void mouseExited(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        WindowFrame.curMouseListener.mouseExited(evt);
    }

    public void mouseMoved(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseMotionListener.mouseMoved(evt);
    }

    public void mouseDragged(MouseEvent evt) {
        this.lastXPosition = evt.getX();
        this.lastYPosition = evt.getY();
        this.showCoordinates(evt);
        WindowFrame.curMouseMotionListener.mouseDragged(evt);
    }

    private void showCoordinates(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd.getCell() == null) {
            StatusBar.setCoordinates(null, wnd.wf);
        } else {
            Point2D pt = wnd.screenToDatabase(evt.getX(), evt.getY());
            EditWindow.gridAlign(pt);
            StatusBar.setCoordinates("(" + TextUtils.formatDouble(pt.getX(), 2) + ", " + TextUtils.formatDouble(pt.getY(), 2) + ")", wnd.wf);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        WindowFrame.curMouseWheelListener.mouseWheelMoved(evt);
    }

    public void keyPressed(KeyEvent evt) {
        MessagesWindow.userCommandIssued();
        WindowFrame.curKeyListener.keyPressed(evt);
    }

    public void keyReleased(KeyEvent evt) {
        WindowFrame.curKeyListener.keyReleased(evt);
    }

    public void keyTyped(KeyEvent evt) {
        WindowFrame.curKeyListener.keyTyped(evt);
    }

    public void highlightChanged(Highlighter which) {
        this.repaint();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
    }

    public Point getLastMousePosition() {
        return new Point(this.lastXPosition, this.lastYPosition);
    }

    public void showDraggedBox(Object toDraw, int oldx, int oldy) {
        Highlighter highlighter = this.getHighlighter();
        highlighter.clear();
        Point2D drawnLoc = this.screenToDatabase(oldx, oldy);
        EditWindow.gridAlign(drawnLoc);
        NodeProto np = null;
        if (toDraw instanceof NodeInst) {
            NodeInst ni = (NodeInst)toDraw;
            np = ni.getProto();
        }
        if (toDraw instanceof NodeProto) {
            np = (NodeProto)toDraw;
        }
        int defAngle = 0;
        if (toDraw instanceof NodeInst) {
            NodeInst ni = (NodeInst)toDraw;
            defAngle = ni.getAngle();
        }
        if (toDraw instanceof PrimitiveNode) {
            defAngle = ((PrimitiveNode)toDraw).getDefPlacementAngle();
        }
        if (np != null) {
            Poly poly = null;
            if (np instanceof Cell) {
                Cell placeCell = (Cell)np;
                Rectangle2D cellBounds = placeCell.getBounds();
                SizeOffset so = np.getProtoSizeOffset();
                poly = new Poly(cellBounds);
                AffineTransform rotate = NodeInst.pureRotate(defAngle % 3600, defAngle >= 3600, false);
                AffineTransform translate = new AffineTransform();
                translate.setToTranslation(drawnLoc.getX(), drawnLoc.getY());
                rotate.concatenate(translate);
                poly.transform(rotate);
            } else {
                SizeOffset so = np.getProtoSizeOffset();
                double trueSizeX = np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
                double trueSizeY = np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
                poly = new Poly(drawnLoc.getX(), drawnLoc.getY(), trueSizeX, trueSizeY);
                AffineTransform trans = NodeInst.rotateAbout(defAngle % 3600, drawnLoc.getX(), drawnLoc.getY(), defAngle >= 3600 ? -trueSizeX : trueSizeX, trueSizeY);
                poly.transform(trans);
            }
            Point2D[] points = poly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                int last = i - 1;
                if (i == 0) {
                    last = points.length - 1;
                }
                highlighter.addLine(points[last], points[i], this.getCell());
            }
            this.repaint();
        }
        highlighter.finished();
    }

    public JPanel getPanel() {
        return this.overall;
    }

    public static EditWindow getCurrent() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf == null) {
            return null;
        }
        if (wf.getContent() instanceof EditWindow) {
            return (EditWindow)wf.getContent();
        }
        return null;
    }

    public static EditWindow needCurrent() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf != null && wf.getContent() instanceof EditWindow) {
            return (EditWindow)wf.getContent();
        }
        System.out.println("There is no current window for this operation");
        return null;
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setMultiPageNumber(int pageNumber) {
        if (this.pageNumber == pageNumber) {
            return;
        }
        this.pageNumber = pageNumber;
        this.setWindowTitle();
        this.fillScreen();
    }

    public int getMultiPageNumber() {
        return this.pageNumber;
    }

    public boolean isInPlaceEdit() {
        return this.inPlaceDisplay;
    }

    public Cell getInPlaceEditTopCell() {
        return this.topLevelCell;
    }

    public List getInPlaceEditNodePath() {
        return this.inPlaceDescent;
    }

    public void setInPlaceEditNodePath(List list) {
        this.inPlaceDescent = list;
    }

    public AffineTransform getInPlaceTransformIn() {
        return this.intoCell;
    }

    public AffineTransform getInPlaceTransformOut() {
        return this.outofCell;
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public Highlighter getMouseOverHighlighter() {
        return this.mouseOverHighlighter;
    }

    public WindowFrame getWindowFrame() {
        return this.wf;
    }

    public void setCell(Cell cell, VarContext context) {
        if (context == null) {
            context = VarContext.globalContext;
        }
        this.setCell(cell, context, true, true);
    }

    private void setCell(Cell cell, VarContext context, boolean addToHistory, boolean fillTheScreen) {
        this.saveCurrentCellHistoryState();
        this.cell = cell;
        this.pageNumber = 0;
        this.cellVarContext = context;
        if (cell != null) {
            Library lib = cell.getLibrary();
            lib.setCurCell(cell);
        }
        this.highlighter.clear();
        this.highlighter.finished();
        this.mouseOverHighlighter.clear();
        this.mouseOverHighlighter.finished();
        this.setWindowTitle();
        if (this.wf != null && cell != null && this.wf == WindowFrame.getCurrentWindowFrame(false)) {
            PaletteFrame.autoTechnologySwitch(cell);
        }
        if (fillTheScreen) {
            this.fillScreen();
        }
        if (addToHistory) {
            this.addToHistory(cell, context);
        }
        if (cell != null && User.isCheckCellDates()) {
            cell.checkCellDates();
        }
        this.clearCrossProbeLevels();
    }

    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        this.wf.setTitle(this.wf.composeTitle(this.cell, "", this.pageNumber));
    }

    public static EditWindow findWindow(Cell cell) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || content.getCell() != cell) continue;
            return (EditWindow)content;
        }
        return null;
    }

    public PixelDrawing getOffscreen() {
        return this.offscreen;
    }

    public void loadExplorerTree(DefaultMutableTreeNode rootNode) {
        this.wf.libraryExplorerNode = ExplorerTree.makeLibraryTree();
        this.wf.jobExplorerNode = Job.getExplorerTree();
        this.wf.errorExplorerNode = ErrorLogger.getExplorerTree();
        this.wf.signalExplorerNode = null;
        rootNode.add(this.wf.libraryExplorerNode);
        rootNode.add(this.wf.jobExplorerNode);
        rootNode.add(this.wf.errorExplorerNode);
    }

    public void finished() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
        this.highlighter.removeHighlightListener(this);
        this.highlighter.removeHighlightListener(WaveformWindow.getStaticHighlightListener());
        this.mouseOverHighlighter.removeHighlightListener(this);
        Undo.removeDatabaseChangeListener(this);
        this.highlighter.delete();
        this.mouseOverHighlighter.delete();
    }

    public static int getScrollBarResolution() {
        return 200;
    }

    public JScrollBar getBottomScrollBar() {
        return this.bottomScrollBar;
    }

    public JScrollBar getRightScrollBar() {
        return this.rightScrollBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.wf == WindowFrame.getCurrentWindowFrame()) {
            this.requestFocus();
        }
        if (this.offscreen == null || !this.getSize().equals(this.sz)) {
            this.setScreenSize(this.getSize());
            this.repaintContents(null);
            return;
        }
        BufferedImage img = this.offscreen.getBufferedImage();
        Object object = img;
        synchronized (object) {
            g.drawImage(img, 0, 0, this);
        }
        if (this.cell != null) {
            if (this.showGrid) {
                this.drawGrid(g);
            }
            this.showCrossProbeLevels(g);
            if (Main.getDebug()) {
                if (Job.acquireExamineLock(false)) {
                    try {
                        this.drawCellFrame(g);
                        this.mouseOverHighlighter.showHighlights(this, g);
                        this.highlighter.showHighlights(this, g);
                        Job.releaseExamineLock();
                    }
                    catch (Error e) {
                        Job.releaseExamineLock();
                        throw e;
                    }
                }
            } else {
                try {
                    this.drawCellFrame(g);
                    this.mouseOverHighlighter.showHighlights(this, g);
                    this.highlighter.showHighlights(this, g);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.doingAreaDrag) {
                this.showDragBox(g);
            }
            if (this.showPopupCloud) {
                this.drawPopupCloud((Graphics2D)g);
            }
            if (this.inPlaceDisplay) {
                Graphics2D g2 = (Graphics2D)g;
                Rectangle2D bounds = this.cell.getBounds();
                Point i1 = this.databaseToScreen(bounds.getMinX(), bounds.getMinY());
                Point i2 = this.databaseToScreen(bounds.getMinX(), bounds.getMaxY());
                Point i3 = this.databaseToScreen(bounds.getMaxX(), bounds.getMaxY());
                Point i4 = this.databaseToScreen(bounds.getMaxX(), bounds.getMinY());
                Polygon innerPoly = new Polygon();
                innerPoly.addPoint(i1.x, i1.y);
                innerPoly.addPoint(i2.x, i2.y);
                innerPoly.addPoint(i3.x, i3.y);
                innerPoly.addPoint(i4.x, i4.y);
                Area outerArea = new Area(new Rectangle(0, 0, this.sz.width, this.sz.height));
                Area innerArea = new Area(innerPoly);
                outerArea.subtract(innerArea);
                g.setColor(new Color(128, 128, 128, 128));
                g2.fill(outerArea);
                g2.setStroke(inPlaceMarker);
                g.setColor(Color.RED);
                g.drawLine(i1.x, i1.y, i2.x, i2.y);
                g.drawLine(i2.x, i2.y, i3.x, i3.y);
                g.drawLine(i3.x, i3.y, i4.x, i4.y);
                g.drawLine(i4.x, i4.y, i1.x, i1.y);
            }
        }
        super.paint(g);
        object = redrawThese;
        synchronized (object) {
            if (runningNow == null) {
                if (EditWindow.handleWindowChangeRequests(this) && !redrawThese.contains(this)) {
                    redrawThese.add(this);
                }
                if (redrawThese.size() > 0) {
                    runningNow = (EditWindow)redrawThese.get(0);
                    redrawThese.remove(0);
                    RenderJob nextJob = new RenderJob(runningNow, runningNow.getOffscreen(), null);
                    return;
                }
            }
        }
    }

    public void fullRepaint() {
        this.repaintContents(null);
    }

    public static void repaintAllContents() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.repaintContents(null);
        }
    }

    public static void repaintAll() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintContents(Rectangle2D bounds) {
        if (this.offscreen == null) {
            return;
        }
        List list = redrawThese;
        synchronized (list) {
            if (runningNow != null) {
                if (runningNow != this && !redrawThese.contains(this)) {
                    redrawThese.add(this);
                }
                return;
            }
            EditWindow.handleWindowChangeRequests(this);
            runningNow = this;
        }
        RenderJob renderJob = new RenderJob(this, this.offscreen, bounds);
        this.setScrollPosition();
    }

    public Image renderNode(NodeInst ni, double scale, boolean forceVisible) {
        this.offscreen.clearImage(false);
        this.setScale(scale);
        this.offscreen.drawNode(ni, DBMath.MATID, true, null, forceVisible);
        return this.offscreen.composite();
    }

    public Image renderArc(ArcInst ai, double scale, boolean forceVisible) {
        this.offscreen.clearImage(false);
        this.setScale(scale);
        this.offscreen.drawArc(ai, DBMath.MATID, forceVisible);
        return this.offscreen.composite();
    }

    public void clearCrossProbeLevels() {
        this.crossProbeObjects.clear();
    }

    public boolean hasCrossProbeData() {
        return this.crossProbeObjects.size() > 0;
    }

    public void addCrossProbeLine(Point2D start, Point2D end, Color color) {
        CrossProbe cp = new CrossProbe();
        cp.isLine = true;
        cp.start = start;
        cp.end = end;
        cp.color = color;
        this.crossProbeObjects.add(cp);
    }

    public void addCrossProbeBox(Rectangle2D box, Color color) {
        CrossProbe cp = new CrossProbe();
        cp.isLine = false;
        cp.box = box;
        cp.color = color;
        this.crossProbeObjects.add(cp);
    }

    private void showCrossProbeLevels(Graphics g) {
        Iterator it = this.crossProbeObjects.iterator();
        while (it.hasNext()) {
            Point pE;
            Point pS;
            CrossProbe cp = (CrossProbe)it.next();
            g.setColor(cp.color);
            if (cp.isLine) {
                pS = this.databaseToScreen(cp.start);
                pE = this.databaseToScreen(cp.end);
                g.drawLine(pS.x, pS.y, pE.x, pE.y);
                continue;
            }
            pS = this.databaseToScreen(cp.box.getMinX(), cp.box.getMinY());
            pE = this.databaseToScreen(cp.box.getMaxX(), cp.box.getMaxY());
            int lX = Math.min(pS.x, pE.x);
            int lY = Math.min(pS.y, pE.y);
            int wid = Math.abs(pS.x - pE.x);
            int hei = Math.abs(pS.y - pE.y);
            g.fillRect(lX, lY, wid, hei);
        }
    }

    public boolean isDoingAreaDrag() {
        return this.doingAreaDrag;
    }

    public void setDoingAreaDrag() {
        this.doingAreaDrag = true;
    }

    public void clearDoingAreaDrag() {
        this.doingAreaDrag = false;
    }

    public Point getStartDrag() {
        return this.startDrag;
    }

    public void setStartDrag(int x, int y) {
        this.startDrag.setLocation(x, y);
    }

    public Point getEndDrag() {
        return this.endDrag;
    }

    public void setEndDrag(int x, int y) {
        this.endDrag.setLocation(x, y);
    }

    private void showDragBox(Graphics g) {
        int lX = (int)Math.min(this.startDrag.getX(), this.endDrag.getX());
        int hX = (int)Math.max(this.startDrag.getX(), this.endDrag.getX());
        int lY = (int)Math.min(this.startDrag.getY(), this.endDrag.getY());
        int hY = (int)Math.max(this.startDrag.getY(), this.endDrag.getY());
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(selectionLine);
        g.setColor(new Color(User.getColorHighlight()));
        g.drawLine(lX, lY, lX, hY);
        g.drawLine(lX, hY, hX, hY);
        g.drawLine(hX, hY, hX, lY);
        g.drawLine(hX, lY, lX, lY);
    }

    private void drawCellFrame(Graphics g) {
        DisplayedFrame df = new DisplayedFrame(this.cell, g, this);
        df.renderFrame();
    }

    public void setGrid(boolean showGrid) {
        this.showGrid = showGrid;
        this.repaint();
    }

    public boolean isGrid() {
        return this.showGrid;
    }

    public double getGridXSpacing() {
        return this.gridXSpacing;
    }

    public void setGridXSpacing(double spacing) {
        this.gridXSpacing = spacing;
    }

    public double getGridYSpacing() {
        return this.gridYSpacing;
    }

    public void setGridYSpacing(double spacing) {
        this.gridYSpacing = spacing;
    }

    public Rectangle2D displayableBounds() {
        Point2D low = this.screenToDatabase(0, 0);
        Point2D high = this.screenToDatabase(this.sz.width - 1, this.sz.height - 1);
        Rectangle2D.Double bounds = new Rectangle2D.Double(low.getX(), high.getY(), high.getX() - low.getX(), low.getY() - high.getY());
        return bounds;
    }

    private void drawGrid(Graphics g) {
        if (this.gridXSpacing == 0.0 || this.gridYSpacing == 0.0) {
            return;
        }
        double spacingX = this.gridXSpacing;
        double spacingY = this.gridYSpacing;
        double boldSpacingX = spacingX * (double)User.getDefGridXBoldFrequency();
        double boldSpacingY = spacingY * (double)User.getDefGridYBoldFrequency();
        double boldSpacingThreshX = spacingX / 4.0;
        double boldSpacingThreshY = spacingY / 4.0;
        Rectangle2D displayable = this.displayableBounds();
        double lX = displayable.getMinX();
        double lY = displayable.getMaxY();
        double hX = displayable.getMaxX();
        double hY = displayable.getMinY();
        double scaleX = (double)this.sz.width / (hX - lX);
        double scaleY = (double)this.sz.height / (lY - hY);
        double x1 = DBMath.toNearest(lX, spacingX);
        double y1 = DBMath.toNearest(lY, spacingY);
        boolean allBoldDots = false;
        if (spacingX * scaleX < 5.0 || spacingY * scaleY < 5.0) {
            x1 = DBMath.toNearest(x1, boldSpacingX);
            spacingX = boldSpacingX;
            y1 = DBMath.toNearest(y1, boldSpacingY);
            spacingY = boldSpacingY;
            if (spacingX * scaleX < 10.0 || spacingY * scaleY < 10.0) {
                return;
            }
        } else if (spacingX * scaleX > 75.0 && spacingY * scaleY > 75.0) {
            allBoldDots = true;
        }
        g.setColor(new Color(User.getColorGrid()));
        for (double i = y1; i > hY; i -= spacingY) {
            int y = (int)((lY - i) * scaleY);
            if (y < 0 || y > this.sz.height) continue;
            double boldValueY = i;
            boldValueY = i < 0.0 ? (boldValueY -= boldSpacingThreshY / 2.0) : (boldValueY += boldSpacingThreshY / 2.0);
            boolean everyTenY = Math.abs(boldValueY) % boldSpacingY < boldSpacingThreshY;
            for (double j = x1; j < hX; j += spacingX) {
                boolean everyTenX;
                int x = (int)((j - lX) * scaleX);
                double boldValueX = j;
                boldValueX = j < 0.0 ? (boldValueX -= boldSpacingThreshX / 2.0) : (boldValueX += boldSpacingThreshX / 2.0);
                boolean bl = everyTenX = Math.abs(boldValueX) % boldSpacingX < boldSpacingThreshX;
                if (allBoldDots && everyTenX && everyTenY) {
                    g.fillRect(x - 2, y, 5, 1);
                    g.fillRect(x, y - 2, 1, 5);
                    g.fillRect(x - 1, y - 1, 3, 3);
                    continue;
                }
                if (allBoldDots || everyTenX && everyTenY) {
                    g.fillRect(x - 1, y, 3, 1);
                    g.fillRect(x, y - 1, 1, 3);
                    continue;
                }
                g.fillRect(x, y, 1, 1);
            }
        }
    }

    private FindText.WhatToSearch get(Set whatToSearch, FindText.WhatToSearch what) {
        if (whatToSearch.contains(what)) {
            return what;
        }
        return null;
    }

    private void searchTextNodes(String search, boolean caseSensitive, boolean regExp, Set whatToSearch) {
        boolean doTemp = whatToSearch.contains(FindText.WhatToSearch.TEMP_NAMES);
        FindText.WhatToSearch what = this.get(whatToSearch, FindText.WhatToSearch.NODE_NAME);
        FindText.WhatToSearch whatVar = this.get(whatToSearch, FindText.WhatToSearch.NODE_VAR);
        Iterator it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (what != null) {
                Name name = ni.getNameKey();
                if (doTemp || !name.isTempname()) {
                    EditWindow.findAllMatches(ni, null, 0, name, name.toString(), this.foundInCell, search, caseSensitive, regExp, what);
                }
            }
            if (whatVar == null) continue;
            this.addVariableTextToList(ni, this.foundInCell, search, caseSensitive, regExp, whatVar);
        }
    }

    private void searchTextArcs(String search, boolean caseSensitive, boolean regExp, Set whatToSearch) {
        boolean doTemp = whatToSearch.contains(FindText.WhatToSearch.TEMP_NAMES);
        FindText.WhatToSearch what = this.get(whatToSearch, FindText.WhatToSearch.ARC_NAME);
        FindText.WhatToSearch whatVar = this.get(whatToSearch, FindText.WhatToSearch.ARC_VAR);
        Iterator it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (what != null) {
                Name name = ai.getNameKey();
                if (doTemp || !name.isTempname()) {
                    EditWindow.findAllMatches(ai, null, 0, name, name.toString(), this.foundInCell, search, caseSensitive, regExp, what);
                }
            }
            if (whatVar == null) continue;
            this.addVariableTextToList(ai, this.foundInCell, search, caseSensitive, regExp, whatVar);
        }
    }

    private void searchTextExports(String search, boolean caseSensitive, boolean regExp, Set whatToSearch) {
        FindText.WhatToSearch what = this.get(whatToSearch, FindText.WhatToSearch.EXPORT_NAME);
        FindText.WhatToSearch whatVar = this.get(whatToSearch, FindText.WhatToSearch.EXPORT_VAR);
        Iterator it = this.cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            if (what != null) {
                Name name = pp.getNameKey();
                EditWindow.findAllMatches(pp, null, 0, null, name.toString(), this.foundInCell, search, caseSensitive, regExp, what);
            }
            if (whatVar == null) continue;
            this.addVariableTextToList(pp, this.foundInCell, search, caseSensitive, regExp, whatVar);
        }
    }

    private void searchTextCellVars(String search, boolean caseSensitive, boolean regExp, Set whatToSearch) {
        FindText.WhatToSearch whatVar = this.get(whatToSearch, FindText.WhatToSearch.CELL_VAR);
        if (whatVar != null) {
            Iterator it = this.cell.getVariables();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                if (!var.isDisplay()) continue;
                EditWindow.findAllMatches(null, var, -1, null, var.getPureValue(-1), this.foundInCell, search, caseSensitive, regExp, whatVar);
            }
        }
    }

    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set whatToSearch) {
        this.foundInCell = new ArrayList();
        if (this.cell == null) {
            System.out.println("No current Cell");
            return;
        }
        this.searchTextNodes(search, caseSensitive, regExp, whatToSearch);
        this.searchTextArcs(search, caseSensitive, regExp, whatToSearch);
        this.searchTextExports(search, caseSensitive, regExp, whatToSearch);
        this.searchTextCellVars(search, caseSensitive, regExp, whatToSearch);
        if (this.foundInCell.size() == 0) {
            System.out.println("Nothing found");
        }
        this.currentFindPosition = -1;
        this.currentStringInCell = null;
    }

    private String repeatChar(char c, int num) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private void printFind(StringsInCell sic) {
        String foundHdr = "Found  " + sic.what + ": ";
        String foundStr = sic.theLine;
        String highlightHdr = this.repeatChar(' ', foundHdr.length() + sic.startPosition);
        String highlight = this.repeatChar('^', sic.endPosition - sic.startPosition);
        System.out.println(foundHdr + foundStr + "\n" + highlightHdr + highlight);
    }

    public boolean findNextText(boolean reverse) {
        if (this.foundInCell == null || this.foundInCell.size() == 0) {
            this.currentStringInCell = null;
            return false;
        }
        if (reverse) {
            --this.currentFindPosition;
            if (this.currentFindPosition < 0) {
                this.currentFindPosition = this.foundInCell.size() - 1;
            }
        } else {
            ++this.currentFindPosition;
            if (this.currentFindPosition >= this.foundInCell.size()) {
                this.currentFindPosition = 0;
            }
        }
        this.currentStringInCell = (StringsInCell)this.foundInCell.get(this.currentFindPosition);
        this.highlighter.clear();
        this.printFind(this.currentStringInCell);
        if (this.currentStringInCell.object == null) {
            this.highlighter.addText(this.cell, this.cell, (Variable)this.currentStringInCell.object, null);
        } else {
            ElectricObject eObj = (ElectricObject)this.currentStringInCell.object;
            Variable var = eObj.getVar(this.currentStringInCell.key);
            this.highlighter.addText(eObj, this.cell, var, this.currentStringInCell.name);
        }
        this.highlighter.finished();
        return true;
    }

    public void replaceText(String replace) {
        if (this.currentStringInCell == null) {
            return;
        }
        ReplaceTextJob job = new ReplaceTextJob(this, replace);
    }

    public void replaceAllText(String replace) {
        ReplaceAllTextJob job = new ReplaceAllTextJob(this, replace);
    }

    private void addVariableTextToList(ElectricObject eObj, List foundInCell, String search, boolean caseSensitive, boolean regExp, FindText.WhatToSearch what) {
        Iterator it = eObj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay()) continue;
            Object obj = var.getObject();
            if (obj instanceof String) {
                EditWindow.findAllMatches(eObj, var, -1, null, (String)obj, foundInCell, search, caseSensitive, regExp, what);
                continue;
            }
            if (!(obj instanceof String[])) continue;
            String[] strings = (String[])obj;
            for (int i = 0; i < strings.length; ++i) {
                EditWindow.findAllMatches(eObj, var, i, null, strings[i], foundInCell, search, caseSensitive, regExp, what);
            }
        }
    }

    private static void findAllMatches(Object object, Variable variable, int lineInVariable, Name name, String theLine, List foundInCell, String search, boolean caseSensitive, boolean regExp, FindText.WhatToSearch what) {
        int flags = caseSensitive ? 0 : 66;
        Pattern p = regExp ? Pattern.compile(search, flags) : null;
        Matcher m = regExp ? p.matcher(theLine) : null;
        int startPos = 0;
        while (true) {
            int endPos;
            if (regExp) {
                boolean found = m.find();
                if (!found) break;
                startPos = m.start();
                endPos = m.end();
            } else {
                if ((startPos = TextUtils.findStringInString(theLine, search, startPos, caseSensitive, false)) < 0) break;
                endPos = startPos + search.length();
            }
            String regExpSearch = regExp ? search : null;
            Variable.Key key = null;
            if (variable != null) {
                key = variable.getKey();
            }
            foundInCell.add(new StringsInCell(object, key, name, lineInVariable, theLine, startPos, endPos, regExpSearch, what));
            startPos = endPos;
        }
    }

    private void printChange(StringsInCell sic, String newString) {
        String foundHdr = "Change " + sic.what + ": ";
        String foundStr = sic.theLine;
        String replaceHdr = "  ->  ";
        String replaceStr = newString;
        String highlightHdr = this.repeatChar(' ', foundHdr.length() + sic.startPosition);
        String highlightStr = this.repeatChar('^', sic.endPosition - sic.startPosition);
        System.out.println(foundHdr + foundStr + replaceHdr + replaceStr + "\n" + highlightHdr + highlightStr);
    }

    private void changeOneText(StringsInCell sic, String rep, Cell cell) {
        String newString;
        if (sic.replaced) {
            return;
        }
        sic.replaced = true;
        String oldString = sic.theLine;
        if (sic.regExpSearch != null) {
            Pattern p = Pattern.compile(sic.regExpSearch);
            Matcher m = p.matcher(oldString);
            boolean found = m.find(sic.startPosition);
            LayoutLib.error(!found, "regExp find before replace failed");
            try {
                StringBuffer ns = new StringBuffer();
                m.appendReplacement(ns, rep);
                m.appendTail(ns);
                newString = ns.toString();
            }
            catch (Exception e) {
                System.out.println("Regular expression replace failed");
                newString = oldString;
            }
        } else {
            newString = oldString.substring(0, sic.startPosition) + rep + oldString.substring(sic.endPosition);
        }
        this.printChange(sic, newString);
        if (sic.object == null) {
            cell.updateVar(sic.key, (Object)newString);
        } else if (sic.key == null) {
            if (sic.name == null) {
                Export pp = (Export)sic.object;
                pp.rename(newString);
                Undo.redrawObject(pp.getOriginalPort().getNodeInst());
            } else {
                Geometric geom = (Geometric)sic.object;
                geom.setName(newString);
                Undo.redrawObject(geom);
            }
        } else {
            ElectricObject base = (ElectricObject)sic.object;
            Variable var = base.getVar(sic.key);
            Object obj = var.getObject();
            Object newVar = null;
            if (obj instanceof String) {
                base.updateVar(sic.key, (Object)newString);
            } else if (obj instanceof String[]) {
                String[] oldLines = (String[])obj;
                String[] newLines = new String[oldLines.length];
                for (int i = 0; i < oldLines.length; ++i) {
                    newLines[i] = i == sic.lineInVariable ? newString : oldLines[i];
                }
                base.updateVar(sic.key, (Object)newLines);
            }
        }
        int delta = newString.length() - oldString.length();
        if (delta != 0) {
            Iterator it = this.foundInCell.iterator();
            while (it.hasNext()) {
                StringsInCell oSIC = (StringsInCell)it.next();
                if (oSIC == sic || oSIC.object != sic.object || oSIC.key != sic.key || oSIC.name != sic.name || oSIC.lineInVariable != sic.lineInVariable) continue;
                oSIC.theLine = newString;
                if (oSIC.startPosition <= sic.startPosition) continue;
                oSIC.startPosition += delta;
                oSIC.endPosition += delta;
            }
        }
    }

    public boolean getShowPopupCloud() {
        return this.showPopupCloud;
    }

    public void setShowPopupCloud(List text, Point2D point) {
        this.showPopupCloud = true;
        this.popupCloudText = text;
        this.popupCloudPoint = point;
    }

    public void clearShowPopupCloud() {
        this.showPopupCloud = false;
    }

    private void drawPopupCloud(Graphics2D g) {
    }

    public Dimension getScreenSize() {
        return this.sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenSize(Dimension sz) {
        if (this.wf != null) {
            List list = redrawThese;
            synchronized (list) {
                if (runningNow != null) {
                    WindowChangeRequest zap = new WindowChangeRequest();
                    zap.wnd = this;
                    zap.sz = sz;
                    zap.requestType = 3;
                    windowChangeRequests.add(zap);
                    return;
                }
            }
        }
        this.sz = sz;
        this.offscreen = new PixelDrawing(this);
    }

    public double getScale() {
        return this.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double scale) {
        if (this.wf != null) {
            List list = redrawThese;
            synchronized (list) {
                if (runningNow != null) {
                    WindowChangeRequest zap = new WindowChangeRequest();
                    zap.wnd = this;
                    zap.scale = scale;
                    zap.requestType = 1;
                    windowChangeRequests.add(zap);
                    return;
                }
            }
        }
        this.scale = scale;
        this.computeDatabaseBounds();
    }

    private static boolean handleWindowChangeRequests(EditWindow wnd) {
        boolean changed = false;
        ArrayList<WindowChangeRequest> notThisWindow = null;
        Iterator it = windowChangeRequests.iterator();
        while (it.hasNext()) {
            WindowChangeRequest zap = (WindowChangeRequest)it.next();
            if (zap.wnd != wnd) {
                if (notThisWindow == null) {
                    notThisWindow = new ArrayList<WindowChangeRequest>();
                }
                notThisWindow.add(zap);
                continue;
            }
            switch (zap.requestType) {
                case 1: {
                    if (wnd.scale != zap.scale) {
                        changed = true;
                    }
                    wnd.scale = zap.scale;
                    break;
                }
                case 2: {
                    if (wnd.offx != zap.offx || wnd.offy != zap.offy) {
                        changed = true;
                    }
                    wnd.offx = zap.offx;
                    wnd.offy = zap.offy;
                    break;
                }
                case 3: {
                    wnd.sz = zap.sz;
                    wnd.offscreen = new PixelDrawing(wnd);
                }
            }
        }
        if (notThisWindow != null) {
            windowChangeRequests = notThisWindow;
        } else {
            windowChangeRequests.clear();
        }
        if (changed) {
            wnd.computeDatabaseBounds();
        }
        return changed;
    }

    public Point2D getOffset() {
        return new Point2D.Double(this.offx, this.offy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D getScheduledOffset() {
        double oX = this.offx;
        double oY = this.offy;
        List list = redrawThese;
        synchronized (list) {
            Iterator it = windowChangeRequests.iterator();
            while (it.hasNext()) {
                WindowChangeRequest zap = (WindowChangeRequest)it.next();
                if (zap.requestType != 2) continue;
                oX = zap.offx;
                oY = zap.offy;
            }
        }
        return new Point2D.Double(oX, oY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(Point2D off) {
        if (this.wf != null) {
            List list = redrawThese;
            synchronized (list) {
                if (runningNow != null) {
                    WindowChangeRequest zap = new WindowChangeRequest();
                    zap.wnd = this;
                    zap.offx = off.getX();
                    zap.offy = off.getY();
                    zap.requestType = 2;
                    windowChangeRequests.add(zap);
                    return;
                }
            }
        }
        this.offx = off.getX();
        this.offy = off.getY();
        this.computeDatabaseBounds();
    }

    private void computeDatabaseBounds() {
        double width = (double)this.sz.width / this.scale;
        double height = (double)this.sz.height / this.scale;
        this.databaseBounds.setRect(this.offx - width / 2.0, this.offy - height / 2.0, width, height);
    }

    public Rectangle2D getDisplayedBounds() {
        return this.databaseBounds;
    }

    public void setScrollPosition() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditWindow.this.setScrollPositionUnsafe();
                }
            });
        } else {
            this.setScrollPositionUnsafe();
        }
    }

    private void setScrollPositionUnsafe() {
        double height;
        this.bottomScrollBar.setEnabled(this.cell != null);
        this.rightScrollBar.setEnabled(this.cell != null);
        if (this.cell == null) {
            return;
        }
        Rectangle2D cellBounds = this.cell.getBounds();
        Rectangle2D viewBounds = this.displayableBounds();
        Rectangle2D overallBounds = cellBounds.createUnion(viewBounds);
        this.ignoreScrollChange = true;
        double width = viewBounds.getWidth() < cellBounds.getWidth() ? viewBounds.getWidth() : cellBounds.getWidth();
        double d = height = viewBounds.getHeight() < cellBounds.getHeight() ? viewBounds.getHeight() : cellBounds.getHeight();
        if (!this.bottomScrollBar.getValueIsAdjusting()) {
            this.bottomScrollBar.getModel().setRangeProperties((int)((this.offx - 0.5 * width) * 100.0), (int)(width * 100.0), (int)((cellBounds.getX() - 0.2 * cellBounds.getWidth()) * 100.0), (int)((cellBounds.getX() + cellBounds.getWidth() + 0.2 * cellBounds.getWidth()) * 100.0), false);
            this.bottomScrollBar.setUnitIncrement((int)(0.05 * viewBounds.getWidth() * 100.0));
            this.bottomScrollBar.setBlockIncrement((int)(0.2 * viewBounds.getWidth() * 100.0));
        }
        if (!this.rightScrollBar.getValueIsAdjusting()) {
            this.rightScrollBar.getModel().setRangeProperties((int)((-this.offy - 0.5 * height) * 100.0), (int)(height * 100.0), (int)(-(cellBounds.getY() + cellBounds.getHeight() + 0.2 * cellBounds.getHeight()) * 100.0), (int)(-(cellBounds.getY() - 0.2 * cellBounds.getHeight()) * 100.0), false);
            this.rightScrollBar.setUnitIncrement((int)(0.05 * viewBounds.getHeight() * 100.0));
            this.rightScrollBar.setBlockIncrement((int)(0.2 * viewBounds.getHeight() * 100.0));
        }
        this.ignoreScrollChange = false;
    }

    public void bottomScrollChanged(int value) {
        if (this.cell == null) {
            return;
        }
        if (this.ignoreScrollChange) {
            return;
        }
        double val = (double)value / 100.0;
        Rectangle2D cellBounds = this.cell.getBounds();
        Rectangle2D viewBounds = this.displayableBounds();
        double width = viewBounds.getWidth() < cellBounds.getWidth() ? viewBounds.getWidth() : cellBounds.getWidth();
        double newoffx = val + 0.5 * width;
        Point2D.Double offset = new Point2D.Double(newoffx, this.offy);
        this.setOffset(offset);
        this.repaintContents(null);
    }

    public void rightScrollChanged(int value) {
        if (this.cell == null) {
            return;
        }
        if (this.ignoreScrollChange) {
            return;
        }
        double val = (double)value / 100.0;
        Rectangle2D cellBounds = this.cell.getBounds();
        Rectangle2D viewBounds = this.displayableBounds();
        double height = viewBounds.getHeight() < cellBounds.getHeight() ? viewBounds.getHeight() : cellBounds.getHeight();
        double newoffy = -(val + 0.5 * height);
        Point2D.Double offset = new Point2D.Double(this.offx, newoffy);
        this.setOffset(offset);
        this.repaintContents(null);
    }

    private void setScreenBounds(Rectangle2D bounds) {
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (width == 0.0) {
            width = 2.0;
        }
        if (height == 0.0) {
            height = 2.0;
        }
        double scalex = (double)this.sz.width / width * 0.9;
        double scaley = (double)this.sz.height / height * 0.9;
        this.scale = Math.min(scalex, scaley);
        this.offx = bounds.getCenterX();
        this.offy = bounds.getCenterY();
    }

    public void focusScreen(Rectangle2D bounds) {
        if (bounds == null) {
            return;
        }
        if (this.inPlaceDisplay) {
            Point2D.Double llPt = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
            Point2D.Double urPt = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
            this.outofCell.transform(llPt, llPt);
            this.outofCell.transform(urPt, urPt);
            double lX = Math.min(((Point2D)llPt).getX(), ((Point2D)urPt).getX());
            double hX = Math.max(((Point2D)llPt).getX(), ((Point2D)urPt).getX());
            double lY = Math.min(((Point2D)llPt).getY(), ((Point2D)urPt).getY());
            double hY = Math.max(((Point2D)llPt).getY(), ((Point2D)urPt).getY());
            bounds = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        }
        this.setScreenBounds(bounds);
        this.setScrollPosition();
        this.computeDatabaseBounds();
        this.repaintContents(null);
    }

    public Rectangle2D getBoundsInWindow() {
        Rectangle2D cellBounds = this.cell.getBounds();
        Dimension d = new Dimension();
        int frameFactor = Cell.FrameDescription.getCellFrameInfo(this.cell, d);
        Rectangle2D.Double frameBounds = new Rectangle2D.Double(-d.getWidth() / 2.0, -d.getHeight() / 2.0, d.getWidth(), d.getHeight());
        if (frameFactor == 0) {
            cellBounds = frameBounds;
            if (this.cell.isMultiPage()) {
                double offY = (double)this.pageNumber * 1000.0;
                cellBounds.setRect(cellBounds.getMinX(), cellBounds.getMinY() + offY, cellBounds.getWidth(), cellBounds.getHeight());
            }
        } else {
            if (cellBounds.getWidth() == 0.0 && cellBounds.getHeight() == 0.0) {
                int defaultCellSize = 60;
                cellBounds = new Rectangle2D.Double(cellBounds.getCenterX() - (double)(defaultCellSize / 2), cellBounds.getCenterY() - (double)(defaultCellSize / 2), defaultCellSize, defaultCellSize);
            }
            this.setScreenBounds(cellBounds);
            Rectangle2D relativeTextBounds = this.cell.getRelativeTextBounds(this);
            if (relativeTextBounds != null) {
                Rectangle2D.Double newCellBounds = new Rectangle2D.Double();
                Rectangle2D.union(relativeTextBounds, cellBounds, newCellBounds);
                cellBounds = newCellBounds;
            }
            if (frameFactor == 1) {
                Rectangle2D.union(frameBounds, cellBounds, frameBounds);
                cellBounds = frameBounds;
            }
        }
        return cellBounds;
    }

    public void fillScreen() {
        if (this.cell != null && !this.cell.getView().isTextView()) {
            Rectangle2D cellBounds = this.getBoundsInWindow();
            this.focusScreen(cellBounds);
            return;
        }
        this.repaint();
    }

    public void zoomOutContents() {
        double scale = this.getScale();
        this.setScale(scale / 2.0);
        this.repaintContents(null);
    }

    public void zoomInContents() {
        double scale = this.getScale();
        this.setScale(scale * 2.0);
        this.repaintContents(null);
    }

    public void focusOnHighlighted() {
        Rectangle2D bounds = this.highlighter.getHighlightedArea(this);
        this.focusScreen(bounds);
    }

    public VarContext getVarContext() {
        return this.cellVarContext;
    }

    public void downHierarchy(boolean inPlace) {
        Export schExport;
        Highlight h = this.highlighter.getOneHighlight();
        if (h == null) {
            return;
        }
        ElectricObject eobj = h.getElectricObject();
        NodeInst ni = null;
        PortInst pi = null;
        if (eobj instanceof NodeInst) {
            ni = (NodeInst)eobj;
        }
        if (eobj instanceof PortInst) {
            pi = (PortInst)eobj;
            ni = pi.getNodeInst();
        }
        if (ni == null) {
            System.out.println("Must select a Node to descend into");
            return;
        }
        NodeProto np = ni.getProto();
        if (!(np instanceof Cell)) {
            System.out.println("Can only descend into cell instances");
            return;
        }
        Cell cell = (Cell)np;
        Cell schCell = cell.getEquivalent();
        if (this.cell == schCell) {
            schCell = cell;
        }
        if (schCell == null) {
            schCell = cell;
        }
        if (np != schCell) {
            inPlace = false;
        }
        if (inPlace) {
            AffineTransform transIn = ni.rotateIn(ni.translateIn());
            AffineTransform transOut = ni.translateOut(ni.rotateOut());
            if (this.inPlaceDisplay) {
                this.outofCell.concatenate(transOut);
                this.intoCell.preConcatenate(transIn);
            } else {
                this.outofCell = transOut;
                this.intoCell = transIn;
                this.topLevelCell = this.cell;
                this.inPlaceDescent = new ArrayList();
            }
            this.inPlaceDescent.add(ni);
            this.inPlaceDisplay = true;
        } else {
            this.inPlaceDisplay = false;
        }
        Nodable desiredNO = null;
        ArrayList<Nodable> possibleNodables = new ArrayList<Nodable>();
        Netlist nl = ni.getParent().getUserNetlist();
        Iterator it = nl.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            if (no.getNodeInst() != ni) continue;
            possibleNodables.add(no);
        }
        if (possibleNodables.size() > 1) {
            desiredNO = (Nodable)possibleNodables.get(0);
            boolean hasWaveform = false;
            Iterator it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = (WindowFrame)it2.next();
                if (!(wf.getContent() instanceof WaveformWindow)) continue;
                hasWaveform = true;
                break;
            }
            if (hasWaveform) {
                Object[] manyOptions = new String[possibleNodables.size()];
                int i = 0;
                Iterator it3 = possibleNodables.iterator();
                while (it3.hasNext()) {
                    manyOptions[i++] = ((Nodable)it3.next()).getName();
                }
                String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Descend into which node?", "Choose a Node", 3, null, manyOptions, manyOptions[0]);
                if (chosen == null) {
                    return;
                }
                Iterator it4 = possibleNodables.iterator();
                while (it4.hasNext()) {
                    Nodable no = (Nodable)it4.next();
                    if (!no.getName().equals(chosen)) continue;
                    desiredNO = no;
                    break;
                }
            }
        }
        boolean redisplay = true;
        if (this.inPlaceDisplay) {
            redisplay = false;
        }
        if (desiredNO != null) {
            this.setCell(schCell, this.cellVarContext.push(desiredNO), true, redisplay);
        } else if (pi != null) {
            this.setCell(schCell, this.cellVarContext.push(pi), true, redisplay);
        } else {
            this.setCell(schCell, this.cellVarContext.push(ni), true, redisplay);
        }
        if (!redisplay) {
            this.fullRepaint();
        }
        if (pi != null && (schExport = schCell.findExport(pi.getPortProto().getName())) != null) {
            PortInst origPort = schExport.getOriginalPort();
            this.highlighter.addElectricObject(origPort, schCell);
            this.highlighter.finished();
        }
    }

    public void upHierarchy() {
        if (this.cell == null) {
            return;
        }
        Cell oldCell = this.cell;
        List what = this.highlighter.getHighlights();
        Export selectedExport = null;
        Iterator it = what.iterator();
        block2: while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() == Highlight.Type.EOBJ) {
                ElectricObject eObj = h.getElectricObject();
                if (!(eObj instanceof PortInst)) continue;
                PortInst pi = (PortInst)eObj;
                Iterator eIt = pi.getNodeInst().getExports();
                while (eIt.hasNext()) {
                    Export e = (Export)eIt.next();
                    if (e.getOriginalPort() != pi) continue;
                    selectedExport = e;
                    continue block2;
                }
                continue;
            }
            if (h.getType() != Highlight.Type.TEXT || h.getVar() != null || h.getName() != null || !(h.getElectricObject() instanceof Export)) continue;
            selectedExport = (Export)h.getElectricObject();
            break;
        }
        try {
            Iterator it2;
            Cell iconView;
            Cell parent;
            Cell schCell;
            NodeInst ni;
            Nodable no = this.cellVarContext.getNodable();
            if (no != null) {
                Cell parent2 = no.getParent();
                if (this.inPlaceDisplay) {
                    int inPlaceDepth = this.inPlaceDescent.size() - 1;
                    if (inPlaceDepth == 0) {
                        this.inPlaceDisplay = false;
                        this.inPlaceDescent = null;
                    } else {
                        this.inPlaceDescent.remove(inPlaceDepth);
                        this.intoCell = new AffineTransform();
                        this.outofCell = new AffineTransform();
                        for (int i = 0; i < inPlaceDepth; ++i) {
                            ni = (NodeInst)this.inPlaceDescent.get(i);
                            this.outofCell.concatenate(ni.translateOut(ni.rotateOut()));
                            this.intoCell.preConcatenate(ni.rotateIn(ni.translateIn()));
                        }
                    }
                }
                VarContext context = this.cellVarContext.pop();
                CellHistory foundHistory = null;
                for (int i = this.cellHistory.size() - 1; i > -1; --i) {
                    CellHistory history = (CellHistory)this.cellHistory.get(i);
                    if (history.cell != parent2 || !history.context.equals(context)) continue;
                    foundHistory = history;
                    break;
                }
                PortInst pi = this.cellVarContext.getPortInst();
                if (foundHistory != null) {
                    this.setCell(parent2, context, true, false);
                    this.setOffset(foundHistory.offset);
                    this.setScale(foundHistory.scale);
                    this.repaintContents(null);
                } else {
                    this.setCell(parent2, context, true, true);
                }
                if (selectedExport != null) {
                    pi = no.getNodeInst().findPortInstFromProto(selectedExport);
                }
                if (pi != null) {
                    this.highlighter.addElectricObject(pi, parent2);
                } else {
                    this.highlighter.addElectricObject(no.getNodeInst(), parent2);
                }
                return;
            }
            if (this.cell.isIcon() && (schCell = this.cell.getEquivalent()) != null) {
                this.setCell(schCell, VarContext.globalContext);
                return;
            }
            HashSet<Cell> found = new HashSet<Cell>();
            Iterator it3 = this.cell.getInstancesOf();
            while (it3.hasNext()) {
                NodeInst ni2 = (NodeInst)it3.next();
                parent = ni2.getParent();
                if (parent.getLibrary().isHidden()) continue;
                found.add(parent);
            }
            if (this.cell.isSchematic() && (iconView = this.cell.iconView()) != null) {
                it2 = iconView.getInstancesOf();
                while (it2.hasNext()) {
                    Cell parent3;
                    ni = (NodeInst)it2.next();
                    if (ni.isIconOfParent() || (parent3 = ni.getParent()).getLibrary().isHidden()) continue;
                    found.add(parent3);
                }
            }
            if (found.size() == 0) {
                System.out.println("Not in any cells");
            } else if (found.size() == 1) {
                Cell parent4 = (Cell)found.iterator().next();
                this.setCell(parent4, VarContext.globalContext);
                Object highlightNi = null;
                Iterator it4 = parent4.getNodes();
                while (it4.hasNext()) {
                    Cell nodeCell;
                    NodeInst ni3 = (NodeInst)it4.next();
                    if (!(ni3.getProto() instanceof Cell) || (nodeCell = (Cell)ni3.getProto()) != oldCell && !nodeCell.isIconOf(oldCell)) continue;
                    if (selectedExport != null) {
                        this.highlighter.addElectricObject(ni3.findPortInstFromProto(selectedExport), parent4);
                        break;
                    }
                    this.highlighter.addElectricObject(ni3, parent4);
                    break;
                }
                this.highlighter.finished();
            } else {
                JPopupMenu parents = new JPopupMenu("parents");
                it2 = found.iterator();
                while (it2.hasNext()) {
                    parent = (Cell)it2.next();
                    String cellName = parent.describe();
                    JMenuItem menuItem = new JMenuItem(cellName);
                    menuItem.addActionListener(this);
                    parents.add(menuItem);
                }
                parents.show(this, 0, 0);
            }
        }
        catch (NullPointerException e) {
            ActivityLogger.logException(e);
        }
    }

    public void cellHistoryGoBack() {
        if (this.cellHistoryLocation <= 0) {
            return;
        }
        this.setCellByHistory(this.cellHistoryLocation - 1);
    }

    public void cellHistoryGoForward() {
        if (this.cellHistoryLocation >= this.cellHistory.size() - 1) {
            return;
        }
        this.setCellByHistory(this.cellHistoryLocation + 1);
    }

    public boolean cellHistoryCanGoBack() {
        return this.cellHistoryLocation > 0;
    }

    public boolean cellHistoryCanGoForward() {
        return this.cellHistoryLocation < this.cellHistory.size() - 1;
    }

    public void fireCellHistoryStatus() {
        if (this.cellHistoryLocation > 0) {
            this.getPanel().firePropertyChange(propGoBackEnabled, false, true);
        }
        if (this.cellHistoryLocation < this.cellHistory.size() - 1) {
            this.getPanel().firePropertyChange(propGoForwardEnabled, false, true);
        }
    }

    private void addToHistory(Cell cell, VarContext context) {
        if (cell == null) {
            return;
        }
        CellHistory history = new CellHistory();
        history.cell = cell;
        history.context = context;
        if (this.cellHistoryLocation < this.cellHistory.size() - 1) {
            for (int i = this.cellHistoryLocation + 1; i < this.cellHistory.size(); ++i) {
                this.cellHistory.remove(i);
            }
            this.getPanel().firePropertyChange(propGoForwardEnabled, true, false);
        }
        if (this.cellHistoryLocation == 0) {
            this.getPanel().firePropertyChange(propGoBackEnabled, false, true);
        }
        this.cellHistory.add(history);
        this.cellHistoryLocation = this.cellHistory.size() - 1;
        if (this.cellHistoryLocation > 20) {
            this.cellHistory.remove(0);
            --this.cellHistoryLocation;
        }
    }

    private void saveCurrentCellHistoryState() {
        if (this.cellHistoryLocation < 0) {
            return;
        }
        CellHistory current = (CellHistory)this.cellHistory.get(this.cellHistoryLocation);
        current.offset = new Point2D.Double(this.offx, this.offy);
        current.scale = this.scale;
        current.highlights = new ArrayList();
        current.highlights.clear();
        Iterator it = this.highlighter.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getCell() != this.cell) continue;
            current.highlights.add(h);
        }
        current.highlightOffset = this.highlighter.getHighlightOffset();
    }

    private void setCellByHistory(int location) {
        if (this.cellHistoryLocation == this.cellHistory.size() - 1) {
            if (location < this.cellHistory.size() - 1) {
                this.getPanel().firePropertyChange(propGoForwardEnabled, false, true);
            }
        } else if (location == this.cellHistory.size() - 1) {
            this.getPanel().firePropertyChange(propGoForwardEnabled, true, false);
        }
        if (this.cellHistoryLocation == 0) {
            if (location > 0) {
                this.getPanel().firePropertyChange(propGoBackEnabled, false, true);
            }
        } else if (location == 0) {
            this.getPanel().firePropertyChange(propGoBackEnabled, true, false);
        }
        CellHistory history = (CellHistory)this.cellHistory.get(location);
        if (history.cell == null || !history.cell.isLinked()) {
            history.cell = null;
            history.context = VarContext.globalContext;
            history.offset = new Point2D.Double(0.0, 0.0);
            history.highlights = new ArrayList();
            history.highlightOffset = new Point2D.Double(0.0, 0.0);
        }
        this.setCell(history.cell, history.context, false, true);
        this.setOffset(history.offset);
        this.setScale(history.scale);
        this.highlighter.setHighlightList(history.highlights);
        this.highlighter.setHighlightOffset((int)history.highlightOffset.getX(), (int)history.highlightOffset.getY());
        this.cellHistoryLocation = location;
        this.repaintContents(null);
    }

    public Point2D screenToDatabase(int screenX, int screenY) {
        double dbX = (double)(screenX - this.sz.width / 2) / this.scale + this.offx;
        double dbY = (double)(this.sz.height / 2 - screenY) / this.scale + this.offy;
        Point2D.Double dbPt = new Point2D.Double(dbX, dbY);
        if (this.inPlaceDisplay) {
            this.intoCell.transform(dbPt, dbPt);
        }
        return dbPt;
    }

    public Rectangle2D screenToDatabase(Rectangle2D screenRect) {
        Point2D anchor = this.screenToDatabase((int)screenRect.getX(), (int)screenRect.getY());
        Point2D size = this.deltaScreenToDatabase((int)screenRect.getWidth(), (int)screenRect.getHeight());
        return new Rectangle2D.Double(anchor.getX(), anchor.getY() + size.getY(), size.getX(), -size.getY());
    }

    public Point2D deltaScreenToDatabase(int screenDX, int screenDY) {
        Point2D origin = this.screenToDatabase(0, 0);
        Point2D pt = this.screenToDatabase(screenDX, screenDY);
        return new Point2D.Double(pt.getX() - origin.getX(), pt.getY() - origin.getY());
    }

    public Point databaseToScreen(double dbX, double dbY) {
        if (this.inPlaceDisplay) {
            Point2D.Double dbPt = new Point2D.Double(dbX, dbY);
            this.outofCell.transform(dbPt, dbPt);
            dbX = ((Point2D)dbPt).getX();
            dbY = ((Point2D)dbPt).getY();
        }
        int screenX = (int)Math.round((double)(this.sz.width / 2) + (dbX - this.offx) * this.scale);
        int screenY = (int)Math.round((double)(this.sz.height / 2) - (dbY - this.offy) * this.scale);
        return new Point(screenX, screenY);
    }

    public Point databaseToScreen(Point2D db) {
        return this.databaseToScreen(db.getX(), db.getY());
    }

    public Rectangle databaseToScreen(Rectangle2D db) {
        int swap;
        Point llPt = this.databaseToScreen(db.getMinX(), db.getMinY());
        Point urPt = this.databaseToScreen(db.getMaxX(), db.getMaxY());
        int screenLX = llPt.x;
        int screenHX = urPt.x;
        int screenLY = llPt.y;
        int screenHY = urPt.y;
        if (screenHX < screenLX) {
            swap = screenHX;
            screenHX = screenLX;
            screenLX = swap;
        }
        if (screenHY < screenLY) {
            swap = screenHY;
            screenHY = screenLY;
            screenLY = swap;
        }
        return new Rectangle(screenLX, screenLY, screenHX - screenLX, screenHY - screenLY);
    }

    public Point deltaDatabaseToScreen(double dbDX, double dbDY) {
        Point origin = this.databaseToScreen(0.0, 0.0);
        Point pt = this.databaseToScreen(dbDX, dbDY);
        return new Point(pt.x - origin.x, pt.y - origin.y);
    }

    public static void gridAlign(Point2D pt) {
        double alignment = User.getAlignmentToGrid();
        long x = Math.round(pt.getX() / alignment);
        long y = Math.round(pt.getY() / alignment);
        pt.setLocation((double)x * alignment, (double)y * alignment);
    }

    public static void gridAlign(Point2D pt, double alignment) {
        long x = Math.round(pt.getX() / alignment);
        long y = Math.round(pt.getY() / alignment);
        pt.setLocation((double)x * alignment, (double)y * alignment);
    }

    public double getTextUnitSize(double pointSize) {
        return pointSize / this.scale;
    }

    public double getTextScreenSize(double dbSize) {
        return dbSize * this.scale;
    }

    public static int getDefaultFontSize() {
        return 14;
    }

    public Font getFont(TextDescriptor descript) {
        int size = EditWindow.getDefaultFontSize();
        int fontStyle = 0;
        String fontName = User.getDefaultFont();
        if (descript != null) {
            TextDescriptor.ActiveFont af;
            int fontIndex;
            size = (int)descript.getTrueSize(this);
            if (size <= 0) {
                size = 1;
            }
            if (descript.isItalic()) {
                fontStyle |= 2;
            }
            if (descript.isBold()) {
                fontStyle |= 1;
            }
            if ((fontIndex = descript.getFace()) != 0 && (af = TextDescriptor.ActiveFont.findActiveFont(fontIndex)) != null) {
                fontName = af.getName();
            }
        }
        if (size < 5) {
            return null;
        }
        Font font = new Font(fontName, fontStyle, size);
        return font;
    }

    public GlyphVector getGlyphs(String text, Font font) {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        GlyphVector gv = font.createGlyphVector(frc, text);
        return gv;
    }

    public void databaseEndChangeBatch(Undo.ChangeBatch batch) {
        if (this.cell != null && !this.cell.isLinked()) {
            this.setCell(null, VarContext.globalContext, false, true);
            this.cellHistoryGoBack();
        }
    }

    public void databaseChanged(Undo.Change evt) {
    }

    public boolean isGUIListener() {
        return true;
    }

    public BufferedImage getOffScreenImage(ElectricPrinter ep) {
        Graphics2D g2d;
        if (this.getCell() == null) {
            return null;
        }
        BufferedImage img = ep.getBufferedImage();
        if (img == null) {
            EditWindow w = EditWindow.CreateElectricDoc(null, null);
            int iw = (int)ep.getPageFormat().getImageableWidth() * ep.getDesiredDPI() / 72;
            int ih = (int)ep.getPageFormat().getImageableHeight() * ep.getDesiredDPI() / 72;
            w.setScreenSize(new Dimension(iw, ih));
            w.setCell(this.getCell(), this.getVarContext());
            PixelDrawing offscreen = w.getOffscreen();
            offscreen.setBackgroundColor(Color.WHITE);
            offscreen.drawImage(null);
            img = offscreen.getBufferedImage();
            ep.setBufferedImage(img);
        }
        if ((g2d = (Graphics2D)ep.getGraphics()) != null) {
            int ix = (int)ep.getPageFormat().getImageableX() * ep.getDesiredDPI() / 72;
            int iy = (int)ep.getPageFormat().getImageableY() * ep.getDesiredDPI() / 72;
            g2d.scale(72.0 / (double)ep.getDesiredDPI(), 72.0 / (double)ep.getDesiredDPI());
            g2d.drawImage((Image)img, ix, iy, null);
        }
        return img;
    }

    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
        double panningAmount;
        Cell cell = this.getCell();
        if (cell == null) {
            return;
        }
        Dimension dim = this.getSize();
        double value = direction == 0 ? (double)dim.width : (double)dim.height;
        int mult = (int)(value * (panningAmount = panningAmounts[User.getPanningDistance()]) / this.getScale());
        if (mult == 0) {
            mult = 1;
        }
        Point2D wndOffset = this.getOffset();
        Point2D.Double newOffset = direction == 0 ? new Point2D.Double(wndOffset.getX() - (double)(mult * ticks), wndOffset.getY()) : new Point2D.Double(wndOffset.getX(), wndOffset.getY() - (double)(mult * ticks));
        this.setOffset(newOffset);
        this.repaintContents(null);
    }

    private static class CellHistory {
        public Cell cell;
        public VarContext context;
        public Point2D offset;
        public double scale;
        public List highlights;
        public Point2D highlightOffset;

        private CellHistory() {
        }
    }

    private static class ReplaceAllTextJob
    extends Job {
        EditWindow wnd;
        String replace;

        public ReplaceAllTextJob(EditWindow wnd, String replace) {
            super("Replace All Text", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.replace = replace;
            this.startJob();
        }

        public boolean doIt() {
            int total = 0;
            this.wnd.currentFindPosition = 0;
            while (this.wnd.currentFindPosition < this.wnd.foundInCell.size()) {
                this.wnd.currentStringInCell = (StringsInCell)this.wnd.foundInCell.get(this.wnd.currentFindPosition);
                this.wnd.changeOneText(this.wnd.currentStringInCell, this.replace, this.wnd.cell);
                ++total;
                this.wnd.currentFindPosition++;
            }
            if (total == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                System.out.println("Replaced " + total + " times");
            }
            return true;
        }
    }

    private static class ReplaceTextJob
    extends Job {
        private EditWindow wnd;
        private String replace;

        private ReplaceTextJob(EditWindow wnd, String replace) {
            super("Replace Text", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.replace = replace;
            this.startJob();
        }

        public boolean doIt() {
            this.wnd.changeOneText(this.wnd.currentStringInCell, this.replace, this.wnd.cell);
            return true;
        }
    }

    private static class StringsInCell {
        final Object object;
        final Variable.Key key;
        final Name name;
        String theLine;
        final int lineInVariable;
        int startPosition;
        int endPosition;
        final String regExpSearch;
        final FindText.WhatToSearch what;
        boolean replaced;

        StringsInCell(Object object, Variable.Key key, Name name, int lineInVariable, String theLine, int startPosition, int endPosition, String regExpSearch, FindText.WhatToSearch what) {
            this.object = object;
            this.key = key;
            this.name = name;
            this.lineInVariable = lineInVariable;
            this.theLine = theLine;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.regExpSearch = regExpSearch;
            this.what = what;
            this.replaced = false;
        }

        public String toString() {
            return "StringsInCell obj=" + this.object + " var=" + this.key + " name=" + this.name + " line=" + this.lineInVariable + " start=" + this.startPosition + " end=" + this.endPosition + " msg=" + this.theLine;
        }
    }

    public static class DisplayedFrame
    extends Cell.FrameDescription {
        private Graphics g;
        private EditWindow wnd;

        public DisplayedFrame(Cell cell, Graphics g, EditWindow wnd) {
            super(cell, wnd.pageNumber);
            this.g = g;
            this.wnd = wnd;
        }

        public void renderInit() {
            this.g.setColor(Color.BLACK);
        }

        public void showFrameLine(Point2D from, Point2D to) {
            Point f = this.wnd.databaseToScreen(from);
            Point t = this.wnd.databaseToScreen(to);
            this.g.drawLine(f.x, f.y, t.x, t.y);
        }

        public void showFrameText(Point2D ctr, double size, double maxWid, double maxHei, String string) {
            Point sizeVector = this.wnd.deltaDatabaseToScreen(size, size);
            int initialHeight = (int)Math.abs(((Point2D)sizeVector).getY());
            Font font = new Font(User.getDefaultFont(), 0, initialHeight);
            this.g.setFont(font);
            FontRenderContext frc = new FontRenderContext(null, true, true);
            GlyphVector gv = font.createGlyphVector(frc, string);
            LineMetrics lm = font.getLineMetrics(string, frc);
            Rectangle rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
            double width = rect.width;
            double height = lm.getHeight();
            Point2D databaseSize = this.wnd.deltaScreenToDatabase((int)width, (int)height);
            double dbWidth = Math.abs(databaseSize.getX());
            double dbHeight = Math.abs(databaseSize.getY());
            if (maxWid > 0.0 && maxHei > 0.0 && (dbWidth > maxWid || dbHeight > maxHei)) {
                double scale = Math.min(maxWid / dbWidth, maxHei / dbHeight);
                font = new Font(User.getDefaultFont(), 0, (int)((double)initialHeight * scale));
                if (font != null) {
                    gv = font.createGlyphVector(frc, string);
                    lm = font.getLineMetrics(string, frc);
                    rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
                    width = rect.width;
                    height = lm.getHeight();
                }
            }
            Graphics2D g2 = (Graphics2D)this.g;
            Point p = this.wnd.databaseToScreen(ctr);
            g2.drawGlyphVector(gv, (float)((double)p.x - width / 2.0), (float)((double)p.y + height / 2.0 - (double)lm.getDescent()));
        }
    }

    private static class CrossProbe {
        boolean isLine;
        Point2D start;
        Point2D end;
        Rectangle2D box;
        Color color;

        private CrossProbe() {
        }
    }

    private static class RenderJob
    extends Job {
        private EditWindow wnd;
        private PixelDrawing offscreen;
        private Rectangle2D bounds;

        protected RenderJob(EditWindow wnd, PixelDrawing offscreen, Rectangle2D bounds) {
            super("Display", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.offscreen = offscreen;
            this.bounds = bounds;
            this.startJob();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doIt() {
            try {
                this.offscreen.drawImage(this.bounds);
            }
            catch (ConcurrentModificationException e) {
                System.out.println("GOT ConcurrentModificationException during redisplay!");
                ActivityLogger.logException(e);
                this.wnd.repaintContents(this.bounds);
            }
            List list = redrawThese;
            synchronized (list) {
                runningNow = null;
            }
            this.wnd.repaint();
            return true;
        }
    }

    private static class ScrollAdjustmentListener
    implements AdjustmentListener {
        EditWindow wnd;

        ScrollAdjustmentListener(EditWindow wnd) {
            this.wnd = wnd;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getSource() == this.wnd.getBottomScrollBar() && this.wnd.getCell() != null) {
                this.wnd.bottomScrollChanged(e.getValue());
            }
            if (e.getSource() == this.wnd.getRightScrollBar() && this.wnd.getCell() != null) {
                this.wnd.rightScrollChanged(e.getValue());
            }
        }
    }

    private static class EditWindowDropTarget
    implements DropTargetListener {
        private EditWindowDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            this.dragAction(e);
        }

        public void dragOver(DropTargetDragEvent e) {
            this.dragAction(e);
        }

        private Object getDraggedObject(DataFlavor[] flavors) {
            if (flavors.length > 0 && flavors[0] instanceof NodeProtoDataFlavor) {
                NodeProtoDataFlavor npdf = (NodeProtoDataFlavor)flavors[0];
                Object obj = npdf.getFlavorObject();
                if (obj instanceof List) {
                    obj = ((List)obj).get(0);
                }
                return obj;
            }
            return null;
        }

        private void dragAction(DropTargetDragEvent e) {
            Object obj = this.getDraggedObject(e.getCurrentDataFlavors());
            if (obj != null) {
                e.acceptDrag(e.getDropAction());
                DropTarget dt = (DropTarget)e.getSource();
                if (dt.getComponent() instanceof JPanel) {
                    EditWindow wnd = (EditWindow)dt.getComponent();
                    wnd.showDraggedBox(obj, e.getLocation().x, e.getLocation().y);
                }
                return;
            }
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            Object obj = this.getDraggedObject(dtde.getCurrentDataFlavors());
            if (obj == null) {
                dtde.dropComplete(false);
                return;
            }
            DropTarget dt = (DropTarget)dtde.getSource();
            if (!(dt.getComponent() instanceof JPanel)) {
                dtde.dropComplete(false);
                return;
            }
            EditWindow wnd = (EditWindow)dt.getComponent();
            Point2D where = wnd.screenToDatabase(dtde.getLocation().x, dtde.getLocation().y);
            EditWindow.gridAlign(where);
            wnd.getHighlighter().clear();
            PaletteFrame.PlaceNewNode job = new PaletteFrame.PlaceNewNode("Create Node", obj, where, wnd.getCell(), null, false);
        }
    }

    public static class NodeProtoTransferable
    implements Transferable {
        private Object obj;
        private NodeProtoDataFlavor df;

        public NodeProtoTransferable(Object obj) {
            this.obj = obj;
            try {
                this.df = new NodeProtoDataFlavor(obj);
            }
            catch (ClassNotFoundException e) {
                System.out.println("ERROR: Cannot make Electric DataFlavor");
            }
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] it = new DataFlavor[]{this.df};
            return it;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == this.df;
        }

        public Object getTransferData(DataFlavor flavor) {
            if (flavor == this.df) {
                return this.obj;
            }
            return null;
        }
    }

    public static class NodeProtoDataFlavor
    extends DataFlavor {
        private Object obj;

        NodeProtoDataFlavor(Object obj) throws ClassNotFoundException {
            super("electric/instance");
            this.obj = obj;
        }

        public Object getFlavorObject() {
            return this.obj;
        }
    }

    private static class WindowChangeRequest {
        private static final int ZOOMREQUEST = 1;
        private static final int PANREQUEST = 2;
        private static final int RESIZEREQUEST = 3;
        EditWindow wnd;
        double offx;
        double offy;
        Dimension sz;
        double scale;
        int requestType;

        private WindowChangeRequest() {
        }
    }
}

