/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ParasiticTab
extends PreferencePanel {
    private HashMap layerResistanceOptions;
    private HashMap layerCapacitanceOptions;
    private HashMap layerEdgeCapacitanceOptions;
    private JList layerList;
    private DefaultListModel layerListModel;
    private JTextField capacitance;
    private JTextField edgeCapacitance;
    private JTextField gateLengthSubtraction;
    private JPanel globalValues;
    private JCheckBox includeGate;
    private JCheckBox includeGround;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel maxDist;
    private JTextField maxDistValue;
    private JTextField minCapacitance;
    private JTextField minResistance;
    private JPanel parasiticPanel;
    private JTextField resistance;
    private JScrollPane spiceLayer;
    private JPanel techValues;
    private JPanel topPanel;

    public ParasiticTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.topPanel;
    }

    public String getName() {
        return "Parasitic";
    }

    public void init() {
        this.maxDistValue.setText(Double.toString(ParasiticTool.getMaxDistance()));
        this.techValues.setBorder(new TitledBorder("For technology '" + this.curTech.getTechName() + "'"));
        this.layerResistanceOptions = new HashMap();
        this.layerCapacitanceOptions = new HashMap();
        this.layerEdgeCapacitanceOptions = new HashMap();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            this.layerResistanceOptions.put(layer, Pref.makeDoublePref(null, null, layer.getResistance()));
            this.layerCapacitanceOptions.put(layer, Pref.makeDoublePref(null, null, layer.getCapacitance()));
            this.layerEdgeCapacitanceOptions.put(layer, Pref.makeDoublePref(null, null, layer.getEdgeCapacitance()));
        }
        this.layerListModel = new DefaultListModel();
        this.layerList = new JList(this.layerListModel);
        this.layerList.setSelectionMode(0);
        this.spiceLayer.setViewportView(this.layerList);
        this.layerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ParasiticTab.this.spiceLayerListClick();
            }
        });
        this.showLayersInTechnology(this.layerListModel);
        this.layerList.setSelectedIndex(0);
        this.spiceLayerListClick();
        this.resistance.getDocument().addDocumentListener(new ParasiticDocumentListener(this.layerResistanceOptions, this.layerList, this.curTech));
        this.capacitance.getDocument().addDocumentListener(new ParasiticDocumentListener(this.layerCapacitanceOptions, this.layerList, this.curTech));
        this.edgeCapacitance.getDocument().addDocumentListener(new ParasiticDocumentListener(this.layerEdgeCapacitanceOptions, this.layerList, this.curTech));
        this.minResistance.setText(Double.toString(this.curTech.getMinResistance()));
        this.minCapacitance.setText(Double.toString(this.curTech.getMinCapacitance()));
        this.gateLengthSubtraction.setText(Double.toString(this.curTech.getGateLengthSubtraction()));
        this.includeGate.setSelected(this.curTech.isGateIncluded());
        this.includeGround.setSelected(this.curTech.isGroundNetIncluded());
        this.parasiticPanel.setVisible(false);
    }

    private void showLayersInTechnology(DefaultListModel model) {
        model.clear();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            model.addElement(layer.getName());
        }
    }

    private void spiceLayerListClick() {
        String layerName = (String)this.layerList.getSelectedValue();
        Layer layer = this.curTech.findLayer(layerName);
        if (layer != null) {
            Pref resistancePref = (Pref)this.layerResistanceOptions.get(layer);
            this.resistance.setText(Double.toString(resistancePref.getDouble()));
            Pref capacitancePref = (Pref)this.layerCapacitanceOptions.get(layer);
            this.capacitance.setText(Double.toString(capacitancePref.getDouble()));
            Pref edgeCapacitancePref = (Pref)this.layerEdgeCapacitanceOptions.get(layer);
            this.edgeCapacitance.setText(Double.toString(edgeCapacitancePref.getDouble()));
        }
    }

    public void term() {
        ParasiticTool.setMaxDistance(Double.parseDouble(this.maxDistValue.getText()));
        double doubleNow = TextUtils.atof(this.minResistance.getText());
        if (this.curTech.getMinResistance() != doubleNow) {
            this.curTech.setMinResistance(doubleNow);
        }
        doubleNow = TextUtils.atof(this.minCapacitance.getText());
        if (this.curTech.getMinCapacitance() != doubleNow) {
            this.curTech.setMinCapacitance(doubleNow);
        }
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Pref edgeCapacitancePref;
            Pref capacitancePref;
            Layer layer = (Layer)it.next();
            Pref resistancePref = (Pref)this.layerResistanceOptions.get(layer);
            if (resistancePref != null && resistancePref.getDoubleFactoryValue() != resistancePref.getDouble()) {
                layer.setResistance(resistancePref.getDouble());
            }
            if ((capacitancePref = (Pref)this.layerCapacitanceOptions.get(layer)) != null && capacitancePref.getDoubleFactoryValue() != capacitancePref.getDouble()) {
                layer.setCapacitance(capacitancePref.getDouble());
            }
            if ((edgeCapacitancePref = (Pref)this.layerEdgeCapacitanceOptions.get(layer)) == null || edgeCapacitancePref.getDoubleFactoryValue() == edgeCapacitancePref.getDouble()) continue;
            layer.setEdgeCapacitance(edgeCapacitancePref.getDouble());
        }
        doubleNow = TextUtils.atof(this.gateLengthSubtraction.getText());
        if (this.curTech.getGateLengthSubtraction() != doubleNow) {
            this.curTech.setGateLengthSubtraction(doubleNow);
        }
        if (this.includeGate.isSelected() != this.curTech.isGateIncluded()) {
            this.curTech.setGateIncluded(this.includeGate.isSelected());
        }
        if (this.includeGround.isSelected() != this.curTech.isGroundNetIncluded()) {
            this.curTech.setGroundNetIncluded(this.includeGround.isSelected());
        }
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.techValues = new JPanel();
        this.spiceLayer = new JScrollPane();
        this.jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel2 = new JLabel();
        this.resistance = new JTextField();
        this.jLabel12 = new JLabel();
        this.capacitance = new JTextField();
        this.edgeCapacitance = new JTextField();
        this.parasiticPanel = new JPanel();
        this.maxDist = new JLabel();
        this.maxDistValue = new JTextField();
        this.globalValues = new JPanel();
        this.jLabel20 = new JLabel();
        this.minResistance = new JTextField();
        this.jLabel21 = new JLabel();
        this.minCapacitance = new JTextField();
        this.jLabel5 = new JLabel();
        this.gateLengthSubtraction = new JTextField();
        this.includeGate = new JCheckBox();
        this.includeGround = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.topPanel.setLayout(new GridBagLayout());
        this.techValues.setLayout(new GridBagLayout());
        this.techValues.setBorder(new TitledBorder("Parasitic Values"));
        this.spiceLayer.setMinimumSize(new Dimension(200, 50));
        this.spiceLayer.setPreferredSize(new Dimension(200, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.techValues.add((Component)this.spiceLayer, gridBagConstraints);
        this.jLabel7.setText("Layer:");
        this.jLabel7.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.techValues.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel11.setText("Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.techValues.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel2.setText("Perimeter Cap (fF/um):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.techValues.add((Component)this.jLabel2, gridBagConstraints);
        this.resistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.techValues.add((Component)this.resistance, gridBagConstraints);
        this.jLabel12.setText("Area Cap (fF/um^2):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.techValues.add((Component)this.jLabel12, gridBagConstraints);
        this.capacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.techValues.add((Component)this.capacitance, gridBagConstraints);
        this.edgeCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.techValues.add((Component)this.edgeCapacitance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.topPanel.add((Component)this.techValues, gridBagConstraints);
        this.parasiticPanel.setLayout(new GridBagLayout());
        this.parasiticPanel.setBorder(new TitledBorder("Parasitic Coupling Options"));
        this.parasiticPanel.setEnabled(false);
        this.maxDist.setText("Maximum distance (lambda)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDist, gridBagConstraints);
        this.maxDistValue.setColumns(6);
        this.maxDistValue.setText("20");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDistValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.parasiticPanel, gridBagConstraints);
        this.globalValues.setLayout(new GridBagLayout());
        this.globalValues.setBorder(new TitledBorder("Global Values"));
        this.jLabel20.setText("Min. Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.globalValues.add((Component)this.jLabel20, gridBagConstraints);
        this.minResistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.globalValues.add((Component)this.minResistance, gridBagConstraints);
        this.jLabel21.setText("Min. Capacitance (fF):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.globalValues.add((Component)this.jLabel21, gridBagConstraints);
        this.minCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.globalValues.add((Component)this.minCapacitance, gridBagConstraints);
        this.jLabel5.setText("Gate Length Shrink (Subtraction) um:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.globalValues.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.globalValues.add((Component)this.gateLengthSubtraction, gridBagConstraints);
        this.includeGate.setText("Include Gate In Resistance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.globalValues.add((Component)this.includeGate, gridBagConstraints);
        this.includeGround.setText("Include Ground Network");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.globalValues.add((Component)this.includeGround, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.globalValues, gridBagConstraints);
        this.getContentPane().add((Component)this.topPanel, new GridBagConstraints());
        this.pack();
    }

    public static void main(String[] args) {
        new ParasiticTab((Frame)new JFrame(), true).setVisible(true);
    }

    private static class ParasiticDocumentListener
    implements DocumentListener {
        HashMap optionMap;
        JList list;
        Technology tech;

        ParasiticDocumentListener(HashMap optionMap, JList list, Technology tech) {
            this.optionMap = optionMap;
            this.list = list;
            this.tech = tech;
        }

        private void change(DocumentEvent e) {
            String text;
            String layerName = (String)this.list.getSelectedValue();
            Layer layer = this.tech.findLayer(layerName);
            if (layer == null) {
                return;
            }
            Document doc = e.getDocument();
            int len = doc.getLength();
            try {
                text = doc.getText(0, len);
            }
            catch (BadLocationException ex) {
                return;
            }
            Pref pref = (Pref)this.optionMap.get(layer);
            double v = TextUtils.atof(text);
            pref.setDouble(v);
        }

        public void changedUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.change(e);
        }
    }
}

