/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.Main;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.DrcRings;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.gates.MoCMOSGenerator;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.CIF;
import com.sun.electric.tool.user.User;
import java.lang.reflect.Method;

public class GateRegression
extends Job {
    private Technology technology;
    private String foundry;
    private static final DrcRings.Filter FILTER = new DrcRings.Filter(){

        public boolean skip(NodeInst ni) {
            return ni.getProto().getName().indexOf("mosWellTie_") != -1;
        }
    };

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private static void allSizes(StdCellParams stdCell, Technology technology) {
        double minSz = 0.1;
        double maxSz = 200.0;
        for (double d = minSz; d < maxSz; d *= 10.0) {
            for (double x = d; x < Math.min(d * 10.0, maxSz); x *= 1.01) {
                GateRegression.aPass(x, stdCell, technology);
            }
        }
    }

    public static void aPass(double x, StdCellParams stdCell, Technology technology) {
        Technology tsmc90;
        if (technology == MoCMOS.tech) {
            MoCMOSGenerator.generateAllGates(x, stdCell);
        }
        if ((tsmc90 = Technology.getTSMC90Technology()) != null && technology == tsmc90) {
            try {
                Class<?> tsmc90GeneratorClass = Class.forName("com.sun.electric.plugins.tsmc90.gates90nm.TSMC90Generator");
                Class[] parameterTypes = new Class[]{Double.class, StdCellParams.class};
                Method generateMethod = tsmc90GeneratorClass.getDeclaredMethod("generateAllGates", parameterTypes);
                generateMethod.invoke(null, new Double(x), stdCell);
            }
            catch (Exception e) {
                System.out.println("ERROR invoking the TSMC90 gate generator");
            }
        }
    }

    public boolean doIt() {
        if (Main.LOCALDEBUGFLAG) {
            GateRegression.runGildaTest(this.technology, this.foundry);
        } else {
            GateRegression.runRegression(this.technology, this.foundry);
        }
        return true;
    }

    public static int runGildaTest(Technology technology, String techNm) {
        StdCellParams stdCell;
        System.out.println("begin Gate Regression");
        String name = "gilda" + techNm;
        Library scratchLib = LayoutLib.openLibForWrite(name, name);
        Tech.setTechnology(techNm);
        Technology tsmc90 = Technology.getTSMC90Technology();
        if (tsmc90 != null && technology == tsmc90) {
            stdCell = new StdCellParams(scratchLib, "tsmc90");
            stdCell.enableNCC("purpleFour");
            stdCell.setSizeQuantizationError(0.05);
            stdCell.setMaxMosWidth(1000.0);
        } else {
            stdCell = GateLayoutGenerator.dividerParams(scratchLib);
            stdCell.setSizeQuantizationError(0.05);
            stdCell.setSimpleName(false);
        }
        GateRegression.aPass(8.18, stdCell, technology);
        stdCell.setGndY(stdCell.getGndY() - 7.0);
        stdCell.setNmosWellHeight(stdCell.getNmosWellHeight() + 7.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setGndY(stdCell.getGndY() + 7.0);
        stdCell.setNmosWellHeight(stdCell.getNmosWellHeight() - 7.0);
        Cell gallery = Gallery.makeGallery(scratchLib);
        LayoutLib.writeLibrary(scratchLib);
        System.out.println("done.");
        return 0;
    }

    public static int runRegression(Technology technology, String techNm) {
        StdCellParams stdCell;
        System.out.println("begin Gate Regression");
        Library scratchLib = LayoutLib.openLibForWrite("scratch", "scratch" + techNm);
        Tech.setTechnology(techNm);
        Technology tsmc90 = Technology.getTSMC90Technology();
        if (tsmc90 != null && technology == tsmc90) {
            stdCell = new StdCellParams(scratchLib, "tsmc90");
            stdCell.enableNCC("purpleFour");
            stdCell.setSizeQuantizationError(0.05);
            stdCell.setMaxMosWidth(1000.0);
        } else {
            stdCell = GateLayoutGenerator.dividerParams(scratchLib);
            stdCell.setSizeQuantizationError(0.05);
            stdCell.setSimpleName(false);
        }
        GateRegression.allSizes(stdCell, technology);
        stdCell.setGndY(stdCell.getGndY() - 7.0);
        stdCell.setNmosWellHeight(stdCell.getNmosWellHeight() + 7.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setGndY(stdCell.getGndY() + 7.0);
        stdCell.setNmosWellHeight(stdCell.getNmosWellHeight() - 7.0);
        stdCell.setNmosWellHeight(50.0);
        stdCell.setPmosWellHeight(100.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setNmosWellHeight(100.0);
        stdCell.setPmosWellHeight(50.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setNmosWellHeight(70.0);
        stdCell.setPmosWellHeight(70.0);
        Cell gallery = Gallery.makeGallery(scratchLib);
        DrcRings.addDrcRings(gallery, FILTER, stdCell);
        IOTool.setCIFOutMergesBoxes(true);
        int numCifErrs = CIF.writeCIFFile(gallery, VarContext.globalContext, "scratch.cif");
        LayoutLib.writeLibrary(scratchLib);
        System.out.println("done.");
        return numCifErrs;
    }

    public GateRegression(Technology tech, String techNm) {
        super("Run Gate regression", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.technology = tech;
        this.foundry = techNm;
        this.startJob();
    }
}

