/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Inv_star_wideOutput {
    private static final double outBusWidth = 10.0;
    private static final double outBusSpace = 3.0;
    private static final double inY = 0.0;
    private static final double outY = 0.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        int i;
        sz = stdCell.roundSize(sz);
        Inv_star_wideOutput.error(!threshold.equals("") && !threshold.equals("LT") && !threshold.equals("HT") && !threshold.equals("CLK"), "Inv: threshold not \"\", \"LT\", \"HT\" or \"CLK\": " + threshold);
        String nm = "inv" + threshold;
        sz = stdCell.checkMinStrength(sz, threshold.equals("LT") ? 0.5 : 1.0, nm);
        double outsideSpace = 8.5;
        double insideSpace = 7.5;
        double spaceAvail = stdCell.getCellTop() - outsideSpace - insideSpace;
        double lamPerSz = threshold.equals("HT") ? 12.0 : (threshold.equals("CLK") ? 9.0 : 6.0);
        double totWidP = sz * lamPerSz;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWidP, 1);
        Inv_star_wideOutput.error(fwP == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = -insideSpace - (stdCell.getCellBot() + outsideSpace);
        lamPerSz = threshold.equals("LT") ? 6.0 : 3.0;
        double totWidN = sz * lamPerSz;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWidN, 1);
        Inv_star_wideOutput.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell inv = stdCell.findPart(nm, sz);
        if (inv != null) {
            return inv;
        }
        inv = stdCell.newPart(nm, sz);
        double inX = 3.5;
        LayoutLib.newExport(inv, "in", PortCharacteristic.IN, Tech.m1, 4.0, inX, 0.0);
        double mosX = inX + 2.0 + 3.0 + 2.0;
        double nmosY = -insideSpace - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fwN.nbFolds, 1, fwN.gateWid, inv, stdCell);
        double pmosY = insideSpace + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, inv, stdCell);
        double outX = StdCellParams.getRightDiffX(nmos, pmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(inv, "out", PortCharacteristic.OUT, Tech.m1, 4.0, outX, 0.0);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, inv);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, inv);
        double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
        double inLoFromGnd = gndBot - 3.0 - 2.0;
        double nmosBot = nmosY - fwN.physWid / 2.0;
        double inLoFromMos = nmosBot - 2.0 - 2.5;
        double inLoY = Math.min(inLoFromGnd, inLoFromMos);
        TrackRouterH inLo = new TrackRouterH(Tech.m1, 3.0, inLoY, inv);
        inLo.connect(inv.findExport("in"));
        for (int i2 = 0; i2 < nmos.nbGates(); ++i2) {
            inLo.connect(nmos.getGate(i2, 'B'));
        }
        double vddTop = stdCell.getVddY() + stdCell.getVddWidth() / 2.0;
        double inHiFromVdd = vddTop + 3.0 + 2.0;
        double pmosTop = pmosY + fwP.physWid / 2.0;
        double inHiFromMos = pmosTop + 2.0 + 2.5;
        double inHiY = Math.max(inHiFromVdd, inHiFromMos);
        TrackRouterH inHi = new TrackRouterH(Tech.m1, 3.0, inHiY, inv);
        inHi.connect(inv.findExport("in"));
        for (int i3 = 0; i3 < pmos.nbGates(); ++i3) {
            inHi.connect(pmos.getGate(i3, 'T'));
        }
        TrackRouterH out = new TrackRouterH(Tech.m1, 10.0, 0.0, inv);
        out.connect(inv.findExport("out"));
        for (i = 1; i < pmos.nbSrcDrns(); i += 2) {
            out.connect(pmos.getSrcDrn(i));
        }
        for (i = 1; i < nmos.nbSrcDrns(); i += 2) {
            out.connect(nmos.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 5.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, inv);
        stdCell.addPmosWell(wellMinX, wellMaxX, inv);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, inv);
        stdCell.doNCC(inv, nm + "{sch}");
        return inv;
    }
}

