/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.variable.Variable;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableElectricObject {
    private final Variable[] vars;
    public final int flags;

    ImmutableElectricObject(Variable[] vars, int flags) {
        this.vars = vars;
        this.flags = flags;
    }

    Variable[] arrayWithVariable(Variable var) {
        int varIndex = this.searchVar(var.getKey());
        int newLength = this.vars.length;
        if (varIndex < 0) {
            varIndex ^= 0xFFFFFFFF;
            ++newLength;
        } else if (this.vars[varIndex] == var) {
            return this.vars;
        }
        Variable[] newVars = new Variable[newLength];
        System.arraycopy(this.vars, 0, newVars, 0, varIndex);
        newVars[varIndex] = var;
        int tailLength = newLength - (varIndex + 1);
        System.arraycopy(this.vars, this.vars.length - tailLength, newVars, varIndex + 1, tailLength);
        return newVars;
    }

    Variable[] arrayWithoutVariable(Variable.Key key) {
        int varIndex = this.searchVar(key);
        if (varIndex < 0) {
            return this.vars;
        }
        if (this.vars.length == 1 && varIndex == 0) {
            return Variable.NULL_ARRAY;
        }
        Variable[] newVars = new Variable[this.vars.length - 1];
        System.arraycopy(this.vars, 0, newVars, 0, varIndex);
        System.arraycopy(this.vars, varIndex + 1, newVars, varIndex, newVars.length - varIndex);
        return newVars;
    }

    Variable[] arrayWithRenamedIds(IdMapper idMapper) {
        Variable[] newVars = null;
        for (int i = 0; i < this.vars.length; ++i) {
            Variable oldVar = this.vars[i];
            Variable newVar = oldVar.withRenamedIds(idMapper);
            if (newVar != oldVar && newVars == null) {
                newVars = new Variable[this.vars.length];
                System.arraycopy(this.vars, 0, newVars, 0, i);
            }
            if (newVars == null) continue;
            newVars[i] = newVar;
        }
        return newVars != null ? newVars : this.vars;
    }

    public Variable getVar(Variable.Key key) {
        int varIndex = this.searchVar(key);
        return varIndex >= 0 ? this.vars[varIndex] : null;
    }

    public Iterator<Variable> getVariables() {
        return ArrayIterator.iterator(this.vars);
    }

    public Variable[] toVariableArray() {
        return this.vars.length == 0 ? this.vars : (Variable[])this.vars.clone();
    }

    public int getNumVariables() {
        return this.vars.length;
    }

    public Variable getVar(int varIndex) {
        return this.vars[varIndex];
    }

    Variable[] getVars() {
        return this.vars;
    }

    public int searchVar(Variable.Key key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return ImmutableElectricObject.searchVar(this.vars, key);
    }

    private static int searchVar(Variable[] vars, Variable.Key key) {
        int low = 0;
        int high = vars.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Variable var = vars[mid];
            int cmp = var.getKey().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    void write(SnapshotWriter writer) throws IOException {
        boolean hasVars = this.vars.length > 0;
        writer.writeBoolean(hasVars);
        if (hasVars) {
            this.writeVars(writer);
        }
    }

    void writeVars(SnapshotWriter writer) throws IOException {
        writer.writeInt(this.vars.length);
        for (int i = 0; i < this.vars.length; ++i) {
            this.vars[i].write(writer);
        }
    }

    static Variable[] readVars(SnapshotReader reader) throws IOException {
        int length = reader.readInt();
        if (length == 0) {
            return Variable.NULL_ARRAY;
        }
        Variable[] vars = new Variable[length];
        for (int i = 0; i < length; ++i) {
            vars[i] = Variable.read(reader);
        }
        return vars;
    }

    public abstract int hashCodeExceptVariables();

    public abstract boolean equalsExceptVariables(ImmutableElectricObject var1);

    void check(boolean paramAllowed) {
        if (this.vars.length == 0) {
            return;
        }
        this.vars[0].check(paramAllowed);
        for (int i = 1; i < this.vars.length; ++i) {
            this.vars[i].check(paramAllowed);
            assert (this.vars[i - 1].getKey().compareTo(this.vars[i].getKey()) < 0);
        }
    }
}

