/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.utils;

import com.sun.electric.tool.user.Resources;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.vecmath.Point3f;

public class J3DCanvas3D
extends Canvas3D {
    public String filePath = null;
    public boolean writePNG_;
    public BufferedImage img;
    private int count;
    public boolean movieMode;
    List<String> inputFiles = new ArrayList<String>();

    public J3DCanvas3D(GraphicsConfiguration gc) {
        super(gc);
    }

    public void renderField(int fieldDesc) {
        try {
            super.renderField(fieldDesc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveMovie(String filename) {
        Class movieClass = Resources.getJMFClass("JMFImageToMovie");
        if (movieClass == null) {
            System.out.println("JMF plugin not available");
            return;
        }
        try {
            Dimension dim = this.getSize();
            Method createJMFMethod = movieClass.getDeclaredMethod("createMovie", String.class, Dimension.class, List.class);
            createJMFMethod.invoke((Object)movieClass, filename, dim, this.inputFiles);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetMoveFrames() {
        this.inputFiles.clear();
    }

    public void postSwap() {
        if (this.writePNG_) {
            Dimension dim = this.getSize();
            GraphicsContext3D ctx = this.getGraphicsContext3D();
            Raster ras = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, 0, 0, dim.width, dim.height, new ImageComponent2D(1, new BufferedImage(dim.width, dim.height, 1)), null);
            ctx.readRaster(ras);
            this.img = ras.getImage().getImage();
            this.writePNG_ = false;
            if (this.movieMode) {
                try {
                    String capture = "Capture" + this.count + ".jpg";
                    this.inputFiles.add(capture);
                    FileOutputStream out = new FileOutputStream(capture);
                    ImageIO.write((RenderedImage)this.img, "jpg", out);
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++this.count;
            } else if (this.filePath != null) {
                File tmp = new File(this.filePath);
                try {
                    ImageIO.write((RenderedImage)this.img, "PNG", tmp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.filePath = null;
            }
        }
    }
}

