/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.Main;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ToolSettings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

public class Regression {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runScript(Process process, String script) {
        Pref.forbidPreferences();
        IdReader reader = null;
        Snapshot currentSnapshot = IdManager.stdIdManager.getInitialSnapshot();
        EDatabase database = new EDatabase(currentSnapshot);
        EDatabase.setClientDatabase(database);
        System.out.println("Running " + script);
        try {
            InputStream inStream = process.getInputStream();
            OutputStream outStream = process.getOutputStream();
            reader = new IdReader(new DataInputStream(new BufferedInputStream(inStream)), database.getIdManager());
            DataOutputStream clientOutputStream = new DataOutputStream(new BufferedOutputStream(outStream));
            int protocolVersion = reader.readInt();
            if (protocolVersion != 19) {
                System.out.println("Client's protocol version 19 is incompatible with Server's protocol version " + protocolVersion);
                System.exit(1);
            }
            int connectionId = reader.readInt();
            System.out.println("Connected");
            Regression.writeEditingPreferences(clientOutputStream, database);
            int curJobId = 0;
            Job job = new InitJob();
            job.ejob.jobKey = new Job.Key(connectionId, --curJobId, true);
            Regression.writeJob(clientOutputStream, job);
            Main.UserInterfaceDummy ui = new Main.UserInterfaceDummy(connectionId);
            while (true) {
                byte tag;
                if ((tag = reader.readByte()) == 1) {
                    currentSnapshot = Snapshot.readSnapshot(reader, currentSnapshot);
                    System.out.println("Snapshot received " + currentSnapshot.snapshotId);
                    database.lock(true);
                    try {
                        database.lowLevelSetCanUndoing(true);
                        database.undo(currentSnapshot);
                        database.lowLevelSetCanUndoing(false);
                    }
                    finally {
                        database.unlock();
                    }
                    System.out.println("Database updated to snapshot " + currentSnapshot.snapshotId);
                    continue;
                }
                Client.ServerEvent serverEvent = Client.read(reader, tag, ui);
                if (serverEvent instanceof Client.EJobEvent) {
                    Client.EJobEvent e = (Client.EJobEvent)serverEvent;
                    int jobId = e.ejob.jobKey.jobId;
                    assert (e.newState == EJob.State.SERVER_DONE);
                    if (jobId > 0) {
                        if (e.ejob.doItOk) continue;
                        System.out.println("Job " + job.ejob.jobName + " failed");
                        Regression.printErrorStream(process);
                        ui.saveMessages(null);
                        return false;
                    }
                    assert (jobId == curJobId);
                    job.ejob.serializedResult = e.ejob.serializedResult;
                    Throwable result = job.ejob.deserializeResult();
                    assert (e.ejob.doItOk == (result == null));
                    if (result != null) {
                        System.out.println("Job " + job.ejob.jobName + " result:");
                        System.out.println(result);
                        Regression.printErrorStream(process);
                        ui.saveMessages(null);
                        return false;
                    }
                    switch (jobId) {
                        case -1: {
                            job = EvalJavaBsh.runScriptJob(script);
                            job.ejob.jobKey = new Job.Key(connectionId, --curJobId, true);
                            Regression.writeJob(clientOutputStream, job);
                            break;
                        }
                        case -2: {
                            job = new QuitJob();
                            job.ejob.jobKey = new Job.Key(connectionId, --curJobId, true);
                            Regression.writeJob(clientOutputStream, job);
                            break;
                        }
                        case -3: {
                            ui.saveMessages(null);
                            return true;
                        }
                        default: {
                            System.out.println("Job " + job.ejob.jobKey.jobId);
                            break;
                        }
                    }
                    continue;
                }
                serverEvent.show(ui);
            }
        }
        catch (IOException e) {
            reader = null;
            System.out.println("END OF FILE reading from server");
            Regression.printErrorStream(process);
            return false;
        }
    }

    private static void printErrorStream(Process process) {
        try {
            int c;
            process.getOutputStream().close();
            BufferedInputStream errStream = new BufferedInputStream(process.getErrorStream());
            System.out.println("StdErr:");
            while (((InputStream)errStream).available() != 0 && (c = ((InputStream)errStream).read()) >= 0) {
                System.out.print((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeEditingPreferences(DataOutputStream clientOutputStream, EDatabase database) throws IOException {
        byte[] serializedEp;
        EditingPreferences ep = new EditingPreferences(true, database.getTechPool());
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, database);
            out.writeObject(ep);
            out.flush();
            serializedEp = byteStream.toByteArray();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        clientOutputStream.writeByte(2);
        clientOutputStream.writeInt(serializedEp.length);
        clientOutputStream.write(serializedEp);
    }

    private static void writeJob(DataOutputStream clientOutputStream, Job job) throws IOException {
        EJob ejob = job.ejob;
        ejob.serialize(EDatabase.clientDatabase());
        clientOutputStream.writeByte(1);
        clientOutputStream.writeInt(ejob.jobKey.jobId);
        clientOutputStream.writeUTF(ejob.jobType.toString());
        clientOutputStream.writeUTF(ejob.jobName);
        clientOutputStream.writeInt(ejob.serializedJob.length);
        clientOutputStream.write(ejob.serializedJob);
        clientOutputStream.flush();
    }

    private static class QuitJob
    extends Job {
        private QuitJob() {
            super("QuitJob", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        }

        public boolean doIt() throws JobException {
            return true;
        }
    }

    private static class InitJob
    extends Job {
        private InitJob() {
            super("InitJob", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        }

        public boolean doIt() throws JobException {
            this.database.setToolSettings((Setting.RootGroup)ToolSettings.getToolSettings(""));
            assert (this.database.getGeneric() == null);
            Generic generic = Generic.newInstance(this.database.getIdManager());
            this.database.addTech(generic);
            for (TechFactory techFactory : TechFactory.getKnownTechs("").values()) {
                Map<TechFactory.Param, Object> paramValues;
                Technology tech = techFactory.newInstance(generic, paramValues = Collections.emptyMap());
                if (tech == null) continue;
                this.database.addTech(tech);
            }
            return true;
        }
    }
}

