/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class DrcRing {
    private static void drawRing(ArcProto arc, double w, double h, Cell f) {
        if (arc == null) {
            return;
        }
        double arcW = 6.0;
        EditingPreferences ep = f.getEditingPreferences();
        PrimitiveNode pin = arc.findOverridablePinProto(ep);
        double pinLoX = -arcW / 2.0;
        double pinHiX = w + arcW / 2.0;
        double pinLoY = -arcW / 2.0;
        double pinHiY = h + arcW / 2.0;
        double defSz = Double.POSITIVE_INFINITY;
        PortInst blPort = LayoutLib.newNodeInst(pin, pinLoX, pinLoY, defSz, defSz, 0.0, f).getOnlyPortInst();
        PortInst brPort = LayoutLib.newNodeInst(pin, pinHiX, pinLoY, defSz, defSz, 0.0, f).getOnlyPortInst();
        PortInst tlPort = LayoutLib.newNodeInst(pin, pinLoX, pinHiY, defSz, defSz, 0.0, f).getOnlyPortInst();
        PortInst trPort = LayoutLib.newNodeInst(pin, pinHiX, pinHiY, defSz, defSz, 0.0, f).getOnlyPortInst();
        LayoutLib.newArcInst(arc, arcW, blPort, brPort);
        LayoutLib.newArcInst(arc, arcW, tlPort, trPort);
        LayoutLib.newArcInst(arc, arcW, blPort, tlPort);
        LayoutLib.newArcInst(arc, arcW, brPort, trPort);
    }

    private static void drawRing(NodeProto np, double w, double h, double thickness, Cell f, char half, double pwellRatio) {
        double arcW = thickness;
        double pinLoX = -arcW;
        double pinHiX = w;
        double pinLoY = 0.0;
        double pinHiY = h;
        double lrHeight = h;
        if (half == 'T') {
            pinLoY = DBMath.round(h * pwellRatio);
            lrHeight = DBMath.round(h * pwellRatio);
        }
        if (half == 'B') {
            pinHiY = DBMath.round(h * (1.0 - pwellRatio));
            lrHeight = DBMath.round(h * (1.0 - pwellRatio));
        }
        Rectangle2D.Double left = new Rectangle2D.Double(pinLoX, pinLoY, arcW, lrHeight);
        Rectangle2D.Double right = new Rectangle2D.Double(pinHiX, pinLoY, arcW, lrHeight);
        Rectangle2D.Double top = new Rectangle2D.Double(pinLoX, pinHiY, w + 2.0 * arcW, arcW);
        Rectangle2D.Double bottom = new Rectangle2D.Double(pinLoX, pinLoY - arcW, w + 2.0 * arcW, arcW);
        LayoutLib.roundBounds(left);
        LayoutLib.roundBounds(right);
        LayoutLib.roundBounds(top);
        LayoutLib.roundBounds(bottom);
        LayoutLib.newNodeInst(np, left.getCenterX(), left.getCenterY(), ((RectangularShape)left).getWidth(), ((RectangularShape)left).getHeight(), 0.0, f);
        LayoutLib.newNodeInst(np, right.getCenterX(), right.getCenterY(), ((RectangularShape)right).getWidth(), ((RectangularShape)right).getHeight(), 0.0, f);
        if (half != 'B') {
            LayoutLib.newNodeInst(np, top.getCenterX(), top.getCenterY(), ((RectangularShape)top).getWidth(), ((RectangularShape)top).getHeight(), 0.0, f);
        }
        if (half != 'T') {
            LayoutLib.newNodeInst(np, bottom.getCenterX(), bottom.getCenterY(), ((RectangularShape)bottom).getWidth(), ((RectangularShape)bottom).getHeight(), 0.0, f);
        }
    }

    public static Cell makePart(double w, double h, StdCellParams stdCell) {
        boolean is90nm;
        TechType tech = stdCell.getTechType();
        String nm = "drcRing_W" + w + "_H" + h + "{lay}";
        Cell ring = stdCell.findPart(nm);
        if (ring != null) {
            return ring;
        }
        ring = stdCell.newPart(nm);
        boolean bl = is90nm = ring.getTechnology() == Technology.getCMOS90Technology();
        if (is90nm) {
            double pwellRatio = stdCell.getPmosWellHeight() / (stdCell.getNmosWellHeight() + stdCell.getPmosWellHeight());
            DrcRing.drawRing(tech.pselNode(), w, h, 4.8, ring, 'B', pwellRatio);
            DrcRing.drawRing(tech.nselNode(), w, h, 4.8, ring, 'T', pwellRatio);
        } else {
            DrcRing.drawRing(tech.p1(), w, h, ring);
        }
        DrcRing.drawRing(tech.m1(), w, h, ring);
        DrcRing.drawRing(tech.m2(), w, h, ring);
        DrcRing.drawRing(tech.m3(), w, h, ring);
        DrcRing.drawRing(tech.m4(), w, h, ring);
        DrcRing.drawRing(tech.m5(), w, h, ring);
        return ring;
    }
}

