/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.prototype;

import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.AffineTransform;

public class PortOriginal {
    private AffineTransform subrot;
    private Orientation orient;
    private Cell bottomCell;
    private ImmutableNodeInst bottomNode;
    private PortInst bottomPort;
    private NodeInst bottomNi;
    private PrimitivePort bottomPp;

    public PortOriginal(PortInst startPort) {
        this.bottomPort = startPort;
        this.traverse(startPort.getNodeInst(), startPort.getPortProto(), null);
    }

    public PortOriginal(PortInst startPort, AffineTransform pre) {
        this.bottomPort = startPort;
        this.traverse(startPort.getNodeInst(), startPort.getPortProto(), pre);
    }

    public PortOriginal(NodeInst ni, PortProto pp) {
        this.traverse(ni, pp, null);
    }

    private void traverse(NodeInst ni, PortProto pp, AffineTransform pre) {
        this.bottomCell = ni.getParent();
        this.bottomNode = ni.getD();
        this.bottomNi = ni;
        EDatabase database = this.bottomCell != null ? this.bottomCell.getDatabase() : (ni.isCellInstance() ? ((Cell)ni.getProto()).getDatabase() : null);
        this.orient = this.bottomNode.orient;
        this.subrot = this.orient.rotateAbout(this.bottomNode.anchor.getLambdaX(), this.bottomNode.anchor.getLambdaY(), 0.0, 0.0);
        if (pre != null) {
            this.subrot.preConcatenate(pre);
        }
        while (this.bottomNode.protoId instanceof CellId) {
            this.bottomCell = database.getCell((CellId)this.bottomNode.protoId);
            ImmutableExport bottomExport = ((Export)pp).getD();
            this.bottomNode = this.bottomCell.backupUnsafe().getMemoization().getNodeById(bottomExport.originalNodeId);
            this.bottomPort = null;
            this.bottomNi = null;
            pp = bottomExport.originalPortId.inDatabase(database);
            this.orient = this.orient.concatenate(this.bottomNode.orient);
            AffineTransform transform2 = this.bottomNode.orient.rotateAbout(this.bottomNode.anchor.getLambdaX(), this.bottomNode.anchor.getLambdaY(), 0.0, 0.0);
            this.subrot.concatenate(transform2);
        }
        this.bottomPp = (PrimitivePort)pp;
        this.subrot.translate(-this.bottomNode.anchor.getLambdaX(), -this.bottomNode.anchor.getLambdaY());
    }

    public NodeInst getBottomNodeInst() {
        if (this.bottomNi == null) {
            this.bottomPort = this.bottomCell.getPortInst(this.bottomNode.nodeId, this.bottomPp.getId());
            this.bottomNi = this.bottomPort.getNodeInst();
        }
        return this.bottomNi;
    }

    public Cell getBottomCell() {
        return this.bottomCell;
    }

    public ImmutableNodeInst getBottomImmutableNodeInst() {
        return this.bottomNode;
    }

    public PrimitivePort getBottomPortProto() {
        return this.bottomPp;
    }

    public PortInst getBottomPort() {
        if (this.bottomPort == null) {
            this.getBottomNodeInst();
            this.bottomPort = this.bottomNi != null ? this.bottomNi.findPortInstFromProto(this.bottomPp) : null;
        }
        return this.bottomPort;
    }

    public AffineTransform getTransformToTop() {
        return this.subrot;
    }

    public Orientation getOrientToTop() {
        return this.orient;
    }
}

