/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.Main;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.text.EmptyPreferencesFactory;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXParseException;

public class Pref {
    public static final boolean FROM_THREAD_ENVIRONMENT = false;
    private static boolean forbidPreferences;
    private final String name;
    private final Group group;
    private final boolean serverAccessible;
    private Object cachedObj;
    private Object factoryObj;
    private static final ArrayList<Group> allGroups;
    private static boolean doFlushing;
    private static Set<Preferences> queueForFlushing;
    private static boolean lockCreation;
    private static final HashSet<Pref> reportedAccess;

    public static Group groupForPackage(Class classFromPackage) {
        String mainClassName;
        String className = classFromPackage.getName();
        if (!className.startsWith(mainClassName = "com.sun.electric.")) {
            throw new IllegalArgumentException("Class is not in Electric tree");
        }
        className = className.substring(mainClassName.length());
        int pkgEndIndex = className.lastIndexOf(46);
        String packageName = className.substring(0, pkgEndIndex);
        return Pref.groupForPackage(packageName.replace('.', '/'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group groupForPackage(String relativePath) {
        ArrayList<Group> arrayList = allGroups;
        synchronized (arrayList) {
            for (Group group : allGroups) {
                if (!group.relativePath.equals(relativePath)) continue;
                return group;
            }
            Group newGroup = new Group(relativePath);
            allGroups.add(newGroup);
            return newGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pref(Group group, String name, boolean serverAccessible, Object factoryObj) {
        if (lockCreation && serverAccessible) {
            throw new IllegalStateException("Pref " + group.relativePath() + "/" + name + " is created from improper place");
        }
        this.name = name;
        this.group = group;
        this.serverAccessible = serverAccessible;
        this.factoryObj = factoryObj;
        TreeMap treeMap = group.prefs;
        synchronized (treeMap) {
            assert (!group.prefs.containsKey(name));
            group.prefs.put(name, this);
        }
    }

    public static void lockCreation() {
        lockCreation = true;
    }

    public static void forbidPreferences() {
        forbidPreferences = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCachedObjsFromPreferences() {
        ArrayList<Group> arrayList = allGroups;
        synchronized (arrayList) {
            for (Group group : allGroups) {
                group.setCachedObjsFromPreferences();
            }
        }
    }

    public static void importPrefs(URL fileURL) {
        try {
            URLConnection urlCon = fileURL.openConnection();
            InputStream inputStream = urlCon.getInputStream();
            try {
                Pref.clearPrefs(Pref.getPrefRoot());
            }
            catch (BackingStoreException e) {
                System.out.println("Error resetting Electric preferences");
                e.printStackTrace();
            }
            Preferences.importPreferences(inputStream);
            inputStream.close();
        }
        catch (InvalidPreferencesFormatException e) {
            String message = "Invalid preferences format";
            if (e.getCause() instanceof SAXParseException) {
                SAXParseException se = (SAXParseException)e.getCause();
                message = message + " (line " + se.getLineNumber() + ")";
            }
            System.out.println(message + ": " + e.getMessage());
            return;
        }
        catch (IOException e) {
            System.out.println("Error reading preferences file");
            e.printStackTrace();
            return;
        }
    }

    private static void clearPrefs(Preferences topNode) throws BackingStoreException {
        topNode.clear();
        for (String child : topNode.childrenNames()) {
            Pref.clearPrefs(topNode.node(child));
        }
    }

    public static void exportPrefs(String fileName) {
        Pref.exportPrefs(fileName, Pref.getPrefRoot());
    }

    public static void exportPrefs(String fileName, Preferences prefRoot) {
        if (fileName == null) {
            return;
        }
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            prefRoot.exportSubtree(bs);
            String xmlDump = bs.toString();
            int sunPos = xmlDump.indexOf("java.sun.com");
            String insertDTD = "";
            if (sunPos >= 0) {
                int openPos = xmlDump.lastIndexOf(60, sunPos);
                int closePos = xmlDump.indexOf(62, sunPos);
                if (openPos >= 0 && closePos >= 0) {
                    insertDTD = xmlDump.substring(openPos, closePos + 1);
                    xmlDump = xmlDump.substring(0, openPos) + xmlDump.substring(closePos + 1);
                }
            }
            StreamSource source = new StreamSource(new StringReader(xmlDump));
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(2));
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter outSW = Client.isOSMac() ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, "utf-8");
            StreamResult result2 = new StreamResult(outSW);
            transformer.transform(source, result2);
            String xmlFormatted = bos.toString();
            int closePos = xmlFormatted.indexOf(62);
            if (closePos >= 0) {
                xmlFormatted = xmlFormatted.substring(0, closePos + 1) + "\n" + insertDTD + xmlFormatted.substring(closePos + 1);
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            printWriter.print(xmlFormatted);
            printWriter.close();
        }
        catch (Exception e) {
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            System.out.println("Error exporting Preferences");
            return;
        }
        System.out.println("Preferences saved to " + fileName);
    }

    public static Pref makeBooleanPref(String name, Group group, boolean factory) {
        return new Pref(group, name, false, factory);
    }

    public static Pref makeIntPref(String name, Group group, int factory) {
        return new Pref(group, name, false, factory);
    }

    public static Pref makeLongPref(String name, Group group, long factory) {
        return new Pref(group, name, false, factory);
    }

    public static Pref makeDoublePref(String name, Group group, double factory) {
        return new Pref(group, name, false, factory);
    }

    public static Pref makeStringPref(String name, Group group, String factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        return new Pref(group, name, false, factory);
    }

    public static Pref makeBooleanServerPref(String name, Group group, boolean factory) {
        return new Pref(group, name, true, factory);
    }

    public static Pref makeIntServerPref(String name, Group group, int factory) {
        return new Pref(group, name, true, factory);
    }

    public static Pref makeStringServerPref(String name, Group group, String factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        return new Pref(group, name, true, factory);
    }

    public boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    public int getInt() {
        return (Integer)this.getValue();
    }

    public long getLong() {
        return (Long)this.getValue();
    }

    public double getDouble() {
        return ((Number)this.getValue()).doubleValue();
    }

    public String getString() {
        return (String)this.getValue();
    }

    public boolean getBoolean(Preferences prefRoot) {
        return (Boolean)this.getValue(prefRoot);
    }

    public int getInt(Preferences prefRoot) {
        return (Integer)this.getValue(prefRoot);
    }

    public long getLong(Preferences prefRoot) {
        return (Long)this.getValue(prefRoot);
    }

    public double getDouble(Preferences prefRoot) {
        return (Double)this.getValue(prefRoot);
    }

    public String getString(Preferences prefRoot) {
        return (String)this.getValue(prefRoot);
    }

    public Object getFactoryValue() {
        return this.factoryObj;
    }

    public boolean getBooleanFactoryValue() {
        return (Boolean)this.factoryObj;
    }

    public int getIntFactoryValue() {
        return (Integer)this.factoryObj;
    }

    public long getLongFactoryValue() {
        return (Long)this.factoryObj;
    }

    public double getDoubleFactoryValue() {
        return (Double)this.factoryObj;
    }

    public String getStringFactoryValue() {
        return (String)this.factoryObj;
    }

    public String getPrefName() {
        return this.name;
    }

    public String getPrefPath() {
        return this.group.relativePath() + "/" + this.name;
    }

    public Object getValue() {
        if (!(Job.isClientThread() || this.serverAccessible || reportedAccess.contains(this))) {
            String msg = this.getPrefName() + " is accessed from " + Job.getRunningJob();
            if (Job.getDebug()) {
                ActivityLogger.logMessage(msg);
                System.out.println(msg);
            }
            reportedAccess.add(this);
        }
        if (this.cachedObj == null) {
            this.setCachedObjFromPreferences();
        }
        return this.cachedObj;
    }

    public Object getValue(Preferences prefRoot) {
        return Pref.getValueImpl(prefRoot.node(this.group.relativePath), this.name, this.factoryObj);
    }

    private static Object getValueImpl(Preferences preferences, String key, Object def) {
        Object value2 = def;
        if (def instanceof Boolean) {
            boolean defV = (Boolean)def;
            boolean v = preferences.getBoolean(key, defV);
            if (v != defV) {
                value2 = v;
            }
        } else if (def instanceof Integer) {
            int defV = (Integer)def;
            int v = preferences.getInt(key, defV);
            if (v != defV) {
                value2 = v;
            }
        } else if (def instanceof Long) {
            long defV = (Long)def;
            long v = preferences.getLong(key, defV);
            if (v != defV) {
                value2 = v;
            }
        } else if (def instanceof Double) {
            double defV = (Double)def;
            double v = preferences.getDouble(key, defV);
            if (v != defV) {
                value2 = v;
            }
        } else {
            assert (def instanceof String);
            value2 = preferences.get(key, (String)def);
        }
        return value2;
    }

    private void setValue(Object value2) {
        assert (value2.getClass() == this.factoryObj.getClass());
        this.cachedObj = value2.equals(this.factoryObj) ? this.factoryObj : value2;
        this.group.putValue(this.name, this.cachedObj);
    }

    private void setCachedObjFromPreferences() {
        this.cachedObj = this.group.getValue(this.name, this.factoryObj);
    }

    public static void delayPrefFlushing() {
        doFlushing = false;
        queueForFlushing = new HashSet<Preferences>();
    }

    public static void resumePrefFlushing() {
        doFlushing = true;
        for (Preferences p : queueForFlushing) {
            Pref.flushOptions(p);
        }
        Pref.flushAll();
    }

    public static Preferences getPrefRoot() {
        if (forbidPreferences) {
            return Pref.getFactoryPrefRoot();
        }
        return Preferences.userNodeForPackage(Main.class);
    }

    public static Preferences getLibraryPreferences(LibId libId) {
        return Pref.getPrefRoot().node("database/hierarchy/" + libId.libName);
    }

    public static Preferences getFactoryPrefRoot() {
        return EmptyPreferencesFactory.factoryPrefRoot;
    }

    public static void flushAll() {
        Pref.flushOptions(Pref.getPrefRoot());
    }

    public void setBoolean(boolean v) {
        this.checkModify();
        boolean cachedBool = this.getBoolean();
        if (v != cachedBool) {
            this.setValue(v);
        }
    }

    public void setInt(int v) {
        this.checkModify();
        int cachedInt = this.getInt();
        if (v != cachedInt) {
            this.setValue(v);
        }
    }

    public void setLong(long v) {
        this.checkModify();
        long cachedLong = this.getLong();
        if (v != cachedLong) {
            this.setValue(v);
        }
    }

    public void setDouble(double v) {
        this.checkModify();
        double cachedDouble = this.getDouble();
        if (v != cachedDouble) {
            this.setValue(v);
        }
    }

    public void setString(String str) {
        this.checkModify();
        String cachedString = this.getString();
        if (!str.equals(cachedString)) {
            this.setValue(str);
        }
    }

    public void putBoolean(Preferences prefRoot, boolean removeDefaults, boolean v) {
        Preferences prefs = prefRoot.node(this.group.relativePath);
        if (removeDefaults && v == (Boolean)this.factoryObj) {
            prefs.remove(this.name);
        } else {
            prefs.putBoolean(this.name, v);
        }
    }

    public void putInt(Preferences prefRoot, boolean removeDefaults, int v) {
        Preferences prefs = prefRoot.node(this.group.relativePath);
        if (removeDefaults && v == (Integer)this.factoryObj) {
            prefs.remove(this.name);
        } else {
            prefs.putInt(this.name, v);
        }
    }

    public void putLong(Preferences prefRoot, boolean removeDefaults, long v) {
        Preferences prefs = prefRoot.node(this.group.relativePath);
        if (removeDefaults && v == (Long)this.factoryObj) {
            prefs.remove(this.name);
        } else {
            prefs.putLong(this.name, v);
        }
    }

    public void putDouble(Preferences prefRoot, boolean removeDefaults, double v) {
        Preferences prefs = prefRoot.node(this.group.relativePath);
        if (removeDefaults && v == (Double)this.factoryObj) {
            prefs.remove(this.name);
        } else {
            prefs.putDouble(this.name, v);
        }
    }

    public void putString(Preferences prefRoot, boolean removeDefaults, String str) {
        Preferences prefs = prefRoot.node(this.group.relativePath);
        if (removeDefaults && str.equals(this.factoryObj)) {
            prefs.remove(this.name);
        } else {
            prefs.put(this.name, str);
        }
    }

    public void factoryReset() {
        if (!Job.isClientThread()) {
            throw new IllegalStateException();
        }
        this.cachedObj = this.factoryObj;
        this.group.remove(this.name);
    }

    private void checkModify() {
        if (!Job.isClientThread() && !this.serverAccessible) {
            String msg = this.getPrefName() + " is modified in " + Job.getRunningJob();
            if (Job.getDebug()) {
                ActivityLogger.logMessage(msg);
                System.out.println(msg);
            }
        }
    }

    public static Collection<Group> getAllGroups() {
        return Collections.unmodifiableCollection(allGroups);
    }

    private static void flushOptions(Preferences p) {
        try {
            p.flush();
        }
        catch (Exception e) {
            System.out.println("Failed to save preferences");
        }
    }

    static {
        allGroups = new ArrayList();
        doFlushing = true;
        reportedAccess = new HashSet();
    }

    public static class Group {
        private final String relativePath;
        private boolean lockCreation;
        Preferences preferences;
        private final TreeMap<String, Pref> prefs = new TreeMap();

        private Group(String relativePath) {
            this.relativePath = relativePath;
        }

        public String relativePath() {
            return this.relativePath;
        }

        public Collection<Pref> getPrefs() {
            return Collections.unmodifiableCollection(this.prefs.values());
        }

        public void lockCreation() {
            this.lockCreation = true;
        }

        public void setCachedObjsFromPreferences() {
            for (Pref pref : this.prefs.values()) {
                pref.setCachedObjFromPreferences();
            }
        }

        private void putValue(String key, Object value2) {
            if (this.preferences == null) {
                this.preferences = Pref.getPrefRoot().node(this.relativePath);
            }
            this.putValue(this.preferences, key, value2);
            if (doFlushing) {
                Pref.flushOptions(this.preferences);
            } else {
                queueForFlushing.add(this.preferences);
            }
        }

        private void putValue(Preferences preferences, String key, Object value2) {
            if (value2 instanceof Boolean) {
                preferences.putBoolean(key, (Boolean)value2);
            } else if (value2 instanceof Integer) {
                preferences.putInt(key, (Integer)value2);
            } else if (value2 instanceof Long) {
                preferences.putLong(key, (Long)value2);
            } else if (value2 instanceof Double) {
                preferences.putDouble(key, (Double)value2);
            } else {
                assert (value2 instanceof String);
                preferences.put(key, (String)value2);
            }
        }

        private Object getValue(String key, Object def) {
            if (this.preferences == null) {
                this.preferences = Pref.getPrefRoot().node(this.relativePath);
            }
            return Pref.getValueImpl(this.preferences, key, def);
        }

        private void remove(String key) {
            if (this.preferences == null) {
                this.preferences = Pref.getPrefRoot().node(this.relativePath);
            }
            this.remove(this.preferences, key);
            if (doFlushing) {
                Pref.flushOptions(this.preferences);
            } else {
                queueForFlushing.add(this.preferences);
            }
        }

        private void remove(Preferences preferences, String key) {
            preferences.remove(key);
        }
    }
}

