/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.dialogs.TextInfoPanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GetInfoExport
extends EModelessDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoExport theDialog = null;
    private Export shownExport;
    private String initialName;
    private String initialRefName;
    private String initialCharacteristicName;
    private boolean initialBodyOnly;
    private boolean initialAlwaysDrawn;
    private TextInfoPanel textPanel;
    private JCheckBox alwaysDrawn;
    private JButton apply;
    private JCheckBox bodyOnly;
    private JButton cancel;
    private JLabel centerLoc;
    private JComboBox characteristics;
    private JLabel header;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JPanel leftSide;
    private JButton ok;
    private JTextField refName;
    private JTextField theText;

    public static void showDialog() {
        if (Client.getOperatingSystem() == Client.OS.UNIX) {
            if (theDialog != null) {
                theDialog.dispose();
            }
            theDialog = null;
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new GetInfoExport(jf);
        }
        theDialog.loadExportInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
            theDialog.ensureProperSize();
            theDialog.setVisible(true);
        }
        theDialog.toFront();
    }

    @Override
    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadExportInfo();
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadExportInfo();
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (e.objectChanged(this.shownExport)) {
            this.loadExportInfo();
        }
    }

    private void loadExportInfo() {
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd == null) {
            this.disableDialog();
            return;
        }
        Export pp = null;
        int exportCount = 0;
        for (Highlight h : curWnd.getHighlighter().getHighlights()) {
            ElectricObject eobj;
            if (!h.isHighlightText() || h.getVarKey() != Export.EXPORT_NAME || !((eobj = h.getElectricObject()) instanceof Export)) continue;
            pp = (Export)eobj;
            ++exportCount;
        }
        if (exportCount > 1) {
            pp = null;
        }
        boolean enabled = true;
        if (pp == null) {
            enabled = false;
        }
        EDialog.focusClearOnTextField(this.theText);
        this.theText.setEditable(enabled);
        this.bodyOnly.setEnabled(enabled);
        this.alwaysDrawn.setEnabled(enabled);
        this.characteristics.setEnabled(enabled);
        this.refName.setEditable(enabled);
        if (!enabled) {
            this.disableDialog();
            return;
        }
        this.initialName = pp.getName();
        this.theText.setText(this.initialName);
        Poly poly = pp.getPoly();
        Technology tech = curWnd.getCell().getTechnology();
        this.centerLoc.setText("Center: (" + TextUtils.formatDistance(poly.getCenterX(), tech) + "," + TextUtils.formatDistance(poly.getCenterY(), tech) + ")");
        this.initialBodyOnly = pp.isBodyOnly();
        this.bodyOnly.setSelected(this.initialBodyOnly);
        this.initialAlwaysDrawn = pp.isAlwaysDrawn();
        this.alwaysDrawn.setSelected(this.initialAlwaysDrawn);
        PortCharacteristic initialCharacteristic = pp.getCharacteristic();
        this.initialCharacteristicName = initialCharacteristic.getName();
        this.characteristics.setSelectedItem(this.initialCharacteristicName);
        this.initialRefName = "";
        if (initialCharacteristic == PortCharacteristic.REFBASE || initialCharacteristic == PortCharacteristic.REFIN || initialCharacteristic == PortCharacteristic.REFOUT) {
            Variable var = pp.getVar(Export.EXPORT_REFERENCE_NAME);
            if (var != null) {
                this.initialRefName = var.describe(-1);
            }
            this.refName.setEditable(true);
        } else {
            this.refName.setEditable(false);
        }
        this.refName.setText(this.initialRefName);
        this.textPanel.setTextDescriptor(Export.EXPORT_NAME, pp);
        this.shownExport = pp;
        EDialog.focusOnTextField(this.theText);
    }

    private void disableDialog() {
        this.shownExport = null;
        this.theText.setText("");
        this.refName.setText("");
        this.centerLoc.setText("");
        this.textPanel.setTextDescriptor(null, null);
    }

    private GetInfoExport(Frame parent) {
        super(parent);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        EDialog.makeTextFieldSelectAllOnTab(this.refName);
        EDialog.makeTextFieldSelectAllOnTab(this.theText);
        UserInterfaceMain.addDatabaseChangeListener(this);
        Highlighter.addHighlightListener(this);
        List<PortCharacteristic> chars = PortCharacteristic.getOrderedCharacteristics();
        for (PortCharacteristic ch : chars) {
            this.characteristics.addItem(ch.getName());
        }
        this.textPanel = new TextInfoPanel(false, false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.textPanel, gridBagConstraints);
        this.pack();
        this.loadExportInfo();
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.apply = new JButton();
        this.leftSide = new JPanel();
        this.jLabel10 = new JLabel();
        this.characteristics = new JComboBox();
        this.jLabel1 = new JLabel();
        this.refName = new JTextField();
        this.bodyOnly = new JCheckBox();
        this.alwaysDrawn = new JCheckBox();
        this.centerLoc = new JLabel();
        this.header = new JLabel();
        this.theText = new JTextField();
        this.setTitle("Export Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GetInfoExport.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoExport.this.cancelActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoExport.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoExport.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.leftSide.setBorder(BorderFactory.createEtchedBorder());
        this.leftSide.setLayout(new GridBagLayout());
        this.jLabel10.setText("Characteristics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.leftSide.add((Component)this.jLabel10, gridBagConstraints);
        this.characteristics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoExport.this.characteristicsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.leftSide.add((Component)this.characteristics, gridBagConstraints);
        this.jLabel1.setText("Reference name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.leftSide.add((Component)this.jLabel1, gridBagConstraints);
        this.refName.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.leftSide.add((Component)this.refName, gridBagConstraints);
        this.bodyOnly.setText("Body only");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.leftSide.add((Component)this.bodyOnly, gridBagConstraints);
        this.alwaysDrawn.setText("Always drawn");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.leftSide.add((Component)this.alwaysDrawn, gridBagConstraints);
        this.centerLoc.setText("Center:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.leftSide.add((Component)this.centerLoc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.leftSide, gridBagConstraints);
        this.header.setText("Export name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.header, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.theText, gridBagConstraints);
        this.pack();
    }

    private void characteristicsActionPerformed(ActionEvent evt) {
        String stringNow = (String)this.characteristics.getSelectedItem();
        PortCharacteristic ch = PortCharacteristic.findCharacteristic(stringNow);
        this.refName.setEditable(ch.isReference());
    }

    private void applyActionPerformed(ActionEvent evt) {
        String newRefName;
        String newCharName;
        boolean newAlwaysDrawn;
        boolean newBodyOnly;
        if (this.shownExport == null) {
            return;
        }
        boolean changed = false;
        String newName = this.theText.getText();
        if (!newName.equals(this.initialName)) {
            changed = true;
        }
        if ((newBodyOnly = this.bodyOnly.isSelected()) != this.initialBodyOnly) {
            changed = true;
        }
        if ((newAlwaysDrawn = this.alwaysDrawn.isSelected()) != this.initialAlwaysDrawn) {
            changed = true;
        }
        if (!(newCharName = (String)this.characteristics.getSelectedItem()).equals(this.initialCharacteristicName)) {
            changed = true;
        }
        if (!(newRefName = this.refName.getText()).equals(this.initialRefName)) {
            changed = true;
        }
        if (changed) {
            new ChangeExport(this.shownExport, this.initialName, newName, newBodyOnly, newAlwaysDrawn, newCharName, newRefName);
        }
        this.textPanel.applyChanges(true);
        this.initialName = newName;
        this.initialBodyOnly = newBodyOnly;
        this.initialAlwaysDrawn = newAlwaysDrawn;
        this.initialCharacteristicName = newCharName;
        this.initialRefName = newRefName;
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        super.closeDialog();
    }

    private static class ChangeExport
    extends Job {
        private Export pp;
        private String oldName;
        private String newName;
        private boolean newBodyOnly;
        private boolean newAlwaysDrawn;
        private String newCharName;
        private String newRefName;

        protected ChangeExport(Export pp, String oldName, String newName, boolean newBodyOnly, boolean newAlwaysDrawn, String newCharName, String newRefName) {
            super("Modify Export", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pp = pp;
            this.oldName = oldName;
            this.newName = newName;
            this.newBodyOnly = newBodyOnly;
            this.newAlwaysDrawn = newAlwaysDrawn;
            this.newCharName = newCharName;
            this.newRefName = newRefName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (!this.oldName.equals(this.newName)) {
                this.pp.rename(this.newName);
            }
            this.pp.setBodyOnly(this.newBodyOnly);
            this.pp.setAlwaysDrawn(this.newAlwaysDrawn);
            PortCharacteristic newChar = PortCharacteristic.findCharacteristic(this.newCharName);
            if (newChar != this.pp.getCharacteristic()) {
                Cell otherCell;
                this.pp.setCharacteristic(newChar);
                ArrayList<Cell> othersChanged = new ArrayList<Cell>();
                Cell thisCell = this.pp.getParent();
                Iterator<Cell> it = thisCell.getCellGroup().getCells();
                while (it.hasNext()) {
                    otherCell = it.next();
                    if (otherCell == thisCell) continue;
                    List<Export> otherPPs = this.pp.findAllEquivalents(otherCell, true);
                    for (Export otherPP : otherPPs) {
                        if (otherPP.getCharacteristic() == newChar) continue;
                        otherPP.setCharacteristic(newChar);
                        othersChanged.add(otherCell);
                    }
                }
                if (othersChanged.size() > 0) {
                    System.out.print("Also changed the characteristic of this export in");
                    for (int i = 0; i < othersChanged.size(); ++i) {
                        otherCell = (Cell)othersChanged.get(i);
                        if (i != 0) {
                            System.out.print(",");
                        }
                        System.out.print(" " + otherCell.describe(false));
                    }
                    System.out.println();
                }
            }
            if (newChar.isReference()) {
                this.pp.newVar(Export.EXPORT_REFERENCE_NAME, (Object)this.newRefName);
            }
            return true;
        }
    }
}

