/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class PortsAndExportsTab
extends PreferencePanel {
    private ButtonGroup exportGroup;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JSeparator jSeparator2;
    private JSeparator jSeparator9;
    private JPanel port;
    private JRadioButton portCrossExport;
    private JRadioButton portCrossPort;
    private JRadioButton portFullExport;
    private JRadioButton portFullPort;
    private ButtonGroup portGroup;
    private JCheckBox portMoveNode;
    private JRadioButton portShortExport;
    private JRadioButton portShortPort;

    public PortsAndExportsTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.port;
    }

    @Override
    public String getName() {
        return "Ports/Exports";
    }

    @Override
    public void init() {
        GraphicsPreferences gp = UserInterfaceMain.getGraphicsPreferences();
        switch (gp.portDisplayLevel) {
            case 0: {
                this.portFullPort.setSelected(true);
                break;
            }
            case 1: {
                this.portShortPort.setSelected(true);
                break;
            }
            case 2: {
                this.portCrossPort.setSelected(true);
            }
        }
        switch (gp.exportDisplayLevel) {
            case 0: {
                this.portFullExport.setSelected(true);
                break;
            }
            case 1: {
                this.portShortExport.setSelected(true);
                break;
            }
            case 2: {
                this.portCrossExport.setSelected(true);
            }
        }
        this.portMoveNode.setSelected(User.isMoveNodeWithExport());
    }

    @Override
    public void term() {
        GraphicsPreferences oldGp;
        GraphicsPreferences gp = oldGp = UserInterfaceMain.getGraphicsPreferences();
        int curInt = 0;
        if (this.portShortPort.isSelected()) {
            curInt = 1;
        } else if (this.portCrossPort.isSelected()) {
            curInt = 2;
        }
        gp = gp.withPortDisplayLevel(curInt);
        curInt = 0;
        if (this.portShortExport.isSelected()) {
            curInt = 1;
        } else if (this.portCrossExport.isSelected()) {
            curInt = 2;
        }
        gp = gp.withExportDisplayLevel(curInt);
        boolean currentMoveNodeWithExport = this.portMoveNode.isSelected();
        if (currentMoveNodeWithExport != User.isMoveNodeWithExport()) {
            User.setMoveNodeWithExport(currentMoveNodeWithExport);
        }
        UserInterfaceMain.setGraphicsPreferences(gp);
        if (gp != oldGp) {
            EditWindow.repaintAllContents();
        }
    }

    @Override
    public void reset() {
        UserInterfaceMain.setGraphicsPreferences(UserInterfaceMain.getGraphicsPreferences().withDisplayLevelReset());
        if (User.isFactoryMoveNodeWithExport() != User.isMoveNodeWithExport()) {
            User.setMoveNodeWithExport(User.isFactoryMoveNodeWithExport());
        }
    }

    private void initComponents() {
        this.portGroup = new ButtonGroup();
        this.exportGroup = new ButtonGroup();
        this.port = new JPanel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.portFullPort = new JRadioButton();
        this.portFullExport = new JRadioButton();
        this.portShortPort = new JRadioButton();
        this.portShortExport = new JRadioButton();
        this.portCrossPort = new JRadioButton();
        this.portCrossExport = new JRadioButton();
        this.jSeparator2 = new JSeparator();
        this.portMoveNode = new JCheckBox();
        this.jSeparator9 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PortsAndExportsTab.this.closeDialog(evt);
            }
        });
        this.port.setLayout(new GridBagLayout());
        this.jLabel11.setText("Ports (in instances):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.port.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setText("Exports (in cells):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.port.add((Component)this.jLabel12, gridBagConstraints);
        this.portFullPort.setText("Full Names");
        this.portGroup.add(this.portFullPort);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.port.add((Component)this.portFullPort, gridBagConstraints);
        this.portFullExport.setText("Full Names");
        this.exportGroup.add(this.portFullExport);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.port.add((Component)this.portFullExport, gridBagConstraints);
        this.portShortPort.setText("Short Names");
        this.portGroup.add(this.portShortPort);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.port.add((Component)this.portShortPort, gridBagConstraints);
        this.portShortExport.setText("Short Names");
        this.exportGroup.add(this.portShortExport);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.port.add((Component)this.portShortExport, gridBagConstraints);
        this.portCrossPort.setText("Crosses");
        this.portGroup.add(this.portCrossPort);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.port.add((Component)this.portCrossPort, gridBagConstraints);
        this.portCrossExport.setText("Crosses");
        this.exportGroup.add(this.portCrossExport);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.port.add((Component)this.portCrossExport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.port.add((Component)this.jSeparator2, gridBagConstraints);
        this.portMoveNode.setText("Move node with export name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.port.add((Component)this.portMoveNode, gridBagConstraints);
        this.jSeparator9.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 3;
        this.port.add((Component)this.jSeparator9, gridBagConstraints);
        this.getContentPane().add((Component)this.port, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

