/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellRevisionJ;
import com.sun.electric.database.CellRevisionProvider;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ArrayIterator;
import java.util.Iterator;

public class CellRevisionProviderDefault
extends CellRevisionProvider {
    private static final ImmutableNodeInstIterable emptyNodeList = new ImmutableNodeInstIterable(ImmutableNodeInst.NULL_ARRAY);
    private static final ImmutableArcInstIterable emptyArcList = new ImmutableArcInstIterable(ImmutableArcInst.NULL_ARRAY);
    private static final ImmutableExportIterable emptyExportList = new ImmutableExportIterable(ImmutableExport.NULL_ARRAY);

    @Override
    public CellRevision createCellRevision(ImmutableCell c) {
        return new CellRevisionJ(c);
    }

    @Override
    protected ImmutableNodeInst.Iterable createNodeList(ImmutableNodeInst[] elems, ImmutableNodeInst.Iterable oldList) {
        if (elems != null) {
            return elems.length != 0 ? new ImmutableNodeInstIterable(elems) : emptyNodeList;
        }
        return oldList != null ? oldList : emptyNodeList;
    }

    @Override
    protected ImmutableArcInst.Iterable createArcList(ImmutableArcInst[] elems, ImmutableArcInst.Iterable oldList) {
        if (elems != null) {
            return elems.length != 0 ? new ImmutableArcInstIterable(elems) : emptyArcList;
        }
        return oldList != null ? oldList : emptyArcList;
    }

    @Override
    protected ImmutableExport.Iterable createExportList(ImmutableExport[] elems, ImmutableExport.Iterable oldList) {
        if (elems != null) {
            return elems.length != 0 ? new ImmutableExportIterable(elems) : emptyExportList;
        }
        return oldList != null ? oldList : emptyExportList;
    }

    public static class ImmutableExportIterable
    implements ImmutableExport.Iterable {
        private final ImmutableExport[] elems;

        ImmutableExportIterable(ImmutableExport[] elems) {
            this.elems = elems;
            ImmutableExport prevE = null;
            for (ImmutableExport e : this.elems) {
                if (prevE != null && TextUtils.STRING_NUMBER_ORDER.compare(prevE.name.toString(), e.name.toString()) >= 0) {
                    throw new IllegalArgumentException("exports order");
                }
                prevE = e;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.elems.length == 0;
        }

        @Override
        public int size() {
            return this.elems.length;
        }

        @Override
        public ImmutableExport get(int index) {
            return this.elems[index];
        }

        @Override
        public Iterator<ImmutableExport> iterator() {
            return ArrayIterator.iterator(this.elems);
        }

        @Override
        public int searchByName(String name) {
            int high;
            int low = 0;
            int pick = high = this.elems.length - 1;
            while (low <= high) {
                ImmutableExport e = this.elems[pick];
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(e.name.toString(), name);
                if (cmp < 0) {
                    low = pick + 1;
                } else if (cmp > 0) {
                    high = pick - 1;
                } else {
                    return pick;
                }
                pick = low + high >> 1;
            }
            return -(low + 1);
        }

        @Override
        public ImmutableExport[] toArray() {
            return (ImmutableExport[])this.elems.clone();
        }
    }

    public static class ImmutableArcInstIterable
    implements ImmutableArcInst.Iterable {
        private final ImmutableArcInst[] elems;

        ImmutableArcInstIterable(ImmutableArcInst[] elems) {
            this.elems = elems;
            ImmutableArcInst prevA = null;
            for (ImmutableArcInst a : this.elems) {
                int cmp;
                if (prevA != null && ((cmp = TextUtils.STRING_NUMBER_ORDER.compare(prevA.name.toString(), a.name.toString())) > 0 || cmp == 0 && (a.name.isTempname() || prevA.arcId >= a.arcId))) {
                    throw new IllegalArgumentException("arcs order");
                }
                prevA = a;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.elems.length == 0;
        }

        @Override
        public int size() {
            return this.elems.length;
        }

        @Override
        public ImmutableArcInst get(int index) {
            return this.elems[index];
        }

        @Override
        public Iterator<ImmutableArcInst> iterator() {
            return ArrayIterator.iterator(this.elems);
        }

        @Override
        public int searchByName(String name) {
            int high;
            int low = 0;
            int pick = high = this.elems.length - 1;
            while (low <= high) {
                ImmutableArcInst a = this.elems[pick];
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(a.name.toString(), name);
                if (cmp < 0) {
                    low = pick + 1;
                } else if (cmp > 0) {
                    high = pick - 1;
                } else {
                    return pick;
                }
                pick = low + high >> 1;
            }
            return -(low + 1);
        }
    }

    public static class ImmutableNodeInstIterable
    implements ImmutableNodeInst.Iterable {
        private final ImmutableNodeInst[] elems;

        ImmutableNodeInstIterable(ImmutableNodeInst[] elems) {
            this.elems = elems;
            ImmutableNodeInst prevN = null;
            for (ImmutableNodeInst n : this.elems) {
                if (prevN != null && TextUtils.STRING_NUMBER_ORDER.compare(prevN.name.toString(), n.name.toString()) >= 0) {
                    throw new IllegalArgumentException("nodes order");
                }
                prevN = n;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.elems.length == 0;
        }

        @Override
        public int size() {
            return this.elems.length;
        }

        @Override
        public ImmutableNodeInst get(int index) {
            return this.elems[index];
        }

        @Override
        public Iterator<ImmutableNodeInst> iterator() {
            return ArrayIterator.iterator(this.elems);
        }

        @Override
        public int searchByName(String name) {
            int high;
            int low = 0;
            int pick = high = this.elems.length - 1;
            while (low <= high) {
                ImmutableNodeInst n = this.elems[pick];
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(n.name.toString(), name);
                if (cmp < 0) {
                    low = pick + 1;
                } else if (cmp > 0) {
                    high = pick - 1;
                } else {
                    return pick;
                }
                pick = low + high >> 1;
            }
            return -(low + 1);
        }
    }
}

