/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.FlagAnnotations;
import com.sun.electric.tool.generator.flag.FlagConstructorData;
import com.sun.electric.tool.generator.flag.Utils;
import com.sun.electric.tool.routing.SeaOfGates;
import java.lang.reflect.Constructor;

public class Flag {
    private static void prln(String s) {
        Utils.prln(s);
    }

    private void doEverything(Cell schCell, Job flagJob, EditingPreferences ep, SeaOfGates.SeaOfGatesOptions prefs) {
        FlagAnnotations ann = new FlagAnnotations(schCell);
        if (!ann.isAutoGen()) {
            Flag.prln("Cell: " + schCell.libDescribe() + " has no autoGen annotation");
            return;
        }
        String className = ann.getAutoGenClassName();
        Class<?> layGenClass = null;
        try {
            layGenClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Flag.prln("Can't find layout generator class: " + className);
            return;
        }
        Constructor<?> layGenConstructor = null;
        try {
            layGenConstructor = layGenClass.getConstructor(FlagConstructorData.class);
        }
        catch (NoSuchMethodException e) {
            Flag.prln("Layout generator class: " + className + " has no contructor that takes arguments: (FlagConstructorData)");
            return;
        }
        Library autoLib = schCell.getLibrary();
        String groupName = schCell.getCellName().getName();
        Flag.prln("Generate layout for Cell: " + groupName);
        Flag.prln("Using layout generator: " + className);
        Cell layCell = Cell.newInstance(autoLib, groupName + "{lay}");
        layCell.setTechnology(Technology.getCMOS90Technology());
        try {
            layGenConstructor.newInstance(new FlagConstructorData(layCell, schCell, flagJob, ep, prefs));
        }
        catch (Throwable th) {
            Flag.prln("Layout generator: " + className + " threw Exception: " + th.getMessage());
            Flag.prln("Printing stack trace:");
            Utils.printStackTrace(th);
            th.printStackTrace();
        }
    }

    public Flag(Cell schCell, Job flagJob, EditingPreferences ep, SeaOfGates.SeaOfGatesOptions prefs) {
        try {
            this.doEverything(schCell, flagJob, ep, prefs);
        }
        catch (Throwable th) {
            Flag.prln("Oh my! Something went wrong.");
            Utils.printStackTrace(th);
            th.printStackTrace();
        }
    }
}

