/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.tool.generator.layout.fill.MetalFloorplanBase;

class MetalFloorplan
extends MetalFloorplanBase {
    public final boolean mergedVdd;
    public final double vddCenter;
    public final double gndCenter;
    public final double coverage;

    private double roundDownOneLambda(double x2) {
        return Math.floor(x2);
    }

    MetalFloorplan(double cellWidth, double cellHeight, double vddReserve, double gndReserve, double space, boolean horiz) {
        super(cellWidth, cellHeight, horiz);
        this.mergedVdd = vddReserve == 0.0;
        double cellSpace = horiz ? cellHeight : cellWidth;
        double metalSpace = cellSpace - 2.0 * space - vddReserve - gndReserve;
        this.gndWidth = this.roundDownOneLambda(metalSpace / 4.0);
        this.gndCenter = cellSpace / 2.0 - gndReserve / 2.0 - this.gndWidth / 2.0;
        if (this.mergedVdd) {
            this.vddWidth = this.gndWidth * 2.0;
            this.vddCenter = 0.0;
        } else {
            this.vddWidth = this.gndWidth;
            this.vddCenter = vddReserve / 2.0 + this.vddWidth / 2.0;
        }
        double cellArea = cellWidth * cellHeight;
        double strapLength = horiz ? cellWidth : cellHeight;
        double vddArea = (double)(this.mergedVdd ? 1 : 2) * this.vddWidth * strapLength;
        double gndArea = 2.0 * this.gndWidth * strapLength;
        this.coverage = (vddArea + gndArea) / cellArea;
    }
}

