/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.tool.generator.sclibrary.SCLibraryGen;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Topology
extends Output {
    private static final boolean DEBUGTOPOLOGY = false;
    protected Cell topCell;
    private Map<String, CellNetInfo> cellTopos;
    private Map<Cell, String> cellNameMap;
    private HierarchyEnumerator.CellInfo lastInfo;

    @Override
    public boolean writeCell(Cell cell, VarContext context) {
        this.writeCell(cell, context, new Visitor(this));
        return false;
    }

    public boolean writeCell(Cell cell, VarContext context, Visitor visitor) {
        this.topCell = cell;
        this.cellTopos = new HashMap<String, CellNetInfo>();
        this.cellNameMap = this.makeCellNameMap(this.topCell);
        this.start();
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)visitor, this.getShortResistors());
        this.done();
        return false;
    }

    protected abstract void start();

    protected abstract void done();

    protected void enterCell(HierarchyEnumerator.CellInfo info) {
    }

    protected abstract void writeCellTopology(Cell var1, String var2, CellNetInfo var3, VarContext var4, MyCellInfo var5);

    protected abstract String getSafeNetName(String var1, boolean var2);

    protected abstract String getSafeCellName(String var1);

    protected abstract String getPowerName(Network var1);

    protected abstract String getGroundName(Network var1);

    protected abstract String getGlobalName(Global var1);

    protected abstract boolean isNetworksUseExportedNames();

    protected abstract boolean isLibraryNameAlwaysAddedToCellName();

    protected abstract boolean isAggregateNamesSupported();

    protected abstract boolean isAggregateNameGapsSupported();

    protected boolean isChooseBestExportName() {
        return true;
    }

    protected abstract boolean isSeparateInputAndOutput();

    protected abstract boolean isCaseSensitive();

    protected boolean skipCellAndSubcells(Cell cell) {
        return false;
    }

    protected boolean isWriteCopyForEachIcon() {
        return false;
    }

    protected void validateSkippedCell(HierarchyEnumerator.CellInfo info) {
    }

    protected boolean canParameterizeNames() {
        return false;
    }

    protected Netlist.ShortResistors getShortResistors() {
        return Netlist.ShortResistors.NO;
    }

    protected boolean isShortResistors() {
        return this.getShortResistors() != Netlist.ShortResistors.NO;
    }

    protected boolean isShortExplicitResistors() {
        return this.getShortResistors() == Netlist.ShortResistors.ALL;
    }

    protected boolean visitIcons() {
        return false;
    }

    protected int maxNameLength() {
        return 0;
    }

    protected CellNetInfo getCellNetInfo(String cellName) {
        CellNetInfo cni = this.cellTopos.get(cellName);
        return cni;
    }

    protected boolean enumerateLayoutView(Cell cell) {
        return false;
    }

    private CellNetInfo getNetworkInformation(Cell cell, boolean quiet, String paramName, boolean useExportedName, HierarchyEnumerator.CellInfo info) {
        CellNetInfo cni = this.doGetNetworks(cell, quiet, paramName, useExportedName, info);
        return cni;
    }

    private CellNetInfo doGetNetworks(Cell cell, boolean quiet, String paramName, boolean useExportedName, HierarchyEnumerator.CellInfo info) {
        CellSignal cs;
        Iterator<String> nIt;
        CellNetInfo cni = new CellNetInfo();
        cni.cell = cell;
        cni.paramName = paramName;
        cni.netList = info.getNetlist();
        Global.Set globals = cni.netList.getGlobals();
        int globalSize = globals.size();
        cni.cellSignals = new HashMap();
        Iterator<Network> it = cni.netList.getNetworks();
        while (it.hasNext()) {
            PortInst onlyPI;
            PortProto pp;
            Iterator<PortInst> pIt;
            Network net = it.next();
            if (!net.isExported() && !net.getArcs().hasNext() && (pIt = net.getPorts()).hasNext() && (pp = (onlyPI = pIt.next()).getPortProto()) instanceof PrimitivePort && !pIt.hasNext() && ((PrimitivePort)pp).isWellPort()) continue;
            CellSignal cs2 = new CellSignal();
            cs2.pp = null;
            cs2.descending = !NetworkTool.isBusAscending();
            cs2.power = false;
            cs2.ground = false;
            cs2.net = net;
            cs2.globalSignal = null;
            for (int j = 0; j < globalSize; ++j) {
                Global global = globals.get(j);
                if (cni.netList.getNetwork(global) != net) continue;
                cs2.globalSignal = global;
                break;
            }
            if (cs2.globalSignal != null) {
                cs2.name = this.getGlobalName(cs2.globalSignal);
            } else {
                cs2.name = net.getName();
            }
            cni.cellSignals.put(net, cs2);
        }
        for (int j = 0; j < 2; ++j) {
            Iterator<ArcInst> aIt = cell.getArcs();
            while (aIt.hasNext()) {
                int width;
                ArcInst ai = aIt.next();
                if ((!ai.getNameKey().isTempname() ? j == 0 : j != 0) || (width = cni.netList.getBusWidth(ai)) < 2) continue;
                Network[] nets = new Network[width];
                String[] netNames = new String[width];
                for (int i = 0; i < width; ++i) {
                    nets[i] = cni.netList.getNetwork(ai, i);
                    netNames[i] = null;
                    if (j != 0) {
                        String preferredName = ai.getNameKey().subname(i).toString();
                        nIt = nets[i].getNames();
                        while (nIt.hasNext()) {
                            String netName = nIt.next();
                            if (!netName.equals(preferredName)) continue;
                            netNames[i] = netName;
                            break;
                        }
                    }
                    if (netNames[i] != null) continue;
                    netNames[i] = nets[i].getNames().next();
                }
                this.setBusDirectionality(nets, netNames, cni);
            }
        }
        Iterator<Export> it2 = cell.getExports();
        while (it2.hasNext()) {
            Export pp = it2.next();
            int portWidth = cni.netList.getBusWidth(pp);
            for (int i = 0; i < portWidth; ++i) {
                int openPos;
                Network net = cni.netList.getNetwork(pp, i);
                CellSignal cs3 = (CellSignal)cni.cellSignals.get(net);
                if (cs3 == null) continue;
                if (cs3.pp != null) {
                    if (this.isChooseBestExportName()) {
                        int oldPortWidth = cni.netList.getBusWidth(cs3.pp);
                        if (this.isAggregateNamesSupported() ? oldPortWidth >= portWidth : oldPortWidth == 1 || portWidth != 1 && oldPortWidth >= portWidth) {
                            continue;
                        }
                    } else if (TextUtils.STRING_NUMBER_ORDER.compare(cs3.pp.getName(), pp.getName()) <= 0) continue;
                }
                cs3.pp = pp;
                cs3.ppIndex = i;
                if (!useExportedName) continue;
                String rootName = pp.getName();
                if (portWidth == 1) {
                    cs3.name = rootName;
                }
                if ((openPos = rootName.indexOf(91)) <= 0) continue;
                rootName = rootName.substring(0, openPos);
                nIt = net.getExportedNames();
                while (nIt.hasNext()) {
                    String exportNetName = nIt.next();
                    String exportRootName = exportNetName;
                    openPos = exportRootName.indexOf(91);
                    if (openPos <= 0 || !rootName.equals(exportRootName = exportRootName.substring(0, openPos))) continue;
                    cs3.name = rootName + exportNetName.substring(openPos);
                }
            }
            if (portWidth <= 1) continue;
            Network[] nets = new Network[portWidth];
            String[] netNames = new String[portWidth];
            for (int i = 0; i < portWidth; ++i) {
                nets[i] = cni.netList.getNetwork(pp, i);
                String preferredName = pp.getNameKey().subname(i).toString();
                netNames[i] = null;
                Iterator<String> nIt2 = nets[i].getNames();
                while (nIt2.hasNext()) {
                    String netName = nIt2.next();
                    if (!netName.equals(preferredName)) continue;
                    netNames[i] = netName;
                    break;
                }
                if (netNames[i] != null) continue;
                netNames[i] = nets[i].getNames().next();
            }
            this.setBusDirectionality(nets, netNames, cni);
        }
        cni.pwrNet = (cni.gndNet = null);
        boolean multiPwr = false;
        boolean multiGnd = false;
        Iterator<PortProto> eIt = cell.getPorts();
        while (eIt.hasNext()) {
            Export pp = (Export)eIt.next();
            int portWidth = cni.netList.getBusWidth(pp);
            if (portWidth > 1) continue;
            Network subNet = cni.netList.getNetwork(pp, 0);
            if (pp.isPower()) {
                if (cni.pwrNet != null && cni.pwrNet != subNet && !multiPwr) {
                    if (!quiet) {
                        System.out.println("Warning: multiple power networks in " + cell);
                    }
                    multiPwr = true;
                }
                cni.pwrNet = subNet;
            }
            if (!pp.isGround()) continue;
            if (cni.gndNet != null && cni.gndNet != subNet && !multiGnd) {
                if (!quiet) {
                    System.out.println("Warning: multiple ground networks in " + cell);
                }
                multiGnd = true;
            }
            cni.gndNet = subNet;
        }
        Iterator<Comparable> it3 = cni.netList.getNetworks();
        while (it3.hasNext()) {
            Network net = it3.next();
            CellSignal cs4 = (CellSignal)cni.cellSignals.get(net);
            if (cs4 == null || cs4.globalSignal == null) continue;
            if (cs4.globalSignal == Global.power) {
                if (cni.pwrNet != null && cni.pwrNet != net && !multiPwr) {
                    if (!quiet) {
                        System.out.println("Warning: multiple power networks in " + cell);
                    }
                    multiPwr = true;
                }
                cni.pwrNet = net;
            }
            if (cs4.globalSignal != Global.ground) continue;
            if (cni.gndNet != null && cni.gndNet != net && !multiGnd) {
                if (!quiet) {
                    System.out.println("Warning: multiple ground networks in " + cell);
                }
                multiGnd = true;
            }
            cni.gndNet = net;
        }
        it3 = cell.getNodes();
        while (it3.hasNext()) {
            NodeInst ni = (NodeInst)it3.next();
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun != PrimitiveNode.Function.CONPOWER && fun != PrimitiveNode.Function.CONGROUND) continue;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                ArcInst ai = con.getArc();
                Network subNet = cni.netList.getNetwork(ai, 0);
                if (fun == PrimitiveNode.Function.CONPOWER) {
                    if (cni.pwrNet != null && cni.pwrNet != subNet && !multiPwr) {
                        if (!quiet) {
                            System.out.println("Warning: multiple power networks in " + cell);
                        }
                        multiPwr = true;
                    }
                    cni.pwrNet = subNet;
                    continue;
                }
                if (cni.gndNet != null && cni.gndNet != subNet && !multiGnd) {
                    if (!quiet) {
                        System.out.println("Warning: multiple ground networks in " + cell);
                    }
                    multiGnd = true;
                }
                cni.gndNet = subNet;
            }
        }
        if (cni.pwrNet != null) {
            cs = (CellSignal)cni.cellSignals.get(cni.pwrNet);
            String powerName = this.getPowerName(cni.pwrNet);
            if (powerName != null) {
                cs.name = powerName;
            }
            cs.power = true;
        }
        if (cni.gndNet != null) {
            cs = (CellSignal)cni.cellSignals.get(cni.gndNet);
            String groundName = this.getGroundName(cni.gndNet);
            if (groundName != null) {
                cs.name = groundName;
            }
            cs.ground = true;
        }
        cni.cellSignalsSorted = new ArrayList();
        for (CellSignal cs5 : cni.cellSignals.values()) {
            cni.cellSignalsSorted.add(cs5);
        }
        Collections.sort(cni.cellSignalsSorted, new SortNetsByName(this.isSeparateInputAndOutput(), this.isAggregateNamesSupported()));
        if (this.isAggregateNamesSupported()) {
            cni.cellAggregateSignals = new ArrayList();
            int total = cni.cellSignalsSorted.size();
            for (int i = 0; i < total; ++i) {
                CellSignal cs6 = (CellSignal)cni.cellSignalsSorted.get(i);
                CellAggregateSignal cas = new CellAggregateSignal();
                cas.name = Topology.unIndexedName(cs6.name);
                cas.pp = cs6.pp;
                cas.ppIndex = cs6.ppIndex;
                cas.supply = cs6.power | cs6.ground;
                cas.descending = cs6.descending;
                cas.flags = 0;
                cs6.aggregateSignal = cas;
                if (cs6.name.equals(cas.name)) {
                    cas.low = 1;
                    cas.high = 0;
                    CellAggregateSignal.access$2802(cas, new CellSignal[1]);
                    ((CellAggregateSignal)cas).signals[0] = cs6;
                } else {
                    String endName;
                    String ept;
                    CellSignal csEnd;
                    boolean hasGaps = false;
                    cas.high = (cas.low = TextUtils.atoi(cs6.name.substring(cas.name.length() + 1)));
                    int start = i;
                    int j = i + 1;
                    while (j < total && (csEnd = (CellSignal)cni.cellSignalsSorted.get(j)).descending == cs6.descending && csEnd.globalSignal == cs6.globalSignal && !(ept = Topology.unIndexedName(endName = csEnd.name)).equals(endName) && ept.equals(cas.name)) {
                        int index = TextUtils.atoi(endName.substring(ept.length() + 1));
                        if (index != cas.high + 1) {
                            if (!this.isAggregateNameGapsSupported()) break;
                            hasGaps = true;
                        }
                        if (index > cas.high) {
                            cas.high = index;
                        }
                        i = j++;
                        csEnd.aggregateSignal = cas;
                    }
                    CellAggregateSignal.access$2802(cas, new CellSignal[i - start + 1]);
                    if (hasGaps) {
                        CellAggregateSignal.access$2902(cas, new int[i - start + 1]);
                    }
                    for (j = start; j <= i; ++j) {
                        csEnd = (CellSignal)cni.cellSignalsSorted.get(j);
                        if (hasGaps) {
                            endName = csEnd.name;
                            ept = Topology.unIndexedName(endName);
                            ((CellAggregateSignal)cas).indices[j - start] = TextUtils.atoi(endName.substring(ept.length() + 1));
                        }
                        ((CellAggregateSignal)cas).signals[j - start] = csEnd;
                    }
                }
                cni.cellAggregateSignals.add(cas);
            }
            for (CellAggregateSignal cas : cni.cellAggregateSignals) {
                cas.name = this.getSafeNetName(cas.name, true);
            }
            int numNameList = cni.cellAggregateSignals.size();
            block20: for (int i = 1; i < numNameList; ++i) {
                CellAggregateSignal cas = (CellAggregateSignal)cni.cellAggregateSignals.get(i);
                for (int k = 0; k < 1000; ++k) {
                    String ninName = cas.name;
                    if (k > 0) {
                        ninName = ninName + "_" + k;
                    }
                    boolean found = false;
                    for (int j = 0; j < i; ++j) {
                        CellAggregateSignal oCas = (CellAggregateSignal)cni.cellAggregateSignals.get(j);
                        if (!ninName.equals(oCas.name)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (k <= 0) continue block20;
                    cas.name = ninName;
                    continue block20;
                }
            }
            for (CellAggregateSignal cas : cni.cellAggregateSignals) {
                CellSignal cs7;
                if (cas.low > cas.high) {
                    CellSignal cs8 = cas.signals[0];
                    cs8.name = cas.name;
                    continue;
                }
                if (cas.indices != null) {
                    for (int k = 0; k < cas.indices.length; ++k) {
                        cs7 = cas.signals[k];
                        cs7.name = this.getSafeNetName(cas.name + "[" + cas.indices[k] + "]", false);
                    }
                    continue;
                }
                for (int k = cas.low; k <= cas.high; ++k) {
                    cs7 = cas.signals[k - cas.low];
                    cs7.name = this.getSafeNetName(cas.name + "[" + k + "]", false);
                }
            }
            Collections.sort(cni.cellAggregateSignals, new SortAggregateNetsByName(this.isSeparateInputAndOutput()));
        } else {
            for (CellSignal cs9 : cni.cellSignalsSorted) {
                cs9.name = this.getSafeNetName(cs9.name, false);
            }
        }
        return cni;
    }

    private void setBusDirectionality(Network[] nets, String[] netNames, CellNetInfo cni) {
        Network subNet;
        int i;
        boolean upDir = false;
        boolean downDir = false;
        int last2 = 0;
        int width = nets.length;
        for (i = 0; i < width; ++i) {
            subNet = nets[i];
            if (subNet == null) continue;
            String netName = netNames[i];
            int index = -1;
            int charPos = 0;
            while ((charPos = netName.indexOf(91, charPos)) >= 0) {
                if (!TextUtils.isDigit(netName.charAt(++charPos))) continue;
                index = TextUtils.atoi(netName.substring(charPos));
                break;
            }
            if (index < 0) break;
            if (i != 0) {
                if (index < last2) {
                    downDir = true;
                } else if (index > last2) {
                    upDir = true;
                }
            }
            last2 = index;
        }
        if (upDir && downDir) {
            return;
        }
        if (!upDir && !downDir) {
            return;
        }
        for (i = 0; i < width; ++i) {
            subNet = nets[i];
            CellSignal cs = (CellSignal)cni.cellSignals.get(subNet);
            cs.descending = downDir;
        }
    }

    protected static String unIndexedName(String name) {
        char theChr;
        int i;
        int len = name.length();
        if (len == 0) {
            return name;
        }
        if (name.charAt(len - 1) != ']') {
            return name;
        }
        for (i = len - 2; i > 0 && (theChr = name.charAt(i)) != '[' && (theChr == ':' || theChr == ',' || TextUtils.isDigit(theChr)); --i) {
        }
        if (name.charAt(i) != '[') {
            return name;
        }
        return name.substring(0, i);
    }

    protected String parameterizedName(Nodable no, VarContext context) {
        int limit;
        Cell cell = (Cell)no.getProto();
        String uniqueCellName = this.getUniqueCellName(cell);
        if (this.canParameterizeNames() && no.isCellInstance()) {
            HashMap<Variable.Key, Variable> paramValues = new HashMap<Variable.Key, Variable>();
            Iterator<Variable> it = no.getDefinedParameters();
            while (it.hasNext()) {
                Variable var = it.next();
                paramValues.put(var.getKey(), var);
            }
            for (Variable.Key key : paramValues.keySet()) {
                Variable var = no.getParameter(key);
                String eval = var.describe(context, no.getNodeInst());
                if (eval == null) continue;
                uniqueCellName = uniqueCellName + "-" + eval.toString();
            }
        }
        if ((limit = this.maxNameLength()) > 0 && uniqueCellName.length() > limit) {
            int ckSum = 0;
            for (int i = 0; i < uniqueCellName.length(); ++i) {
                ckSum += uniqueCellName.charAt(i);
            }
            uniqueCellName = uniqueCellName.substring(0, limit - 10) + "-TRUNC" + (ckSum %= 9999);
        }
        return this.getSafeCellName(uniqueCellName);
    }

    protected String getIconCellName(Cell cell) {
        String name = this.cellNameMap.get(cell);
        return name;
    }

    protected String getUniqueCellName(Cell cell) {
        String name;
        Cell contents = cell.contentsView();
        if (contents != null) {
            cell = contents;
        }
        if ((name = this.cellNameMap.get(cell)) == null) {
            name = this.getDefaultName(cell);
        }
        return name;
    }

    private String getDefaultName(Cell cell) {
        if (this.isLibraryNameAlwaysAddedToCellName() && !SCLibraryGen.isStandardCell(cell)) {
            return cell.getLibrary().getName() + "__" + cell.getName();
        }
        return cell.getName();
    }

    private Map<Cell, String> makeCellNameMap(Cell cell) {
        NameMapGenerator gen = new NameMapGenerator(this);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)gen);
        return gen.cellNameMap;
    }

    private class NameMapGenerator
    extends HierarchyEnumerator.Visitor {
        private Map<Cell, String> cellNameMap = new HashMap<Cell, String>();
        private Map<String, List<Cell>> cellNameMapReverse = new HashMap<String, List<Cell>>();
        private Topology topology;
        private Cell topCell;

        public NameMapGenerator(Topology topology2) {
            this.topology = topology2;
            this.topCell = null;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (this.topCell == null) {
                this.topCell = cell;
            }
            if (this.cellNameMap.containsKey(cell)) {
                return false;
            }
            String name = Topology.this.getDefaultName(cell);
            this.cellNameMap.put(cell, name);
            this.getConflictList(name).add(cell);
            if (cell != this.topCell && this.topology.isWriteCopyForEachIcon() && cell.isSchematic()) {
                for (Cell otherCell : cell.getCellsInGroup()) {
                    if (otherCell.getView() != View.ICON || otherCell.getName().equals(cell.getName())) continue;
                    String otherCellName = Topology.this.getDefaultName(otherCell);
                    if (this.cellNameMap.containsKey(otherCell)) continue;
                    this.cellNameMap.put(otherCell, otherCellName);
                    this.getConflictList(otherCellName).add(otherCell);
                }
            }
            return true;
        }

        private List<Cell> getConflictList(String cellname) {
            String properCellName = this.topology.isCaseSensitive() ? cellname : cellname.toLowerCase();
            List<Cell> conflictList = this.cellNameMapReverse.get(properCellName);
            if (conflictList == null) {
                conflictList = new ArrayList<Cell>();
                this.cellNameMapReverse.put(properCellName, conflictList);
            }
            return conflictList;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (cell == this.topCell) {
                this.resolveConflicts();
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            if (!no.isCellInstance()) {
                return false;
            }
            VarContext context = info.getContext();
            Cell cell = (Cell)no.getProto();
            Cell schcell = cell.contentsView();
            if (schcell == null) {
                schcell = cell;
            }
            if (cell.isSchematic() && this.topology.enumerateLayoutView(schcell)) {
                Cell layCell = cell.otherView(View.LAYOUT);
                if (layCell != null) {
                    String name = Topology.this.getDefaultName(schcell);
                    this.cellNameMap.put(schcell, name);
                    this.getConflictList(name).add(schcell);
                    HierarchyEnumerator.enumerateCell(layCell, context, (HierarchyEnumerator.Visitor)this);
                    return false;
                }
            } else {
                schcell = cell.contentsView();
                if (cell.isIcon() && schcell == null && !this.cellNameMap.containsKey(cell)) {
                    String name = Topology.this.getDefaultName(cell);
                    this.cellNameMap.put(cell, name);
                    this.getConflictList(name).add(cell);
                    return false;
                }
            }
            return true;
        }

        private void resolveConflicts() {
            ArrayList<List<Cell>> conflictLists = new ArrayList<List<Cell>>();
            for (List<Cell> conflictList : this.cellNameMapReverse.values()) {
                if (conflictList.size() <= 1) continue;
                conflictLists.add(conflictList);
            }
            for (List<Cell> conflictList : conflictLists) {
                String cellName;
                Cell cell;
                int i;
                if (!this.topology.isCaseSensitive()) {
                    for (i = 0; i < conflictList.size() - 1; ++i) {
                        Cell cellI = conflictList.get(i);
                        String cellIName = this.cellNameMap.get(cellI);
                        block3: for (int j = i + 1; j < conflictList.size(); ++j) {
                            String cellJName;
                            Cell cellJ = conflictList.get(j);
                            if (cellI.getLibrary() != cellJ.getLibrary() || !cellIName.equalsIgnoreCase(cellJName = this.cellNameMap.get(cellJ)) || cellIName.equals(cellJName)) continue;
                            for (int append2 = 1; append2 < 1000; ++append2) {
                                String newTestName = cellJName.toLowerCase() + "_" + append2;
                                if (this.cellNameMapReverse.get(newTestName) != null) continue;
                                this.cellNameMap.put(cellJ, newTestName);
                                this.getConflictList(newTestName).add(cellJ);
                                conflictList.remove(j);
                                --j;
                                continue block3;
                            }
                        }
                    }
                    if (conflictList.size() <= 1) continue;
                }
                if (!Topology.this.isLibraryNameAlwaysAddedToCellName()) {
                    for (i = 0; i < conflictList.size(); ++i) {
                        cell = conflictList.get(i);
                        cellName = this.cellNameMap.get(cell);
                        String newTestName = cell.getLibrary().getName() + "__" + cellName;
                        if (this.cellNameMapReverse.get(newTestName) != null) continue;
                        this.cellNameMap.put(cell, newTestName);
                        this.getConflictList(newTestName).add(cell);
                        conflictList.remove(i);
                        --i;
                    }
                    if (conflictList.size() <= 1) continue;
                }
                for (i = 0; i < conflictList.size(); ++i) {
                    cell = conflictList.get(i);
                    cellName = this.cellNameMap.get(cell);
                    String newTestName = cell.getLibrary().getName() + "__" + cellName + "__" + cell.getView().getAbbreviation();
                    if (this.cellNameMapReverse.get(newTestName) != null) continue;
                    this.cellNameMap.put(cell, newTestName);
                    this.getConflictList(newTestName).add(cell);
                    conflictList.remove(i);
                    --i;
                }
                if (conflictList.size() <= 1) continue;
                Cell cell2 = conflictList.get(0);
                System.out.print("Error: Unable to make unique cell name for " + cell2.describe(false) + ", it conflicts with:");
                for (int i2 = 1; i2 < conflictList.size(); ++i2) {
                    System.out.print(" " + conflictList.get(i2).describe(false));
                }
                System.out.println();
            }
        }
    }

    private static class SortAggregateNetsByName
    implements Comparator<CellAggregateSignal> {
        private boolean separateInputAndOutput;

        SortAggregateNetsByName(boolean separateInputAndOutput) {
            this.separateInputAndOutput = separateInputAndOutput;
        }

        @Override
        public int compare(CellAggregateSignal cs1, CellAggregateSignal cs2) {
            PortCharacteristic ch2;
            PortCharacteristic ch1;
            if (this.separateInputAndOutput && cs1.pp == null != (cs2.pp == null)) {
                return cs1.pp == null ? 1 : -1;
            }
            if (cs1.pp != null && cs2.pp != null && this.separateInputAndOutput && (ch1 = cs1.pp.getCharacteristic()) != (ch2 = cs2.pp.getCharacteristic())) {
                return ch1.getOrder() - ch2.getOrder();
            }
            return cs1.name.compareTo(cs2.name);
        }
    }

    private static class SortNetsByName
    implements Comparator<CellSignal> {
        private boolean separateInputAndOutput;
        private boolean aggregateNamesSupported;

        SortNetsByName(boolean separateInputAndOutput, boolean aggregateNamesSupported) {
            this.separateInputAndOutput = separateInputAndOutput;
            this.aggregateNamesSupported = aggregateNamesSupported;
        }

        @Override
        public int compare(CellSignal cs1, CellSignal cs2) {
            PortCharacteristic ch2;
            PortCharacteristic ch1;
            if ((this.aggregateNamesSupported || this.separateInputAndOutput) && cs1.pp == null != (cs2.pp == null)) {
                return cs1.pp == null ? 1 : -1;
            }
            if (cs1.pp != null && cs2.pp != null && this.separateInputAndOutput && (ch1 = cs1.pp.getCharacteristic()) != (ch2 = cs2.pp.getCharacteristic())) {
                return ch1.getOrder() - ch2.getOrder();
            }
            if (this.aggregateNamesSupported && cs1.descending != cs2.descending) {
                return cs1.descending ? 1 : -1;
            }
            if (this.aggregateNamesSupported) {
                return TextUtils.STRING_NUMBER_ORDER.compare(cs1.name, cs2.name);
            }
            return cs1.name.compareTo(cs2.name);
        }
    }

    protected static class CellNetInfo {
        private Cell cell;
        private String paramName;
        private Map<Network, CellSignal> cellSignals;
        private List<CellSignal> cellSignalsSorted;
        private List<CellAggregateSignal> cellAggregateSignals;
        private Network pwrNet;
        private Network gndNet;
        private Netlist netList;

        protected CellNetInfo() {
        }

        protected CellSignal getCellSignal(Network net) {
            return this.cellSignals.get(net);
        }

        protected Iterator<CellSignal> getCellSignals() {
            return this.cellSignalsSorted.iterator();
        }

        protected Iterator<CellAggregateSignal> getCellAggregateSignals() {
            return this.cellAggregateSignals.iterator();
        }

        protected String getParameterizedName() {
            return this.paramName;
        }

        protected Network getPowerNet() {
            return this.pwrNet;
        }

        protected Network getGroundNet() {
            return this.gndNet;
        }

        protected Netlist getNetList() {
            return this.netList;
        }

        protected Cell getCell() {
            return this.cell;
        }
    }

    protected static class CellAggregateSignal {
        private String name;
        private Export pp;
        private int ppIndex;
        private int low;
        private int high;
        private int[] indices;
        private boolean supply;
        private boolean descending;
        private CellSignal[] signals;
        private int flags;

        protected CellAggregateSignal() {
        }

        protected String getName() {
            return this.name;
        }

        protected String getNameWithIndices() {
            if (this.low > this.high) {
                return this.name;
            }
            if (this.indices != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.name);
                sb.append('[');
                for (int i = 0; i < this.indices.length; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(this.indices[i]);
                }
                sb.append(']');
                return sb.toString();
            }
            int lowIndex = this.low;
            int highIndex = this.high;
            if (this.descending) {
                lowIndex = this.high;
                highIndex = this.low;
            }
            return this.name + "[" + lowIndex + ":" + highIndex + "]";
        }

        protected int getNumSignals() {
            return this.signals.length;
        }

        protected CellSignal getSignal(int index) {
            return this.signals[index];
        }

        protected boolean isDescending() {
            return this.descending;
        }

        protected boolean isSupply() {
            return this.supply;
        }

        protected Export getExport() {
            return this.pp;
        }

        protected int getExportIndex() {
            return this.ppIndex;
        }

        protected int[] getIndices() {
            return this.indices;
        }

        protected int getLowIndex() {
            return this.low;
        }

        protected int getHighIndex() {
            return this.high;
        }

        protected int getFlags() {
            return this.flags;
        }

        protected void setFlags(int flags) {
            this.flags = flags;
        }

        protected boolean isGlobal() {
            int numGlobal = 0;
            for (int i = 0; i < this.signals.length; ++i) {
                CellSignal cs = this.signals[i];
                if (!cs.isGlobal()) continue;
                ++numGlobal;
            }
            return numGlobal > 0 && numGlobal == this.signals.length;
        }

        static /* synthetic */ CellSignal[] access$2802(CellAggregateSignal x0, CellSignal[] x1) {
            x0.signals = x1;
            return x1;
        }

        static /* synthetic */ int[] access$2902(CellAggregateSignal x0, int[] x1) {
            x0.indices = x1;
            return x1;
        }
    }

    protected static class CellSignal {
        private String name;
        private Network net;
        private CellAggregateSignal aggregateSignal;
        private Export pp;
        private int ppIndex;
        private boolean descending;
        private boolean power;
        private boolean ground;
        private Global globalSignal;

        protected CellSignal() {
        }

        protected String getName() {
            return this.name;
        }

        protected Network getNetwork() {
            return this.net;
        }

        protected Export getExport() {
            return this.pp;
        }

        protected int getExportIndex() {
            return this.ppIndex;
        }

        protected CellAggregateSignal getAggregateSignal() {
            return this.aggregateSignal;
        }

        protected boolean isDescending() {
            return this.descending;
        }

        protected boolean isGlobal() {
            return this.globalSignal != null;
        }

        protected Global getGlobal() {
            return this.globalSignal;
        }

        protected boolean isPower() {
            return this.power;
        }

        protected boolean isGround() {
            return this.ground;
        }

        protected boolean isExported() {
            return this.pp != null;
        }
    }

    public class Visitor
    extends HierarchyEnumerator.Visitor {
        private Topology outGeom;

        public Visitor(Topology outGeom) {
            this.outGeom = outGeom;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (Topology.this.skipCellAndSubcells(info.getCell())) {
                if (!info.isRootCell()) {
                    HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
                    Nodable no = info.getParentInst();
                    String parameterizedName = Topology.this.parameterizedName(no, parentInfo.getContext());
                    CellNetInfo cni = Topology.this.getNetworkInformation(info.getCell(), false, parameterizedName, Topology.this.isNetworksUseExportedNames(), info);
                    Topology.this.cellTopos.put(parameterizedName, cni);
                }
                Topology.this.validateSkippedCell(info);
                return false;
            }
            this.outGeom.enterCell(info);
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            CellNetInfo cni = null;
            if (info.isRootCell()) {
                cni = Topology.this.getNetworkInformation(cell, false, Topology.this.getSafeCellName(cell.getName()), Topology.this.isNetworksUseExportedNames(), info);
                Topology.this.cellTopos.put(cell.getName(), cni);
            } else {
                HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
                Nodable no = info.getParentInst();
                String parameterizedName = Topology.this.parameterizedName(no, parentInfo.getContext());
                cni = Topology.this.getNetworkInformation(info.getCell(), false, parameterizedName, Topology.this.isNetworksUseExportedNames(), info);
                Topology.this.cellTopos.put(parameterizedName, cni);
            }
            String cellName = cni.getParameterizedName();
            this.outGeom.writeCellTopology(cell, cellName, cni, info.getContext(), (MyCellInfo)info);
            if (Topology.this.isWriteCopyForEachIcon() && cell != Topology.this.topCell) {
                for (Cell otherCell : cell.getCellsInGroup()) {
                    if (otherCell.getView() != View.ICON || otherCell.getName().equals(cell.getName())) continue;
                    String otherCellName = Topology.this.getSafeCellName(otherCell.getName());
                    if (Topology.this.isLibraryNameAlwaysAddedToCellName()) {
                        otherCellName = otherCellName.startsWith("_") ? "_" + otherCellName : "__" + otherCellName;
                        otherCellName = otherCell.getLibrary().getName() + otherCellName;
                    }
                    if (otherCellName.equals(cellName)) continue;
                    this.outGeom.writeCellTopology(cell, otherCellName, cni, info.getContext(), (MyCellInfo)info);
                }
            }
            Topology.this.lastInfo = info;
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            Cell layCell;
            if (!no.isCellInstance()) {
                return false;
            }
            VarContext context = info.getContext();
            String parameterizedName = Topology.this.parameterizedName(no, context);
            if (Topology.this.cellTopos.containsKey(parameterizedName)) {
                return false;
            }
            Cell cell = (Cell)no.getProto();
            Cell schcell = cell.contentsView();
            if (schcell == null) {
                schcell = cell;
            }
            if (cell.isSchematic() && Topology.this.enumerateLayoutView(schcell) && (layCell = cell.otherView(View.LAYOUT)) != null) {
                HierarchyEnumerator.enumerateCell(layCell, context, (HierarchyEnumerator.Visitor)this);
                CellNetInfo cni = Topology.this.getNetworkInformation(layCell, false, layCell.getName(), Topology.this.isNetworksUseExportedNames(), Topology.this.lastInfo);
                Topology.this.cellTopos.put(parameterizedName, cni);
                return false;
            }
            return true;
        }

        @Override
        public HierarchyEnumerator.CellInfo newCellInfo() {
            return new MyCellInfo();
        }

        @Override
        public boolean visitIcons() {
            return this.outGeom.visitIcons();
        }
    }

    public class MyCellInfo
    extends HierarchyEnumerator.CellInfo {
        String currentInstanceParametizedName;
    }
}

