/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore;

import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore1.yana;
import java.awt.geom.Point2D;

public class Tupel {
    static int distanceBetweenWires = yana.distanceBetweenWires == 0 ? 3 : yana.distanceBetweenWires;
    static int offsetX;
    static int offsetY;
    private int xInsideElectric;
    private int yInsideElectric;
    private int layer;
    private int xInsideRoutingArray;
    private int yInsideRoutingArray;

    public static void setOffset(double x, double y, int spacing, boolean output) {
        offsetX = (int)(x - (double)spacing);
        offsetY = (int)(y - (double)spacing);
        if (output) {
            System.out.println("Using offset " + offsetX + "," + offsetY);
        }
    }

    public Tupel(int x, int y, int layer, boolean is_electric_coordinate) {
        if (is_electric_coordinate) {
            this.xInsideElectric = x;
            this.yInsideElectric = y;
            this.xInsideRoutingArray = (x - offsetX) / distanceBetweenWires;
            this.yInsideRoutingArray = (y - offsetY) / distanceBetweenWires;
        } else {
            this.xInsideElectric = x * distanceBetweenWires + distanceBetweenWires / 2 + offsetX;
            this.yInsideElectric = y * distanceBetweenWires + distanceBetweenWires / 2 + offsetY;
            this.xInsideRoutingArray = x;
            this.yInsideRoutingArray = y;
        }
        this.layer = layer;
    }

    public Tupel(Point2D p, int layer) {
        this.xInsideElectric = (int)p.getX();
        this.yInsideElectric = (int)p.getY();
        this.xInsideRoutingArray = (this.xInsideElectric - offsetX) / distanceBetweenWires;
        this.yInsideRoutingArray = (this.yInsideElectric - offsetY) / distanceBetweenWires;
        this.layer = layer;
    }

    public int getX_InsideElectric() {
        return this.xInsideElectric;
    }

    public int getX_InsideRoutingArray() {
        return this.xInsideRoutingArray;
    }

    public int getY_InsideElectric() {
        return this.yInsideElectric;
    }

    public int getY_InsideRoutingArray() {
        return this.yInsideRoutingArray;
    }

    public int getLayer() {
        return this.layer;
    }

    public void printTupel() {
        System.out.print(this.toString());
    }

    public String toString() {
        return "[" + this.xInsideElectric + "," + this.yInsideElectric + "@Metal-" + (this.layer + 1) + "(" + this.xInsideRoutingArray + "," + this.yInsideRoutingArray + "," + this.layer + ")]";
    }

    public boolean isEqual(Tupel t) {
        return this.isEqualInElectric(t) || this.isEqualInRoutingArray(t);
    }

    private boolean isEqualInElectric(Tupel t) {
        return this.xInsideElectric == t.getX_InsideElectric() && this.yInsideElectric == t.getY_InsideElectric() && this.layer == t.getLayer();
    }

    private boolean isEqualInRoutingArray(Tupel t) {
        return this.xInsideRoutingArray == t.getX_InsideRoutingArray() && this.yInsideRoutingArray == t.getY_InsideRoutingArray() && this.layer == t.getLayer();
    }

    public boolean isEqualPositionInElectric(Tupel t) {
        return this.xInsideElectric == t.getX_InsideElectric() && this.yInsideElectric == t.getY_InsideElectric();
    }

    public boolean isEqualPosition(RoutingFrame.RoutePoint rp1) {
        return this.xInsideRoutingArray == Tupel.convertElectricToRoutingArrayCoordinate_X(rp1.getLocation().getX()) && this.yInsideRoutingArray == Tupel.convertElectricToRoutingArrayCoordinate_Y(rp1.getLocation().getX());
    }

    public boolean isEqualPosition(Tupel t) {
        return this.xInsideRoutingArray == t.xInsideRoutingArray && this.yInsideRoutingArray == t.yInsideRoutingArray;
    }

    public static int convertElectricToRoutingArrayCoordinate_X(double x) {
        return (int)(x - (double)offsetX) / distanceBetweenWires;
    }

    public static int convertElectricToRoutingArrayCoordinate_Y(double y) {
        return (int)(y - (double)offsetY) / distanceBetweenWires;
    }

    public static int convertRoutingArrayToElectricCoordinates_X(int x) {
        return x * distanceBetweenWires + distanceBetweenWires / 2 + offsetX;
    }

    public static int convertRoutingArrayToElectricCoordinates_Y(int y) {
        return y * distanceBetweenWires + distanceBetweenWires / 2 + offsetY;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.xInsideElectric, this.yInsideElectric);
    }
}

