/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.ui;

import com.sun.electric.plugins.j3d.View3DWindow;
import com.sun.electric.plugins.j3d.utils.J3DClientApp;
import com.sun.electric.plugins.j3d.utils.J3DUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.TransformGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class J3DViewDialog
extends EDialog {
    private View3DWindow view3D = null;
    private J3DClientApp socketJob = null;
    private List<J3DUtils.ThreeDDemoKnot> knots = new ArrayList<J3DUtils.ThreeDDemoKnot>();
    private Map<TransformGroup, BranchGroup> interMap;
    private JCheckBox auto;
    private JLabel capacitanceLabel;
    private JButton close;
    private JButton connect;
    private JButton demo;
    private JButton enter;
    private JPanel otherPanel;
    private JPanel positionPanel;
    private JLabel radiusLabel;
    private JButton read;
    private JPanel rotationPanel;
    private JSeparator separator;
    private JSeparator separator1;
    private JSlider slider;
    private JCheckBox xBox;
    private JTextField xField;
    private JLabel xLabel;
    private JLabel xLabelUnit;
    private JCheckBox xRotBox;
    private JTextField xRotField;
    private JLabel xRotLabel;
    private JLabel xRotLabelUnit;
    private JTextField xRotPosField;
    private JLabel xRotPosLabel;
    private JLabel xRotPosLabelUnit;
    private JCheckBox yBox;
    private JTextField yField;
    private JLabel yLabel;
    private JLabel yLabelUnit;
    private JCheckBox yRotBox;
    private JTextField yRotField;
    private JLabel yRotLabel;
    private JLabel yRotLabelUnit;
    private JTextField yRotPosField;
    private JLabel yRotPosLabel;
    private JLabel yRotPosLabelUnit;
    private JCheckBox zBox;
    private JTextField zField;
    private JLabel zLabel;
    private JLabel zLabelUnit;
    private JCheckBox zRotBox;
    private JTextField zRotField;
    private JLabel zRotLabel;
    private JLabel zRotLabelUnit;
    private JTextField zRotPosField;
    private JLabel zRotPosLabel;
    private JLabel zRotPosLabelUnit;

    public static void create3DViewDialog(Frame parent) {
        View3DWindow view3D = null;
        WindowContent content = WindowFrame.getCurrentWindowFrame().getContent();
        if (!(content instanceof View3DWindow)) {
            System.out.println("Current Window Frame is not a 3D View");
            return;
        }
        view3D = (View3DWindow)content;
        J3DViewDialog dialog = new J3DViewDialog(parent, view3D, false);
        dialog.setVisible(true);
    }

    public J3DViewDialog(Frame parent, View3DWindow view3d, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.view3D = view3d;
        this.getRootPane().setDefaultButton(this.connect);
        if (J3DUtils.jAlpha != null) {
            this.slider.addChangeListener(J3DUtils.jAlpha);
            this.auto.setSelected(J3DUtils.jAlpha.getAutoMode());
        }
        this.setOtherValues("?", "?");
        this.finishInitialization();
    }

    public void socketAction(String inData) {
        String[] stringValues = J3DUtils.parseValues(inData, 0);
        this.xField.setText(stringValues[0]);
        this.yField.setText(stringValues[1]);
        this.zField.setText(stringValues[2]);
        this.xRotField.setText(stringValues[3]);
        this.yRotField.setText(stringValues[4]);
        this.zRotField.setText(stringValues[5]);
        this.xRotPosField.setText(stringValues[6]);
        this.yRotPosField.setText(stringValues[7]);
        this.zRotPosField.setText(stringValues[8]);
        this.setOtherValues(stringValues[9], stringValues[10]);
        double[] values = J3DUtils.convertValues(stringValues);
        this.knots.add(this.view3D.moveAndRotate(values));
    }

    private void setOtherValues(String capacitance, String radius) {
        this.capacitanceLabel.setText("Capacitance: " + capacitance + " [fF]");
        this.radiusLabel.setText("Radius: " + radius + " [mm]");
    }

    @Override
    protected void escapePressed() {
        this.closeActionPerformed(null);
    }

    private void initComponents() {
        this.rotationPanel = new JPanel();
        this.zRotPosLabelUnit = new JLabel();
        this.yRotLabelUnit = new JLabel();
        this.yRotPosLabelUnit = new JLabel();
        this.xRotPosLabelUnit = new JLabel();
        this.zRotLabelUnit = new JLabel();
        this.xRotLabelUnit = new JLabel();
        this.zRotPosField = new JTextField();
        this.zRotPosLabel = new JLabel();
        this.yRotPosField = new JTextField();
        this.yRotPosLabel = new JLabel();
        this.xRotPosField = new JTextField();
        this.xRotPosLabel = new JLabel();
        this.zRotField = new JTextField();
        this.zRotLabel = new JLabel();
        this.yRotField = new JTextField();
        this.yRotLabel = new JLabel();
        this.xRotField = new JTextField();
        this.xRotLabel = new JLabel();
        this.xRotBox = new JCheckBox();
        this.yRotBox = new JCheckBox();
        this.zRotBox = new JCheckBox();
        this.positionPanel = new JPanel();
        this.zLabelUnit = new JLabel();
        this.yLabelUnit = new JLabel();
        this.xLabelUnit = new JLabel();
        this.zField = new JTextField();
        this.zLabel = new JLabel();
        this.yField = new JTextField();
        this.yLabel = new JLabel();
        this.xField = new JTextField();
        this.xLabel = new JLabel();
        this.xBox = new JCheckBox();
        this.yBox = new JCheckBox();
        this.zBox = new JCheckBox();
        this.otherPanel = new JPanel();
        this.capacitanceLabel = new JLabel();
        this.radiusLabel = new JLabel();
        this.separator = new JSeparator();
        this.slider = new JSlider();
        this.auto = new JCheckBox();
        this.demo = new JButton();
        this.separator1 = new JSeparator();
        this.close = new JButton();
        this.connect = new JButton();
        this.enter = new JButton();
        this.read = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("3D Capacitance Demo Control Dialog");
        this.setBackground(Color.white);
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                J3DViewDialog.this.closeDialog(evt);
            }
        });
        this.rotationPanel.setLayout(new GridBagLayout());
        this.rotationPanel.setBorder(new TitledBorder("Rotation Values"));
        this.zRotPosLabelUnit.setText("[um]");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.zRotPosLabelUnit, gridBagConstraints);
        this.yRotLabelUnit.setText("[degrees]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.yRotLabelUnit, gridBagConstraints);
        this.yRotPosLabelUnit.setText("[um]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.yRotPosLabelUnit, gridBagConstraints);
        this.xRotPosLabelUnit.setText("[um]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.xRotPosLabelUnit, gridBagConstraints);
        this.zRotLabelUnit.setText("[degrees]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.zRotLabelUnit, gridBagConstraints);
        this.xRotLabelUnit.setText("[degrees]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.xRotLabelUnit, gridBagConstraints);
        this.zRotPosField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.rotationPanel.add((Component)this.zRotPosField, gridBagConstraints);
        this.zRotPosLabel.setText("Z:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.zRotPosLabel, gridBagConstraints);
        this.yRotPosField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.rotationPanel.add((Component)this.yRotPosField, gridBagConstraints);
        this.yRotPosLabel.setText("Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.yRotPosLabel, gridBagConstraints);
        this.xRotPosField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.rotationPanel.add((Component)this.xRotPosField, gridBagConstraints);
        this.xRotPosLabel.setText("X:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.xRotPosLabel, gridBagConstraints);
        this.zRotField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.rotationPanel.add((Component)this.zRotField, gridBagConstraints);
        this.zRotLabel.setText("Angle Z:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.zRotLabel, gridBagConstraints);
        this.yRotField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.rotationPanel.add((Component)this.yRotField, gridBagConstraints);
        this.yRotLabel.setText("Angle Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.yRotLabel, gridBagConstraints);
        this.xRotField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.rotationPanel.add((Component)this.xRotField, gridBagConstraints);
        this.xRotLabel.setText("Angle X:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rotationPanel.add((Component)this.xRotLabel, gridBagConstraints);
        this.xRotBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.rotationPanel.add((Component)this.xRotBox, gridBagConstraints);
        this.yRotBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.rotationPanel.add((Component)this.yRotBox, gridBagConstraints);
        this.zRotBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.rotationPanel.add((Component)this.zRotBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.rotationPanel, gridBagConstraints);
        this.positionPanel.setLayout(new GridBagLayout());
        this.positionPanel.setBorder(new TitledBorder("Position Values"));
        this.zLabelUnit.setText("[um]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.positionPanel.add((Component)this.zLabelUnit, gridBagConstraints);
        this.yLabelUnit.setText("[um]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.positionPanel.add((Component)this.yLabelUnit, gridBagConstraints);
        this.xLabelUnit.setText("[um]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.positionPanel.add((Component)this.xLabelUnit, gridBagConstraints);
        this.zField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.positionPanel.add((Component)this.zField, gridBagConstraints);
        this.zLabel.setText("Z:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.positionPanel.add((Component)this.zLabel, gridBagConstraints);
        this.yField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.positionPanel.add((Component)this.yField, gridBagConstraints);
        this.yLabel.setText("Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.positionPanel.add((Component)this.yLabel, gridBagConstraints);
        this.xField.setMinimumSize(new Dimension(20, 21));
        this.xField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.positionPanel.add((Component)this.xField, gridBagConstraints);
        this.xLabel.setText("X:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.positionPanel.add((Component)this.xLabel, gridBagConstraints);
        this.xBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.positionPanel.add((Component)this.xBox, gridBagConstraints);
        this.yBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.positionPanel.add((Component)this.yBox, gridBagConstraints);
        this.zBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.positionPanel.add((Component)this.zBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.positionPanel, gridBagConstraints);
        this.otherPanel.setLayout(new GridBagLayout());
        this.otherPanel.setBorder(new TitledBorder(""));
        this.capacitanceLabel.setText("Capacitance: ? [fF]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.otherPanel.add((Component)this.capacitanceLabel, gridBagConstraints);
        this.radiusLabel.setText("Radius: ? [mm]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.otherPanel.add((Component)this.radiusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.otherPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.separator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.slider, gridBagConstraints);
        this.auto.setText("Auto");
        this.auto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DViewDialog.this.autoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.auto, gridBagConstraints);
        this.demo.setText("Start Demo");
        this.demo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DViewDialog.this.demoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.demo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.separator1, gridBagConstraints);
        this.close.setText("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DViewDialog.this.closeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.close, gridBagConstraints);
        this.connect.setText("Connect");
        this.connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DViewDialog.this.connectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.connect, gridBagConstraints);
        this.enter.setText("Enter");
        this.enter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DViewDialog.this.enterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.enter, gridBagConstraints);
        this.read.setText("Read from File");
        this.read.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DViewDialog.this.readActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.read, gridBagConstraints);
        this.pack();
    }

    private void readActionPerformed(ActionEvent evt) {
        this.interMap = this.view3D.addInterpolator(null);
        if (this.interMap != null) {
            this.demo.setText("Stop Demo");
        }
    }

    private void autoActionPerformed(ActionEvent evt) {
        J3DUtils.jAlpha.setAutoMode(this.auto.isSelected());
    }

    private void enterActionPerformed(ActionEvent evt) {
        double[] values = new double[]{TextUtils.atof(this.xField.getText()), TextUtils.atof(this.yField.getText()), TextUtils.atof(this.zField.getText()), J3DUtils.convertToRadiant(TextUtils.atof(this.xRotField.getText())), J3DUtils.convertToRadiant(TextUtils.atof(this.yRotField.getText())), J3DUtils.convertToRadiant(TextUtils.atof(this.zRotField.getText())), TextUtils.atof(this.xRotPosField.getText()), TextUtils.atof(this.yRotPosField.getText()), TextUtils.atof(this.zRotPosField.getText())};
        this.knots.add(this.view3D.moveAndRotate(values));
    }

    private void demoActionPerformed(ActionEvent evt) {
        if (this.demo.getText().equals("Start Demo")) {
            this.interMap = this.view3D.addInterpolator(this.knots);
            if (this.interMap != null) {
                this.demo.setText("Stop Demo");
            }
        } else {
            this.demo.setText("Start Demo");
            this.view3D.removeInterpolator(this.interMap);
        }
    }

    private void connectActionPerformed(ActionEvent evt) {
        if (this.connect.getText().equals("Connect")) {
            String value = Job.getUserInterface().askForInput("Enter hostname for socket connection", "Hostname Dialog", "localhost");
            if (value == null) {
                return;
            }
            this.connect.setText("Disconnect");
            this.socketJob = new J3DClientApp(this, value.toString());
            this.socketJob.startJob();
            this.enter.setEnabled(false);
        } else {
            this.connect.setText("Connect");
            this.enter.setEnabled(true);
            if (this.socketJob != null) {
                this.socketJob.killJob();
            }
        }
    }

    private void closeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        if (this.socketJob != null) {
            this.socketJob.abort();
            this.socketJob.checkAbort();
            this.socketJob.remove();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public String getToggleInfo() {
        int xBoxValue = this.xBox.isSelected() ? 1 : 0;
        int yBoxValue = this.yBox.isSelected() ? 1 : 0;
        int zBoxValue = this.zBox.isSelected() ? 1 : 0;
        int xRotBoxValue = this.xRotBox.isSelected() ? 1 : 0;
        int yRotBoxValue = this.yRotBox.isSelected() ? 1 : 0;
        int zRotBoxValue = this.zRotBox.isSelected() ? 1 : 0;
        return String.valueOf(xBoxValue) + " " + String.valueOf(yBoxValue) + " " + String.valueOf(zBoxValue) + " " + String.valueOf(xRotBoxValue) + " " + String.valueOf(yRotBoxValue) + " " + String.valueOf(zRotBoxValue);
    }
}

