/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.ACL2Character;
import com.sun.electric.util.acl2.ACL2Complex;
import com.sun.electric.util.acl2.ACL2Integer;
import com.sun.electric.util.acl2.ACL2Rational;
import com.sun.electric.util.acl2.ACL2String;
import com.sun.electric.util.acl2.ACL2Symbol;
import com.sun.electric.util.acl2.Complex;
import com.sun.electric.util.acl2.HonsManager;
import com.sun.electric.util.acl2.Rational;
import java.math.BigInteger;

public abstract class ACL2Object {
    public static final int HASH_CODE_NIL = ACL2Object.hashCodeOf("COMMON-LISP", "NIL");
    public static final int HASH_CODE_T = ACL2Object.hashCodeOf("COMMON-LISP", "T");
    public static final int HASH_CODE_CONS = 7;
    public static final int HASH_MULT_CAR = 17;
    public static final int HASH_MULT_CDR = 41;
    final int hashCode;
    final HonsManager honsOwner;

    ACL2Object(int hashCode, HonsManager honsOwner) {
        this.hashCode = hashCode;
        this.honsOwner = honsOwner;
    }

    public static ACL2Object valueOf(BigInteger v) {
        return new ACL2Integer(v);
    }

    public static int hashCodeOf(BigInteger v) {
        return v.hashCode();
    }

    public static ACL2Object valueOf(long v) {
        return new ACL2Integer(BigInteger.valueOf(v));
    }

    public static int hashCodeOf(long v) {
        if (v > Integer.MAX_VALUE) {
            int hi = (int)(v >> 32);
            int lo = (int)v;
            return 31 * hi + lo;
        }
        if (v < Integer.MIN_VALUE) {
            int hi = (int)(-v >> 32);
            int lo = (int)(-v);
            return -(31 * hi + lo);
        }
        return (int)v;
    }

    public static ACL2Object valueOf(int v) {
        return new ACL2Integer(BigInteger.valueOf(v));
    }

    public static int hashCodeOf(int v) {
        return v;
    }

    static ACL2Object valueOf(Rational r) {
        return r.isInteger() ? new ACL2Integer(r.n) : new ACL2Rational(r);
    }

    static ACL2Object valueOf(Complex c) {
        return c.isRational() ? ACL2Object.valueOf(c.re) : new ACL2Complex(c);
    }

    public static ACL2Object valueOf(String s) {
        return new ACL2String(s);
    }

    public static int hashCodeOf(String s) {
        return s.hashCode();
    }

    public static ACL2Object valueOf(char c) {
        return ACL2Character.intern(c);
    }

    public static int hashCodeOf(char c) {
        return Character.hashCode(c);
    }

    public static ACL2Object valueOf(String pk, String nm) {
        return ACL2Symbol.getPackage(pk).getSymbol(nm);
    }

    public static int hashCodeOf(String pk, String nm) {
        int hash = 3;
        hash = 97 * hash + nm.hashCode();
        hash = 97 * hash + pk.hashCode();
        return hash;
    }

    public static ACL2Object valueOf(boolean v) {
        return v ? ACL2Symbol.T : ACL2Symbol.NIL;
    }

    public static int hashCodeOf(boolean v) {
        return v ? HASH_CODE_T : HASH_CODE_NIL;
    }

    public static int hashCodeOfCons(int hashCar, int hashCdr) {
        return 7 + 17 * hashCar + 41 * hashCdr;
    }

    public boolean bool() {
        return !ACL2Symbol.NIL.equals(this);
    }

    public int intValueExact() {
        throw new ArithmeticException();
    }

    public long longValueExact() {
        throw new ArithmeticException();
    }

    public BigInteger bigIntegerValueExact() {
        throw new ArithmeticException();
    }

    public String stringValueExact() {
        throw new ArithmeticException();
    }

    int len() {
        return 0;
    }

    boolean isACL2Number() {
        return false;
    }

    static ACL2Integer zero() {
        HonsManager hm = HonsManager.current.get();
        return hm.ZERO;
    }

    ACL2Object fix() {
        return this.isACL2Number() ? this : ACL2Object.zero();
    }

    Rational ratfix() {
        return Rational.valueOf(BigInteger.ZERO, BigInteger.ONE);
    }

    ACL2Object unaryMinus() {
        return ACL2Object.zero();
    }

    ACL2Object unarySlash() {
        return ACL2Object.zero();
    }

    ACL2Object binaryPlus(ACL2Object y) {
        return y.fix();
    }

    ACL2Object binaryPlus(ACL2Integer y) {
        return y;
    }

    ACL2Object binaryPlus(ACL2Rational y) {
        return y;
    }

    ACL2Object binaryPlus(ACL2Complex y) {
        return y;
    }

    ACL2Object binaryStar(ACL2Object y) {
        return y.fix();
    }

    ACL2Object binaryStar(ACL2Integer y) {
        return y;
    }

    ACL2Object binaryStar(ACL2Rational y) {
        return y;
    }

    ACL2Object binaryStar(ACL2Complex y) {
        return y;
    }

    int signum() {
        return 0;
    }

    int compareTo(ACL2Object y) {
        return -y.signum();
    }

    int compareTo(ACL2Integer y) {
        return -y.signum();
    }

    int compareTo(ACL2Rational y) {
        return -y.signum();
    }

    int compareTo(ACL2Complex y) {
        return -y.signum();
    }

    static ACL2String emptyStr() {
        HonsManager hm = HonsManager.current.get();
        return hm.EMPTY_STR;
    }

    public abstract String rep();

    public boolean isNormed() {
        return this.honsOwner != null;
    }

    ACL2Object internImpl(HonsManager hm) {
        return this;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.rep();
    }

    public static void initHonsMananger(String name) {
        HonsManager.init(name);
    }

    public static void closeHonsManager() {
        HonsManager.close();
    }
}

