/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import java.math.BigInteger;
import java.util.Map;

public class Vec4Bitxor<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public final Svex<N> x;
    public final Svex<N> y;

    private Vec4Bitxor(Svex<N> x, Svex<N> y) {
        super(FUNCTION, x, y);
        this.x = x;
        this.y = y;
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_BITXOR, 2, "4vec-bitxor");
        }

        public <N extends SvarName> Vec4Bitxor<N> build(Svex<N>[] args) {
            return new Vec4Bitxor<N>(args[0], args[1]);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            Vec4 x = args[0];
            Vec4 y = args[1];
            if (x.isVec2() && y.isVec2()) {
                BigInteger xv = ((Vec2)x).getVal();
                BigInteger yv = ((Vec2)y).getVal();
                return Vec2.valueOf(xv.xor(yv));
            }
            BigInteger xmask = x.getUpper().xor(x.getLower()).or(y.getUpper().xor(y.getLower()));
            return Vec4.valueOf(x.getUpper().xor(y.getUpper()).or(xmask), x.getLower().xor(y.getLower()).andNot(xmask));
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            Svex<N> x = args[0];
            Svex<N> y = args[1];
            Vec4 xv = x.xeval(xevalMemoize);
            Vec4 yv = y.xeval(xevalMemoize);
            BigInteger xZ = xv.getLower().andNot(xv.getUpper());
            BigInteger yZ = yv.getLower().andNot(yv.getUpper());
            BigInteger sharedZs = xZ.and(yZ).and(mask);
            BigInteger xmNonZ = mask.andNot(xZ);
            BigInteger ymNonZ = mask.andNot(yZ);
            if (sharedZs.signum() == 0) {
                return new BigInteger[]{ymNonZ, xmNonZ};
            }
            BigInteger yX = yv.getUpper().andNot(yv.getLower());
            BigInteger ymX = mask.and(yX);
            if (ymX.signum() == 0) {
                return new BigInteger[]{ymNonZ, xmNonZ.or(sharedZs)};
            }
            return new BigInteger[]{ymNonZ.or(sharedZs), xmNonZ};
        }
    }
}

