/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JComponent;

public class MultiLineLabel
extends JComponent {
    private static final long serialVersionUID = 4051045255031894837L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEFAULT_MARGIN = 10;
    public static final int DEFAULT_ALIGN = 0;
    public static final int LEAST_ALLOWED = 200;
    private static final int FOUND = 0;
    private static final int NOT_FOUND = 1;
    private static final int NOT_DONE = 0;
    private static final int DONE = 1;
    private static final char[] WHITE_SPACE = new char[]{' ', '\n', '\t'};
    private static final char[] SPACES = new char[]{' ', '\t'};
    private static final char NEW_LINE = '\n';
    protected Vector<String> line = new Vector();
    protected String labelText;
    protected int numLines;
    protected int marginHeight;
    protected int marginWidth;
    protected int lineHeight;
    protected int lineAscent;
    protected int lineDescent;
    protected int[] lineWidth;
    protected int maxWidth;
    private int maxAllowed = 200;
    private boolean maxAllowedSet = false;
    protected int alignment = 0;

    public MultiLineLabel(String string, int n, int n2, int n3, int n4) {
        this.labelText = string;
        this.marginWidth = n;
        this.marginHeight = n2;
        this.maxAllowed = n3;
        this.maxAllowedSet = true;
        this.alignment = n4;
    }

    public MultiLineLabel(String string, int n, int n2) {
        this.labelText = string;
        this.marginWidth = n;
        this.marginHeight = n2;
    }

    public MultiLineLabel(String string, int n) {
        this.labelText = string;
        this.alignment = n;
    }

    public MultiLineLabel(String string) {
        this.labelText = string;
    }

    int getPosition(String string, int n, char[] cArray, int n2) {
        int n3 = string.length() - 1;
        int n4 = cArray.length;
        int n5 = n;
        if (n2 == 0) {
            boolean bl = false;
            while (!bl) {
                if (++n5 >= n3) {
                    return n3;
                }
                char c = string.charAt(n5);
                for (int i = 0; i < n4; ++i) {
                    if (cArray[i] != c) continue;
                    bl = true;
                }
            }
            return n5;
        }
        if (n2 == 1) {
            boolean bl = false;
            while (!bl) {
                if (++n5 >= n3) {
                    return n3;
                }
                char c = string.charAt(n5);
                bl = true;
                for (int i = 0; i < n4; ++i) {
                    if (cArray[i] != c) continue;
                    bl = false;
                }
            }
            return n5;
        }
        return 0;
    }

    int breakWord(String string, FontMetrics fontMetrics) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length() - 1;
        if (n3 <= 0) {
            return n2;
        }
        while (n < this.maxAllowed && n2 < n3) {
            n = fontMetrics.stringWidth(this.labelText.substring(0, ++n2));
        }
        if (n2 != n3) {
            --n2;
        }
        return n2;
    }

    private void divideLabel() {
        int n;
        int n2;
        this.line.clear();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = n2 = (n = 0);
        int n4 = this.labelText.length() - 1;
        while (n2 < n4) {
            String string;
            int n5 = 0;
            while (n5 < this.maxAllowed && n2 < n4 && this.labelText.charAt(n2) != '\n') {
                n3 = n2;
                n2 = this.getPosition(this.labelText, n2, WHITE_SPACE, 0);
                n5 = fontMetrics.stringWidth(this.labelText.substring(n, n2));
            }
            if (this.labelText.charAt(n2) == '\n') {
                n3 = n2;
            }
            if (n2 == n4 && n5 <= this.maxAllowed) {
                n3 = n2;
                string = this.labelText.substring(n);
                this.line.addElement(string);
            } else {
                if (n3 == n) {
                    n3 = n + this.breakWord(this.labelText.substring(n, n2), fontMetrics);
                }
                string = this.labelText.substring(n, n3);
                this.line.addElement(string);
            }
            n2 = n = this.getPosition(this.labelText, n3, SPACES, 1);
        }
        this.numLines = this.line.size();
        this.lineWidth = new int[this.numLines];
    }

    protected void measure() {
        if (!this.maxAllowedSet) {
            this.maxAllowed = this.getParent().getSize().width;
        }
        if (this.maxAllowed < 20) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.divideLabel();
        this.lineHeight = fontMetrics.getHeight();
        this.lineDescent = fontMetrics.getDescent();
        this.maxWidth = 0;
        for (int i = 0; i < this.numLines; ++i) {
            this.lineWidth[i] = fontMetrics.stringWidth(this.line.elementAt(i));
            if (this.lineWidth[i] <= this.maxWidth) continue;
            this.maxWidth = this.lineWidth[i];
        }
    }

    public void paint(Graphics graphics) {
        this.measure();
        Dimension dimension = this.getSize();
        int n = this.lineAscent + (dimension.height - this.numLines * this.lineHeight) / 2;
        for (int i = 0; i < this.numLines; ++i) {
            int n2;
            n += this.lineHeight;
            switch (this.alignment) {
                case 0: {
                    n2 = this.marginWidth;
                    break;
                }
                case 1: {
                    n2 = (dimension.width - this.lineWidth[i]) / 2;
                    break;
                }
                case 2: {
                    n2 = dimension.width - this.marginWidth - this.lineWidth[i];
                    break;
                }
                default: {
                    n2 = (dimension.width - this.lineWidth[i]) / 2;
                }
            }
            graphics.drawString(this.line.elementAt(i), n2, n);
        }
    }

    public void setText(String string) {
        this.labelText = string;
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public void setColor(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setJustify(int n) {
        this.alignment = n;
        this.repaint();
    }

    public void setMaxWidth(int n) {
        this.maxAllowed = n;
        this.maxAllowedSet = true;
        this.repaint();
    }

    public void setMarginWidth(int n) {
        this.marginWidth = n;
        this.repaint();
    }

    public void setMarginHeight(int n) {
        this.marginHeight = n;
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.maxAllowed = n3;
        this.maxAllowedSet = true;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public Dimension getPreferredSize() {
        this.measure();
        return new Dimension(this.maxAllowed, this.numLines * (this.lineHeight + this.lineAscent + this.lineDescent) + 2 * this.marginHeight);
    }

    public Dimension getMinimumSize() {
        this.measure();
        return new Dimension(this.maxAllowed, this.numLines * (this.lineHeight + this.lineAscent + this.lineDescent) + 2 * this.marginHeight);
    }

    public void addNotify() {
        super.addNotify();
    }
}

