/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.io;

import gnu.prolog.io.PrologStream;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicate_read_term
extends ExecuteOnlyCode {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Environment environment = interpreter.getEnvironment();
        PrologStream stream = environment.resolveStream(args[0]);
        Term optionsList = args[2];
        ReadOptions options = new ReadOptions(environment.getOperatorSet());
        ArrayList<Term> singletons = new ArrayList<Term>();
        ArrayList<Term> variableLists = new ArrayList<Term>();
        ArrayList<Term> vnlists = new ArrayList<Term>();
        Term cur = optionsList;
        while (cur != TermConstants.emptyListAtom) {
            if (cur instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            if (!(cur instanceof CompoundTerm)) {
                PrologException.typeError(TermConstants.listAtom, optionsList);
            }
            CompoundTerm ct = (CompoundTerm)cur;
            if (ct.tag != TermConstants.listTag) {
                PrologException.typeError(TermConstants.listAtom, optionsList);
            }
            Term head = ct.args[0].dereference();
            cur = ct.args[1].dereference();
            if (head instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            if (!(head instanceof CompoundTerm)) {
                PrologException.domainError(TermConstants.readOptionAtom, head);
            }
            CompoundTerm op = (CompoundTerm)head;
            if (op.tag == TermConstants.variablesTag) {
                variableLists.add(op.args[0]);
                continue;
            }
            if (op.tag == TermConstants.singletonsTag) {
                singletons.add(op.args[0]);
                continue;
            }
            if (op.tag == TermConstants.variableNamesTag) {
                vnlists.add(op.args[0]);
                continue;
            }
            PrologException.domainError(TermConstants.readOptionAtom, head);
        }
        Term readTerm = stream.readTerm(args[0], interpreter, options);
        int undoPos = interpreter.getUndoPosition();
        try {
            Term vnlist;
            Term t;
            int rc = interpreter.simpleUnify(args[1], readTerm);
            if (rc == -1) {
                interpreter.undo(undoPos);
                return -1;
            }
            Iterator i = singletons.iterator();
            if (i.hasNext()) {
                Term singletonsList = Predicate_read_term.mapToList(options.singletons);
                while (i.hasNext()) {
                    t = (Term)i.next();
                    rc = interpreter.simpleUnify(t = t.dereference(), singletonsList);
                    if (rc != -1) continue;
                    interpreter.undo(undoPos);
                    return -1;
                }
            }
            if ((i = vnlists.iterator()).hasNext()) {
                vnlist = Predicate_read_term.mapToList(options.variableNames);
                while (i.hasNext()) {
                    t = (Term)i.next();
                    rc = interpreter.simpleUnify(t = t.dereference(), vnlist);
                    if (rc != -1) continue;
                    interpreter.undo(undoPos);
                    return -1;
                }
            }
            if ((i = variableLists.iterator()).hasNext()) {
                vnlist = CompoundTerm.getList(options.variables);
                while (i.hasNext()) {
                    t = (Term)i.next();
                    rc = interpreter.simpleUnify(t = t.dereference(), vnlist);
                    if (rc != -1) continue;
                    interpreter.undo(undoPos);
                    return -1;
                }
            }
            return 1;
        }
        catch (PrologException ex) {
            interpreter.undo(undoPos);
            throw ex;
        }
    }

    private static Term mapToList(Map<String, VariableTerm> map) {
        Term rc = TermConstants.emptyListAtom;
        for (Map.Entry<String, VariableTerm> entry : map.entrySet()) {
            rc = CompoundTerm.getList(new CompoundTerm(TermConstants.unifyTag, AtomTerm.get(entry.getKey()), entry.getValue()), rc);
        }
        return rc;
    }
}

