/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.expr.Target;

public class ConditionalTarget
extends Target {
    public Label ifTrue;
    public Label ifFalse;
    Language language;
    public boolean trueBranchComesFirst = true;

    public ConditionalTarget(Label ifTrue, Label ifFalse, Language language) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.language = language;
    }

    @Override
    public Type getType() {
        return Type.booleanType;
    }

    @Override
    public void compileFromStack(Compilation comp, Type stackType) {
        CodeAttr code = comp.getCode();
        char sig = stackType.getSignature().charAt(0);
        switch (sig) {
            case 'J': {
                code.emitPushLong(0L);
                break;
            }
            case 'D': {
                code.emitPushDouble(0.0);
                break;
            }
            case 'F': {
                code.emitPushFloat(0.0f);
                break;
            }
            default: {
                if (this.trueBranchComesFirst) {
                    code.emitGotoIfIntEqZero(this.ifFalse);
                    code.emitGoto(this.ifTrue);
                } else {
                    code.emitGotoIfIntNeZero(this.ifTrue);
                    code.emitGoto(this.ifFalse);
                }
                return;
            }
            case 'L': 
            case '[': {
                comp.compileConstant(this.language == null ? Boolean.FALSE : this.language.booleanObject(false));
            }
        }
        if (this.trueBranchComesFirst) {
            code.emitGotoIfEq(this.ifFalse);
        } else {
            code.emitGotoIfNE(this.ifTrue);
        }
        this.emitGotoFirstBranch(code);
    }

    public final void emitGotoFirstBranch(CodeAttr code) {
        code.emitGoto(this.trueBranchComesFirst ? this.ifTrue : this.ifFalse);
    }
}

