/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassFileInput;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.ObjectType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class dump
extends ClassFileInput {
    ClassTypeWriter writer;

    dump(InputStream inputStream, ClassTypeWriter classTypeWriter) throws IOException, ClassFormatError {
        super(inputStream);
        this.ctype = new ClassType();
        this.readFormatVersion();
        this.readConstants();
        this.readClassInfo();
        this.readFields();
        this.readMethods();
        this.readAttributes(this.ctype);
        classTypeWriter.print(this.ctype);
        classTypeWriter.flush();
    }

    public ConstantPool readConstants() throws IOException {
        this.ctype.constants = super.readConstants();
        return this.ctype.constants;
    }

    public Attribute readAttribute(String string, int n, AttrContainer attrContainer) throws IOException {
        return super.readAttribute(string, n, attrContainer);
    }

    static int readMagic(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        for (int i = 0; i < 4 && (n = inputStream.read()) >= 0; ++i) {
            n2 = n2 << 8 | n & 0xFF;
        }
        return n2;
    }

    public static void process(InputStream inputStream, String string, OutputStream outputStream, int n) throws IOException {
        dump.process(inputStream, string, new ClassTypeWriter(null, outputStream, n));
    }

    public static void process(InputStream inputStream, String string, Writer writer, int n) throws IOException {
        dump.process(inputStream, string, new ClassTypeWriter(null, writer, n));
    }

    public static void process(InputStream inputStream, String string, ClassTypeWriter classTypeWriter) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ((InputStream)bufferedInputStream).mark(5);
        int n = dump.readMagic(bufferedInputStream);
        if (n == -889275714) {
            classTypeWriter.print("Reading .class from ");
            classTypeWriter.print(string);
            classTypeWriter.println('.');
            new dump(bufferedInputStream, classTypeWriter);
        } else if (n == 1347093252) {
            ZipEntry zipEntry;
            ((InputStream)bufferedInputStream).reset();
            classTypeWriter.print("Reading classes from archive ");
            classTypeWriter.print(string);
            classTypeWriter.println('.');
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    classTypeWriter.print("Archive directory: ");
                    classTypeWriter.print(string2);
                    classTypeWriter.println('.');
                    continue;
                }
                classTypeWriter.println();
                n = dump.readMagic(zipInputStream);
                if (n == -889275714) {
                    classTypeWriter.print("Reading class member: ");
                    classTypeWriter.print(string2);
                    classTypeWriter.println('.');
                    new dump(zipInputStream, classTypeWriter);
                    continue;
                }
                classTypeWriter.print("Skipping non-class member: ");
                classTypeWriter.print(string2);
                classTypeWriter.println('.');
            }
            System.exit(-1);
        } else {
            System.err.println("File " + string + " is not a valid .class file");
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        ClassTypeWriter classTypeWriter = new ClassTypeWriter(null, System.out, 0);
        if (n == 0) {
            dump.usage(System.err);
        }
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string.equals("-verbose") || string.equals("--verbose")) {
                classTypeWriter.setFlags(7);
                continue;
            }
            boolean bl = dump.uriSchemeSpecified(string);
            try {
                InputStream inputStream;
                Object object2;
                if (bl) {
                    if (string.startsWith("jar:")) {
                        int n2;
                        String string2 = string.substring(4);
                        if (!dump.uriSchemeSpecified(string2) && (n2 = string2.indexOf(33)) >= 0) {
                            object2 = string2.substring(0, n2);
                            object2 = new File((String)object2).toURI().toURL().toString();
                            string = "jar:" + (String)object2 + string2.substring(n2);
                        }
                        if (string2.indexOf("!/") < 0 && (n2 = string.lastIndexOf(33)) > 0 && string.indexOf(47, n2) < 0) {
                            string2 = string.substring(n2 + 1);
                            string2 = string2.replace('.', '/');
                            string = string.substring(0, n2 + 1) + '/' + string2 + ".class";
                        }
                    }
                    try {
                        inputStream = new URL(string).openConnection().getInputStream();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.print("File for URL ");
                        System.err.print(string);
                        System.err.println(" not found.");
                        System.exit(-1);
                        inputStream = null;
                    }
                } else {
                    try {
                        inputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        ClassLoader classLoader;
                        try {
                            object2 = ObjectType.getContextClass(string);
                            classLoader = ((Class)object2).getClassLoader();
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            classLoader = ObjectType.getContextClassLoader();
                        }
                        catch (Throwable throwable) {
                            System.err.print("File ");
                            System.err.print(string);
                            System.err.println(" not found.");
                            System.exit(-1);
                            classLoader = null;
                            inputStream = null;
                        }
                        object2 = string.replace('.', '/') + ".class";
                        try {
                            URL uRL = classLoader.getResource((String)object2);
                            inputStream = uRL.openConnection().getInputStream();
                            string = uRL.toString();
                        }
                        catch (Throwable throwable) {
                            System.err.print("Can't find .class file for class ");
                            System.err.print(string);
                            System.err.print(" - ");
                            System.err.println(throwable);
                            System.exit(-1);
                            inputStream = null;
                        }
                    }
                }
                dump.process(inputStream, string, classTypeWriter);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println("caught ");
                System.err.print(iOException);
                System.exit(-1);
            }
        }
    }

    static int uriSchemeLength(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                return i;
            }
            if (!(i == 0 ? !Character.isLetter(c) : !Character.isLetterOrDigit(c) && c != '+' && c != '-' && c != '.')) continue;
            return -1;
        }
        return -1;
    }

    static boolean uriSchemeSpecified(String string) {
        int n = dump.uriSchemeLength(string);
        if (n == 1 && File.separatorChar == '\\') {
            char c = string.charAt(0);
            return !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
        }
        return n > 0;
    }

    public static void usage(PrintStream printStream) {
        printStream.println("Prints and dis-assembles the contents of JVM .class files.");
        printStream.println("Usage: [--verbose] class-or-jar ...");
        printStream.println("where a class-or-jar can be one of:");
        printStream.println("- a fully-qualified class name; or");
        printStream.println("- the name of a .class file, or a URL reference to one; or");
        printStream.println("- the name of a .jar or .zip archive file, or a URL reference to one.");
        printStream.println("If a .jar/.zip archive is named, all its.class file members are printed.");
        printStream.println();
        printStream.println("You can name a single .class member of an archive with a jar: URL,");
        printStream.println("which looks like: jar:jar-spec!/p1/p2/cl.class");
        printStream.println("The jar-spec can be a URL or the name of the .jar file.");
        printStream.println("You can also use the shorthand syntax: jar:jar-spec!p1.p2.cl");
        System.exit(-1);
    }
}

