/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.models;

import gnu.kawa.models.Box;
import gnu.kawa.models.Button;
import gnu.kawa.models.DrawImage;
import gnu.kawa.models.Label;
import gnu.kawa.models.Model;
import gnu.kawa.models.Spacer;
import gnu.kawa.models.Text;
import gnu.kawa.models.Window;
import gnu.lists.FString;
import gnu.mapping.ThreadLocation;
import gnu.mapping.WrappedException;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.lang.reflect.Method;

public abstract class Display {
    public static ThreadLocation myDisplay = new ThreadLocation("my-display");

    /*
     * Loose catch block
     */
    public static Display getInstance() {
        Object object2 = myDisplay.get(null);
        if (object2 instanceof Display) {
            return (Display)object2;
        }
        String string = object2 == null ? "swing" : object2.toString();
        Class[] classArray = new Class[]{};
        while (true) {
            int n = string.indexOf(44);
            String string2 = null;
            if (n >= 0) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if (string.equals("swing")) {
                string = "gnu.kawa.swingviews.SwingDisplay";
            } else if (string.equals("swt")) {
                string = "gnu.kawa.swtviews.SwtDisplay";
            } else if (string.equals("echo2")) {
                string = "gnu.kawa.echo2.Echo2Display";
            }
            try {
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getDeclaredMethod("getInstance", classArray);
                return (Display)method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (string2 == null) {
                    throw new RuntimeException("no display toolkit: " + object2);
                }
                string = string2;
                continue;
            }
            break;
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    public abstract Window makeWindow();

    public abstract void addButton(Button var1, Object var2);

    public abstract void addLabel(Label var1, Object var2);

    public abstract void addImage(DrawImage var1, Object var2);

    public void addText(Text text, Object object2) {
        throw new Error("makeView called on Text");
    }

    public void addSpacer(Spacer spacer, Object object2) {
        throw new Error("makeView called on Spacer");
    }

    public abstract void addBox(Box var1, Object var2);

    public abstract void addView(Object var1, Object var2);

    public static Dimension asDimension(Dimension2D dimension2D) {
        if (dimension2D instanceof Dimension || dimension2D == null) {
            return (Dimension)dimension2D;
        }
        return new Dimension((int)(dimension2D.getWidth() + 0.5), (int)(dimension2D.getHeight() + 0.5));
    }

    public Model coerceToModel(Object object2) {
        if (object2 instanceof FString || object2 instanceof String) {
            return new Label(object2.toString());
        }
        return (Model)object2;
    }
}

