/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.CharSeq;
import gnu.lists.FString;
import gnu.mapping.InPort;
import gnu.text.NullReader;
import gnu.text.Path;
import java.io.IOException;

public class CharArrayInPort
extends InPort {
    static final Path stringPath = Path.valueOf("<string>");

    public CharArrayInPort make(CharSequence charSequence) {
        if (charSequence instanceof FString) {
            FString fString = (FString)charSequence;
            return new CharArrayInPort(fString.data, fString.size);
        }
        int n = charSequence.length();
        char[] cArray = new char[n];
        if (charSequence instanceof String) {
            ((String)charSequence).getChars(0, n, cArray, 0);
        } else if (!(charSequence instanceof CharSeq)) {
            int n2 = n;
            while (--n2 >= 0) {
                cArray[n2] = charSequence.charAt(n2);
            }
        } else {
            ((CharSeq)charSequence).getChars(0, n, cArray, 0);
        }
        return new CharArrayInPort(cArray, n);
    }

    public CharArrayInPort(char[] cArray, int n) {
        super(NullReader.nullReader, stringPath);
        try {
            this.setBuffer(cArray);
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
        this.limit = n;
    }

    public CharArrayInPort(char[] cArray) {
        this(cArray, cArray.length);
    }

    public CharArrayInPort(String string) {
        this(string.toCharArray());
    }

    public int read() throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        return super.read();
    }
}

