/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.Location;
import gnu.mapping.Symbol;
import java.util.Map;

public abstract class NamedLocation
extends IndirectableLocation
implements Map.Entry,
EnvironmentKey {
    NamedLocation next;
    final Symbol name;
    final Object property;

    public boolean entered() {
        return this.next != null;
    }

    public Environment getEnvironment() {
        NamedLocation namedLocation = this;
        while (namedLocation != null) {
            Environment environment;
            if (namedLocation.name == null && (environment = (Environment)namedLocation.value) != null) {
                return environment;
            }
            namedLocation = namedLocation.next;
        }
        return super.getEnvironment();
    }

    public NamedLocation(NamedLocation namedLocation) {
        this.name = namedLocation.name;
        this.property = namedLocation.property;
    }

    public NamedLocation(Symbol symbol, Object object2) {
        this.name = symbol;
        this.property = object2;
    }

    public final Symbol getKeySymbol() {
        return this.name;
    }

    public final Object getKeyProperty() {
        return this.property;
    }

    public final boolean matches(EnvironmentKey environmentKey) {
        return Symbol.equals(environmentKey.getKeySymbol(), this.name) && environmentKey.getKeyProperty() == this.property;
    }

    public final boolean matches(Symbol symbol, Object object2) {
        return Symbol.equals(symbol, this.name) && object2 == this.property;
    }

    public final Object getKey() {
        if (this.property == null) {
            return this.name;
        }
        return this;
    }

    public boolean equals(Object object2) {
        Object object3;
        if (!(object2 instanceof NamedLocation)) {
            return false;
        }
        NamedLocation namedLocation = (NamedLocation)object2;
        if (this.name == null ? namedLocation.name != null : !this.name.equals(namedLocation.name)) {
            return false;
        }
        if (this.property != namedLocation.property) {
            return false;
        }
        Object object4 = this.getValue();
        if (object4 == (object3 = namedLocation.getValue())) {
            return true;
        }
        if (object4 == null || object3 == null) {
            return false;
        }
        return object4.equals(object3);
    }

    public int hashCode() {
        int n = this.name.hashCode() ^ System.identityHashCode(this.property);
        Object object2 = this.getValue();
        if (object2 != null) {
            n ^= object2.hashCode();
        }
        return n;
    }

    public synchronized Object setWithSave(Object object2, CallContext callContext) {
        Object object3;
        if (this.base != null) {
            if (this.value == INDIRECT_FLUIDS) {
                return this.base.setWithSave(object2, callContext);
            }
            object3 = this.base;
            this.base = null;
        } else {
            object3 = this.value;
        }
        this.value = object2;
        callContext.pushFluid(this);
        return object3;
    }

    public synchronized void setRestore(Object object2, CallContext callContext) {
        if (this.value == INDIRECT_FLUIDS) {
            this.base.setRestore(object2, callContext);
        } else {
            if (object2 instanceof Location) {
                this.value = null;
                this.base = (Location)object2;
            } else {
                this.value = object2;
                this.base = null;
            }
            callContext.popFluid();
        }
    }
}

