/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.EnvironmentKey;
import gnu.mapping.Namespace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class Symbol
implements EnvironmentKey,
Comparable,
Externalizable {
    protected String name;
    Namespace namespace;
    public static final Symbol FUNCTION = Symbol.makeUninterned("(function)");
    public static final Symbol PLIST = Symbol.makeUninterned("(property-list)");

    public final Symbol getKeySymbol() {
        return this;
    }

    public final Object getKeyProperty() {
        return null;
    }

    public boolean matches(EnvironmentKey environmentKey) {
        return Symbol.equals(environmentKey.getKeySymbol(), this) && environmentKey.getKeyProperty() == null;
    }

    public boolean matches(Symbol symbol, Object object2) {
        return Symbol.equals(symbol, this) && object2 == null;
    }

    public final String getNamespaceURI() {
        Namespace namespace = this.getNamespace();
        return namespace == null ? null : namespace.getName();
    }

    public final String getLocalPart() {
        return this.name;
    }

    public final String getPrefix() {
        Namespace namespace = this.namespace;
        return namespace == null ? "" : namespace.prefix;
    }

    public final boolean hasEmptyNamespace() {
        String string;
        Namespace namespace = this.getNamespace();
        return namespace == null || (string = namespace.getName()) == null || string.length() == 0;
    }

    public final String getLocalName() {
        return this.name;
    }

    public final String getName() {
        return this.name;
    }

    public static Symbol make(String string, String string2, String string3) {
        return Namespace.make(string, string3).getSymbol(string2.intern());
    }

    public static Symbol make(Object object2, String string) {
        Namespace namespace;
        Namespace namespace2 = namespace = object2 instanceof String ? Namespace.getInstance((String)object2) : (Namespace)object2;
        if (namespace == null || string == null) {
            return Symbol.makeUninterned(string);
        }
        return namespace.getSymbol(string.intern());
    }

    public static Symbol parse(String string) {
        if (string.length() > 0 && string.charAt(0) == '{') {
            int n = string.lastIndexOf(125);
            if (n <= 0) {
                throw new RuntimeException("missing '}' in property name '" + string + "'");
            }
            return Symbol.make(string.substring(1, n), string.substring(n + 1), "");
        }
        int n = string.indexOf(58);
        if (n > 0) {
            return Symbol.makeWithUnknownNamespace(string.substring(n + 1), string.substring(0, n));
        }
        return Symbol.make("", string, "");
    }

    public static Symbol makeWithUnknownNamespace(String string, String string2) {
        return Namespace.makeUnknownNamespace(string2).getSymbol(string.intern());
    }

    public Symbol() {
    }

    public static Symbol makeUninterned(String string) {
        return new Symbol(null, string);
    }

    public Symbol(Namespace namespace, String string) {
        this.name = string;
        this.namespace = namespace;
    }

    public int compareTo(Object object2) {
        Symbol symbol = (Symbol)object2;
        if (this.getNamespaceURI() != symbol.getNamespaceURI()) {
            throw new IllegalArgumentException("comparing Symbols in different namespaces");
        }
        return this.getLocalName().compareTo(symbol.getLocalName());
    }

    public static boolean equals(Symbol symbol, Symbol symbol2) {
        if (symbol == symbol2) {
            return true;
        }
        if (symbol == null || symbol2 == null) {
            return false;
        }
        if (symbol.name == symbol2.name) {
            Namespace namespace = symbol.namespace;
            Namespace namespace2 = symbol2.namespace;
            return namespace != null && namespace2 != null && (namespace == namespace2 || namespace.name == namespace2.name);
        }
        return false;
    }

    public final boolean equals(Object object2) {
        return object2 instanceof Symbol && Symbol.equals(this, (Symbol)object2);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public final Namespace getNamespace() {
        return this.namespace;
    }

    public final void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public String toString() {
        String string = this.getNamespaceURI();
        if (string == null || string.length() == 0) {
            return this.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getPrefix();
        if (string2 == null || string2.length() == 0) {
            stringBuffer.append('{');
            stringBuffer.append(this.getNamespaceURI());
            stringBuffer.append('}');
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(':');
        }
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Namespace namespace = this.getNamespace();
        objectOutput.writeObject(namespace);
        objectOutput.writeObject(this.getName());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.namespace = (Namespace)objectInput.readObject();
        this.name = (String)objectInput.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.namespace == null) {
            return this;
        }
        return Symbol.make(this.namespace, this.getName());
    }
}

