## Copyright (C) 2008 Luca Favatella <slackydeb@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

## Author: Luca Favatella <slackydeb@gmail.com>
## Version: 2.1

function [LB UB] = __ga_popinitrange__ (PopInitRange, nvars)
  switch (columns (PopInitRange))
    case 1
      tmpPIR(1:2, 1:nvars) = PopInitRange(1:2, 1) * ones (1, nvars);
    case nvars
      tmpPIR(1:2, 1:nvars) = PopInitRange(1:2, 1:nvars);
  endswitch
  LB(1, 1:nvars) = tmpPIR(1, 1:nvars);
  UB(1, 1:nvars) = tmpPIR(2, 1:nvars);
endfunction